/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.libs.annoyingapi.command.selector;

import com.srnyx.commandlogger.libs.annoyingapi.command.AnnoyingSender;
import com.srnyx.commandlogger.libs.annoyingapi.command.selector.Selector;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectorOptional<T> {
    @NotNull
    private final AnnoyingSender sender;
    @Nullable
    private final String raw;
    @Nullable
    private final Selector<T> selector;

    public SelectorOptional(@NotNull AnnoyingSender sender, @Nullable String raw, @Nullable Selector<T> selector) {
        this.sender = sender;
        this.raw = raw;
        this.selector = selector;
    }

    @NotNull
    public AnnoyingSender getSender() {
        return this.sender;
    }

    @NotNull
    public String getRaw() {
        if (this.raw == null) {
            throw new IllegalStateException("getRaw() called before checking isEmpty()");
        }
        return this.raw;
    }

    @NotNull
    public Selector<T> getSelector() {
        if (this.selector == null) {
            throw new IllegalStateException("getSelector() called before checking isEmpty()");
        }
        return this.selector;
    }

    public boolean isPresent() {
        return this.selector != null;
    }

    public boolean isEmpty() {
        return this.selector == null;
    }

    @NotNull
    public SelectorOptional<T> mapRaw(@NotNull Function<String, String> mapper) {
        return this.raw == null ? this : new SelectorOptional<T>(this.sender, mapper.apply(this.raw), this.selector);
    }

    @Nullable
    public List<T> orElse(@NotNull Function<String, List<T>> other) {
        if (this.selector == null) {
            return other.apply(this.raw);
        }
        List<T> expanded = this.selector.expand(this.sender);
        if (expanded == null) {
            this.sender.invalidArgument(this.raw);
        }
        return expanded;
    }

    @Nullable
    public List<T> orElseSingle(@NotNull Function<String, T> other) {
        if (this.selector == null) {
            return Collections.singletonList(other.apply(this.raw));
        }
        List<T> expanded = this.selector.expand(this.sender);
        if (expanded == null) {
            this.sender.invalidArgument(this.raw);
        }
        return expanded;
    }

    @Nullable
    public List<T> orElseFlat(@NotNull Function<String, Optional<List<T>>> other) {
        if (this.selector == null) {
            Optional<List<T>> result = other.apply(this.raw);
            if (!result.isPresent()) {
                this.sender.invalidArgument(this.raw);
            }
            return result.orElse(null);
        }
        List<T> expanded = this.selector.expand(this.sender);
        if (expanded == null) {
            this.sender.invalidArgument(this.raw);
        }
        return expanded;
    }

    @Nullable
    public List<T> orElseFlatSingle(@NotNull Function<String, Optional<T>> other) {
        if (this.selector == null) {
            Optional<T> result = other.apply(this.raw);
            if (!result.isPresent()) {
                this.sender.invalidArgument(this.raw);
                return null;
            }
            return Collections.singletonList(result.get());
        }
        List<T> expanded = this.selector.expand(this.sender);
        if (expanded == null) {
            this.sender.invalidArgument(this.raw);
        }
        return expanded;
    }

    @NotNull
    public static <T> SelectorOptional<T> noArgument(@NotNull AnnoyingSender sender) {
        return new SelectorOptional<T>(sender, null, null);
    }

    @NotNull
    public static <T> SelectorOptional<T> noSelector(@NotNull AnnoyingSender sender, @Nullable String raw) {
        return new SelectorOptional<T>(sender, raw, null);
    }

    @NotNull
    public static <T> SelectorOptional<T> of(@NotNull AnnoyingSender sender, @NotNull String input) {
        String inputLower = input.toLowerCase();
        for (Map.Entry<String, Selector<?>> entry : sender.plugin.selectorManager.selectors.entrySet()) {
            if (!entry.getKey().equals(inputLower)) continue;
            return new SelectorOptional(sender, input, entry.getValue());
        }
        return SelectorOptional.noSelector(sender, input);
    }

    @NotNull
    public static <T> SelectorOptional<T> of(@NotNull AnnoyingSender sender, @NotNull String input, @NotNull Class<T> type) {
        String inputLower = input.toLowerCase();
        for (Map.Entry<String, Selector<?>> entry : sender.plugin.selectorManager.selectors.entrySet()) {
            if (!entry.getKey().equals(inputLower) || !type.isAssignableFrom(entry.getValue().getType())) continue;
            return new SelectorOptional(sender, input, entry.getValue());
        }
        return SelectorOptional.noSelector(sender, input);
    }
}

