/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.config;

import com.srnyx.commandlogger.InfoForVariables;
import com.srnyx.commandlogger.config.ConfigYml;
import java.nio.file.Path;
import java.util.Date;
import java.util.Map;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigLogger {
    @NotNull
    public final ConfigYml config;
    @NotNull
    public final String fileName;
    @Nullable
    public final ConfigYml.Filters filters;
    @NotNull
    public final String format;

    public ConfigLogger(@NotNull ConfigYml config, @NotNull Map<?, ?> map) {
        this.config = config;
        String fileName = (String)map.get("file-name");
        if (fileName == null || fileName.trim().isEmpty()) {
            throw new IllegalArgumentException("file-name cannot be null or empty");
        }
        this.fileName = fileName;
        this.filters = ConfigYml.Filters.getFilters((Map)map.get("filters"));
        String format = (String)map.get("format");
        if (format == null || format.trim().isEmpty()) {
            throw new IllegalArgumentException("format cannot be null or empty");
        }
        this.format = format;
    }

    public ConfigLogger(@NotNull ConfigYml config, @NotNull String fileName, @NotNull String format) {
        this.config = config;
        this.fileName = fileName;
        this.filters = null;
        this.format = format;
    }

    @NotNull
    public Path processFileNameVariables(@NotNull String fileName, @NotNull InfoForVariables info) {
        fileName = fileName.replace("/", "\ue000");
        Date now = new Date();
        fileName = fileName.replace("{date}", this.config.variableFormats.date.fileNames.format(now)).replace("{time}", this.config.variableFormats.time.fileNames.format(now));
        fileName = this.config.processVariables(fileName, info);
        return this.config.logsFolder.resolve(fileName.replaceAll("[\\\\/:*?\"<>|]", "_").replaceAll("[. ]+$", "").replace("\ue000", "/"));
    }

    @NotNull
    public Path filePath(@NotNull InfoForVariables info) {
        return this.processFileNameVariables(this.fileName, info);
    }

    @NotNull
    public String format(@NotNull InfoForVariables info) {
        return this.config.processFormatVariables(this.format, info);
    }

    public static class PlayerLogger
    extends ConfigLogger {
        @Nullable
        public final String requiredPermission;

        public PlayerLogger(@NotNull ConfigYml config, @NotNull Map<?, ?> map) {
            super(config, map);
            String requiredPermission = (String)map.get("required-permission");
            this.requiredPermission = requiredPermission != null && requiredPermission.trim().isEmpty() ? null : requiredPermission;
        }

        public PlayerLogger(@NotNull ConfigYml config, @NotNull String fileName, @NotNull String format, @Nullable String requiredPermission) {
            super(config, fileName, format);
            this.requiredPermission = requiredPermission != null && requiredPermission.trim().isEmpty() ? null : requiredPermission;
        }

        public boolean hasRequiredPermission(@NotNull Player player) {
            return this.requiredPermission == null || player.hasPermission(this.requiredPermission);
        }
    }
}

