/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft.tasks;

import cz.softici.server.minecraft.HalloweenPlugin;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PumpkinTask {
    private final HalloweenPlugin plugin;
    private final Player player;
    private int taskId = -1;

    public PumpkinTask(HalloweenPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void scheduleNext() {
        if (!this.plugin.getConfig().getBoolean("events.pumpkin.enabled", true)) {
            return;
        }
        int min = this.plugin.getConfig().getInt("events.pumpkin.min", 5);
        int max = this.plugin.getConfig().getInt("events.pumpkin.max", 15);
        if (min == 0 && max == 0) {
            return;
        }
        long delay = this.minutesToTicks(min + this.plugin.getRandom().nextInt(max - min + 1));
        if (delay < 1L) {
            delay = 20L;
        }
        this.taskId = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.plugin.getData().isGlobalEnabled() && this.plugin.isEligible(this.player)) {
                this.plugin.applyPumpkinIfPossible(this.player, true);
            }
            this.scheduleNext();
        }, delay).getTaskId();
    }

    public void cancel() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
    }

    private long minutesToTicks(int minutes) {
        return (long)minutes * 60L * 20L;
    }
}

