/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft.tasks;

import cz.softici.server.minecraft.HalloweenPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LightningTask {
    private final HalloweenPlugin plugin;
    private final Player player;
    private int taskId = -1;

    public LightningTask(HalloweenPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void scheduleNext() {
        if (!this.plugin.getConfig().getBoolean("events.lightning.enabled", true)) {
            return;
        }
        int min = this.plugin.getConfig().getInt("events.lightning.min", 10);
        int max = this.plugin.getConfig().getInt("events.lightning.max", 20);
        if (min == 0 && max == 0) {
            return;
        }
        long delay = this.minutesToTicks(min + this.plugin.getRandom().nextInt(max - min + 1));
        if (delay < 1L) {
            delay = 20L;
        }
        this.taskId = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.plugin.getData().isGlobalEnabled() && this.plugin.isEligible(this.player)) {
                Location loc = this.player.getLocation();
                boolean damageEnabled = this.plugin.getConfig().getBoolean("events.lightning.damage_enabled", false);
                if (damageEnabled) {
                    this.player.getWorld().strikeLightning(loc);
                } else {
                    this.player.getWorld().strikeLightningEffect(loc);
                }
                this.plugin.sendEventMessage(this.player, this.plugin.getMessages().getRandomMessage("lightning", this.player.getName()));
                this.plugin.playSpookySound(this.player);
            }
            this.scheduleNext();
        }, delay).getTaskId();
    }

    public void cancel() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
    }

    private long minutesToTicks(int minutes) {
        return (long)minutes * 60L * 20L;
    }
}

