/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft.tasks;

import cz.softici.server.minecraft.HalloweenPlugin;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class HerobrineTask {
    private final HalloweenPlugin plugin;
    private final Player player;
    private int taskId = -1;
    private int currentStage = 0;
    private List<ArmorStand> activeHerobrines = new ArrayList<ArmorStand>();
    private boolean sequenceRunning = false;

    public HerobrineTask(HalloweenPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void scheduleNext() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
        if (!this.plugin.getConfig().getBoolean("events.herobrine.enabled", true)) {
            return;
        }
        int min = this.plugin.getConfig().getInt("events.herobrine.min", 20);
        int max = this.plugin.getConfig().getInt("events.herobrine.max", 40);
        if (min == 0 && max == 0) {
            return;
        }
        long delay = this.minutesToTicks(min + this.plugin.getRandom().nextInt(max - min + 1));
        if (delay < 1L) {
            delay = 20L;
        }
        if (!this.isNight()) {
            this.taskId = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.plugin.getData().isGlobalEnabled() && this.plugin.isEligible(this.player)) {
                    this.scheduleNext();
                }
            }, 600L).getTaskId();
            return;
        }
        this.taskId = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.plugin.getData().isGlobalEnabled() && this.plugin.isEligible(this.player) && this.isNight()) {
                this.currentStage = 0;
                this.startProgressiveSpawning();
            } else {
                this.scheduleNext();
            }
        }, delay).getTaskId();
    }

    private void startProgressiveSpawning() {
        if (this.sequenceRunning) {
            this.plugin.getLogger().warning("Herobrine sequence already running for " + this.player.getName() + " - skipping duplicate");
            return;
        }
        this.sequenceRunning = true;
        this.currentStage = 1;
        this.spawnHerobrineWithTimer(3, 10, 20);
    }

    private void spawnHerobrineWithTimer(int chunkDistance, int minDelay, int maxDelay) {
        if (!this.player.isOnline() || !this.isValidSpawnConditions()) {
            return;
        }
        Location spawnLoc = this.findSafeSpawnLocation(chunkDistance);
        if (spawnLoc == null) {
            this.scheduleNextStage(minDelay, maxDelay);
            return;
        }
        ArmorStand herobrine = this.createHerobrineEntity(spawnLoc);
        this.activeHerobrines.add(herobrine);
        this.lookAtPlayer(herobrine, this.player.getLocation());
        String stageName = "herobrine_stage" + this.currentStage;
        this.plugin.sendEventMessage(this.player, this.plugin.getMessages().getRandomMessage(stageName, this.player.getName()));
        this.startProximityCheck(herobrine, 10.0);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (herobrine.isValid()) {
                herobrine.remove();
                this.activeHerobrines.remove(herobrine);
            }
            this.scheduleNextStage(minDelay, maxDelay);
        }, 400L);
    }

    private void scheduleNextStage(int minSeconds, int maxSeconds) {
        if (!this.sequenceRunning || !this.player.isOnline()) {
            this.sequenceRunning = false;
            return;
        }
        int delay = minSeconds + this.plugin.getRandom().nextInt(maxSeconds - minSeconds + 1);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (!(this.plugin.isEligible(this.player) && this.isNight() && this.sequenceRunning)) {
                this.sequenceRunning = false;
                this.removeAllHerobrines();
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::scheduleNext, 100L);
                return;
            }
            ++this.currentStage;
            if (this.currentStage == 2) {
                this.spawnHerobrineWithTimer(2, 10, 20);
            } else if (this.currentStage == 3) {
                this.spawnHerobrineWithTimer(1, 10, 20);
            } else if (this.currentStage == 4) {
                this.finalEncounterInvisible();
                this.sequenceRunning = false;
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::scheduleNext, 100L);
            }
        }, (long)delay * 20L);
    }

    private Location findSafeSpawnLocation(int chunkDistance) {
        if (!this.player.isOnline()) {
            return null;
        }
        Location playerLoc = this.player.getLocation();
        World world = playerLoc.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return null;
        }
        int renderDistance = this.plugin.getConfig().getInt("herobrine.render_distance", 3);
        if (chunkDistance > renderDistance) {
            chunkDistance = renderDistance;
        }
        for (int attempt = 0; attempt < 10; ++attempt) {
            double z;
            int y;
            double angle = this.plugin.getRandom().nextDouble() * Math.PI * 2.0;
            double distance = (double)chunkDistance * 16.0;
            double x = playerLoc.getX() + Math.cos(angle) * distance;
            Location testLoc = new Location(world, x, (double)(y = world.getHighestBlockYAt((int)x, (int)(z = playerLoc.getZ() + Math.sin(angle) * distance)) + 1), z);
            if (!this.isSafeSpawnLocation(testLoc)) continue;
            return testLoc;
        }
        return null;
    }

    private boolean isSafeSpawnLocation(Location loc) {
        if (loc.getBlock().getType() == Material.WATER || loc.clone().add(0.0, -1.0, 0.0).getBlock().getType() == Material.WATER) {
            return false;
        }
        if (loc.getBlock().getLightFromSky() == 0) {
            return false;
        }
        return loc.clone().add(0.0, -1.0, 0.0).getBlock().getType() != Material.AIR;
    }

    private boolean isValidSpawnConditions() {
        if (!this.player.isOnline()) {
            return false;
        }
        World world = this.player.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return false;
        }
        return this.isNight();
    }

    @Deprecated
    private void spawnHerobrine(int chunkDistance) {
        if (!this.player.isOnline()) {
            return;
        }
        int renderDistance = this.plugin.getConfig().getInt("herobrine.render_distance", 3);
        if (chunkDistance > renderDistance) {
            chunkDistance = renderDistance;
        }
        int count = 3 + this.plugin.getRandom().nextInt(2);
        Location playerLoc = this.player.getLocation();
        for (int i = 0; i < count; ++i) {
            double angle = this.plugin.getRandom().nextDouble() * Math.PI * 2.0;
            double distance = (double)chunkDistance * 16.0;
            double x = playerLoc.getX() + Math.cos(angle) * distance;
            double z = playerLoc.getZ() + Math.sin(angle) * distance;
            Location spawnLoc = new Location(playerLoc.getWorld(), x, (double)(playerLoc.getWorld().getHighestBlockYAt((int)x, (int)z) + 1), z);
            ArmorStand herobrine = this.createHerobrineEntity(spawnLoc);
            this.activeHerobrines.add(herobrine);
            this.lookAtPlayer(herobrine, playerLoc);
            if (this.currentStage >= 4) continue;
            this.startProximityCheck(herobrine, 10.0);
        }
        String stageName = "";
        switch (this.currentStage) {
            case 1: {
                stageName = "herobrine_stage1";
                break;
            }
            case 2: {
                stageName = "herobrine_stage2";
                break;
            }
            case 3: {
                stageName = "herobrine_stage3";
            }
        }
        if (!stageName.isEmpty()) {
            this.plugin.sendEventMessage(this.player, this.plugin.getMessages().getRandomMessage(stageName, this.player.getName()));
        }
    }

    private void finalEncounterInvisible() {
        if (!this.player.isOnline()) {
            return;
        }
        Location playerLoc = this.player.getLocation();
        this.player.playSound(playerLoc, Sound.AMBIENT_CAVE, 1.0f, 0.5f);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.player.isOnline()) {
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_ENDERMAN_STARE, 1.0f, 0.5f);
            }
        }, 20L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.player.isOnline()) {
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_WITHER_SPAWN, 0.5f, 0.5f);
            }
        }, 40L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.player.isOnline()) {
                Location behind = this.player.getLocation().clone().add(this.player.getLocation().getDirection().multiply(-2).normalize());
                this.player.getWorld().spawnParticle(Particle.LARGE_SMOKE, behind, 20, 0.5, 0.5, 0.5, 0.02);
                this.player.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, behind, 15, 0.3, 0.5, 0.3, 0.01);
            }
        }, 50L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.player.isOnline()) {
                double targetHealth;
                double currentHealth = this.player.getHealth();
                if (currentHealth > (targetHealth = 1.0)) {
                    this.player.setHealth(targetHealth);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_PLAYER_HURT, 1.0f, 0.8f);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_GENERIC_HURT, 1.0f, 0.6f);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_PLAYER_ATTACK_CRIT, 1.0f, 0.5f);
                }
                this.plugin.sendEventMessage(this.player, this.plugin.getMessages().getRandomMessage("herobrine_stage4", this.player.getName()));
                this.player.getWorld().spawnParticle(Particle.CRIT, this.player.getLocation().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.1);
            }
        }, 60L);
    }

    @Deprecated
    private void finalEncounter() {
        if (!this.player.isOnline()) {
            return;
        }
        Location playerLoc = this.player.getLocation();
        Vector behind = playerLoc.getDirection().multiply(-1).normalize().multiply(5);
        Location spawnLoc = playerLoc.clone().add(behind);
        spawnLoc.setY((double)(playerLoc.getWorld().getHighestBlockYAt(spawnLoc) + 1));
        ArmorStand herobrine = this.createHerobrineEntity(spawnLoc);
        this.activeHerobrines.add(herobrine);
        this.lookAtPlayer(herobrine, playerLoc);
        this.player.playSound(playerLoc, Sound.ENTITY_WITHER_SPAWN, 1.0f, 0.5f);
        this.player.playSound(playerLoc, Sound.AMBIENT_CAVE, 1.0f, 0.5f);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.player.isOnline()) {
                double targetHealth;
                double currentHealth = this.player.getHealth();
                if (currentHealth > (targetHealth = 1.0)) {
                    this.player.setHealth(targetHealth);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_PLAYER_HURT, 1.0f, 1.0f);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_GENERIC_HURT, 1.0f, 0.8f);
                }
                this.plugin.sendEventMessage(this.player, this.plugin.getMessages().getRandomMessage("herobrine_stage4", this.player.getName()));
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::removeAllHerobrines, 60L);
        }, 20L);
    }

    private ArmorStand createHerobrineEntity(Location loc) {
        ArmorStand stand = (ArmorStand)loc.getWorld().spawnEntity(loc, EntityType.ARMOR_STAND);
        stand.setVisible(true);
        stand.setBasePlate(false);
        stand.setArms(true);
        stand.setGravity(false);
        stand.setInvulnerable(true);
        stand.setCustomName("\u00a7fHerobrine");
        stand.setCustomNameVisible(false);
        stand.setMarker(false);
        ItemStack head = this.createHerobrineHead();
        stand.getEquipment().setHelmet(head);
        ItemStack chest = new ItemStack(Material.LEATHER_CHESTPLATE);
        LeatherArmorMeta chestMeta = (LeatherArmorMeta)chest.getItemMeta();
        chestMeta.setColor(Color.fromRGB((int)112, (int)203, (int)211));
        chest.setItemMeta((ItemMeta)chestMeta);
        ItemStack legs = new ItemStack(Material.LEATHER_LEGGINGS);
        LeatherArmorMeta legsMeta = (LeatherArmorMeta)legs.getItemMeta();
        legsMeta.setColor(Color.fromRGB((int)41, (int)42, (int)143));
        legs.setItemMeta((ItemMeta)legsMeta);
        stand.getEquipment().setChestplate(chest);
        stand.getEquipment().setLeggings(legs);
        return stand;
    }

    private ItemStack createHerobrineHead() {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        String VALUE = "ewogICJ0aW1lc3RhbXAiIDogMTc1OTg3MzMzMDYzNywKICAicHJvZmlsZUlkIiA6ICI3OTdhZjc2MjlkMTU0NmE5YWRhOTUyZWQzY2NiMThjNSIsCiAgInByb2ZpbGVOYW1lIiA6ICJHYWx0aG9yaXVzIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzJiYTNiYzNiOGY1YTU4N2JhYTIzOWIxZDFhZTQ0OWVmNTdlOGVhYTcwZTI5ZTU5MGEwNTcyMmU2MWYyODI2YjgiCiAgICB9CiAgfQp9";
        String SIGNATURE = "YckZugg9bRnkPt9W9tUmHOilvjSZhrY3fUHIRSalYGDHE8iJFzvU03dDexQxRyFTGvmX7yyagtzFI8V9phS+Sqjvb9PRQve9zBuBQFpuqgN/Ctik+510xllPcjWCdkZGM96NZXCPZwcSsMDgAdRXwziuWcNwd6HB+54OQTaIGRRbTSDef0/C/0PYfXCJEPc72Lm5kY7n0CmeW+VGUCi/iFXC8mgxgLyOnRf6RGN/FQZ1vhuO6wNpL6X3LudYU6T3jO0U1db8uyYfHYTIi3YI8V+XADGgXXJUFRP0zem0giyVsJKZfNAji0grZ9CKfgRFiRNtMM9vrv4EkTYsq66kqstUy6WUXEO22rbWpyGqD2kZrbEtMzwD5GMSC+KSutUumKDRyFigRPIbByFW6zfzVge1pD8x8yyy5ccNXIVAXn8eYDXT2z5OOmWuj8CbFTLK94Tff4/Pvvr9AnnrDs2sOZUBpJu5v0ccbJYegbBT0LwUkm2cDkLx56WiSGROHCcDoRBhj3MPVO/Shk2KIUPVAYdhkldP2P8mIgvlgRZK4JmYkxasRkuhL/5IhQ+JYa73dID5Sqm22JEmapcj5DE4lnMC2dnrABFWMVfP8kic/JqiUiTOz0sDEr7T6wo+giFOtEWEYhPkseXAnASkZN9PG6Pb+7NsJSPp4rf83BKcEE4=";
        try {
            Method putMethod;
            Class<?> gameProfileClass = Class.forName("com.mojang.authlib.GameProfile");
            Class<?> propertyClass = Class.forName("com.mojang.authlib.properties.Property");
            Object profile = gameProfileClass.getConstructor(UUID.class, String.class).newInstance(UUID.randomUUID(), "Herobrine");
            Object property = propertyClass.getConstructor(String.class, String.class, String.class).newInstance("textures", "ewogICJ0aW1lc3RhbXAiIDogMTc1OTg3MzMzMDYzNywKICAicHJvZmlsZUlkIiA6ICI3OTdhZjc2MjlkMTU0NmE5YWRhOTUyZWQzY2NiMThjNSIsCiAgInByb2ZpbGVOYW1lIiA6ICJHYWx0aG9yaXVzIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzJiYTNiYzNiOGY1YTU4N2JhYTIzOWIxZDFhZTQ0OWVmNTdlOGVhYTcwZTI5ZTU5MGEwNTcyMmU2MWYyODI2YjgiCiAgICB9CiAgfQp9", "YckZugg9bRnkPt9W9tUmHOilvjSZhrY3fUHIRSalYGDHE8iJFzvU03dDexQxRyFTGvmX7yyagtzFI8V9phS+Sqjvb9PRQve9zBuBQFpuqgN/Ctik+510xllPcjWCdkZGM96NZXCPZwcSsMDgAdRXwziuWcNwd6HB+54OQTaIGRRbTSDef0/C/0PYfXCJEPc72Lm5kY7n0CmeW+VGUCi/iFXC8mgxgLyOnRf6RGN/FQZ1vhuO6wNpL6X3LudYU6T3jO0U1db8uyYfHYTIi3YI8V+XADGgXXJUFRP0zem0giyVsJKZfNAji0grZ9CKfgRFiRNtMM9vrv4EkTYsq66kqstUy6WUXEO22rbWpyGqD2kZrbEtMzwD5GMSC+KSutUumKDRyFigRPIbByFW6zfzVge1pD8x8yyy5ccNXIVAXn8eYDXT2z5OOmWuj8CbFTLK94Tff4/Pvvr9AnnrDs2sOZUBpJu5v0ccbJYegbBT0LwUkm2cDkLx56WiSGROHCcDoRBhj3MPVO/Shk2KIUPVAYdhkldP2P8mIgvlgRZK4JmYkxasRkuhL/5IhQ+JYa73dID5Sqm22JEmapcj5DE4lnMC2dnrABFWMVfP8kic/JqiUiTOz0sDEr7T6wo+giFOtEWEYhPkseXAnASkZN9PG6Pb+7NsJSPp4rf83BKcEE4=");
            Object properties = gameProfileClass.getMethod("getProperties", new Class[0]).invoke(profile, new Object[0]);
            Class<?> propertyMapClass = properties.getClass();
            boolean added = false;
            Exception lastException = null;
            try {
                putMethod = propertyMapClass.getMethod("put", Object.class, Object.class);
                putMethod.invoke(properties, "textures", property);
                added = true;
            }
            catch (Exception e) {
                lastException = e;
            }
            if (!added) {
                try {
                    putMethod = propertyMapClass.getMethod("put", String.class, propertyClass);
                    putMethod.invoke(properties, "textures", property);
                    added = true;
                }
                catch (Exception e) {
                    lastException = e;
                }
            }
            if (!added) {
                try {
                    Class<?> multimapClass = Class.forName("com.google.common.collect.Multimap");
                    Method putMethod2 = multimapClass.getMethod("put", Object.class, Object.class);
                    putMethod2.invoke(properties, "textures", property);
                    added = true;
                }
                catch (Exception e) {
                    lastException = e;
                }
            }
            if (!added && lastException != null) {
                throw new Exception("Could not find working put() method for PropertyMap", lastException);
            }
            Field profileField = meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(meta, profile);
        }
        catch (Throwable t) {
            try {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)"Galthorius");
                meta.setOwningPlayer(offlinePlayer);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private void lookAtPlayer(ArmorStand herobrine, Location playerLoc) {
        Location heroLoc = herobrine.getLocation();
        Vector direction = playerLoc.toVector().subtract(heroLoc.toVector()).normalize();
        double dx = direction.getX();
        double dz = direction.getZ();
        double yaw = Math.toDegrees(Math.atan2(-dx, dz));
        heroLoc.setYaw((float)yaw);
        herobrine.teleport(heroLoc);
    }

    private void startProximityCheck(final ArmorStand herobrine, final double maxDistance) {
        new BukkitRunnable(){

            public void run() {
                if (!herobrine.isValid() || !HerobrineTask.this.player.isOnline()) {
                    this.cancel();
                    return;
                }
                if (herobrine.getLocation().distance(HerobrineTask.this.player.getLocation()) < maxDistance) {
                    herobrine.remove();
                    HerobrineTask.this.activeHerobrines.remove(herobrine);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 10L, 10L);
    }

    private void removeAllHerobrines() {
        for (ArmorStand herobrine : this.activeHerobrines) {
            if (!herobrine.isValid()) continue;
            herobrine.remove();
        }
        this.activeHerobrines.clear();
    }

    private boolean isNight() {
        if (!this.player.isOnline()) {
            return false;
        }
        World world = this.player.getWorld();
        long time = world.getTime();
        return time >= 13000L && time <= 23000L;
    }

    public void cancel() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
        this.removeAllHerobrines();
        this.resetSequence();
    }

    public void resetSequence() {
        this.sequenceRunning = false;
        this.currentStage = 0;
    }

    private long minutesToTicks(int minutes) {
        return (long)minutes * 60L * 20L;
    }
}

