/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft.tasks;

import cz.softici.server.minecraft.HalloweenPlugin;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FireTask {
    private final HalloweenPlugin plugin;
    private final Player player;
    private int taskId = -1;

    public FireTask(HalloweenPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void scheduleNext() {
        if (!this.plugin.getConfig().getBoolean("events.fire.enabled", true)) {
            return;
        }
        int min = this.plugin.getConfig().getInt("events.fire.min", 8);
        int max = this.plugin.getConfig().getInt("events.fire.max", 16);
        if (min == 0 && max == 0) {
            return;
        }
        long delay = this.minutesToTicks(min + this.plugin.getRandom().nextInt(max - min + 1));
        if (delay < 1L) {
            delay = 20L;
        }
        this.taskId = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.plugin.getData().isGlobalEnabled() && this.plugin.isEligible(this.player)) {
                boolean damageEnabled = this.plugin.getConfig().getBoolean("events.fire.damage_enabled", false);
                this.plugin.ignitePlayerHarmlessly(this.player, 2, damageEnabled);
                this.plugin.sendEventMessage(this.player, this.plugin.getMessages().getRandomMessage("fire", this.player.getName()));
                this.plugin.playSpookySound(this.player);
            }
            this.scheduleNext();
        }, delay).getTaskId();
    }

    public void cancel() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
    }

    private long minutesToTicks(int minutes) {
        return (long)minutes * 60L * 20L;
    }
}

