/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft.tasks;

import cz.softici.server.minecraft.HalloweenPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DarknessTask {
    private final HalloweenPlugin plugin;
    private final Player player;
    private int taskId = -1;

    public DarknessTask(HalloweenPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void scheduleNext() {
        if (!this.plugin.getConfig().getBoolean("events.darkness.enabled", true)) {
            return;
        }
        int min = this.plugin.getConfig().getInt("events.darkness.min", 10);
        int max = this.plugin.getConfig().getInt("events.darkness.max", 25);
        if (min == 0 && max == 0) {
            return;
        }
        long delay = this.minutesToTicks(min + this.plugin.getRandom().nextInt(max - min + 1));
        if (delay < 1L) {
            delay = 20L;
        }
        this.taskId = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.plugin.getData().isGlobalEnabled() && this.plugin.isEligible(this.player)) {
                int durationSeconds = this.plugin.getConfig().getInt("events.darkness.duration_seconds", 2);
                int durationTicks = durationSeconds * 20;
                this.player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, durationTicks, 0, false, false, true));
                this.player.playSound(this.player.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_CLOSE, 1.0f, 0.5f);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (this.player.isOnline()) {
                        this.player.playSound(this.player.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_OPEN, 0.9f, 0.6f);
                    }
                }, 3L);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (this.player.isOnline()) {
                        this.player.playSound(this.player.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_CLOSE, 0.8f, 0.4f);
                    }
                }, 6L);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (this.player.isOnline()) {
                        this.player.playSound(this.player.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_OPEN, 1.0f, 0.5f);
                    }
                }, 9L);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (this.player.isOnline()) {
                        this.player.playSound(this.player.getLocation(), Sound.AMBIENT_CAVE, 0.4f, 0.5f);
                    }
                }, 5L);
                this.plugin.sendEventMessage(this.player, this.plugin.getMessages().getRandomMessage("darkness", this.player.getName()));
            }
            this.scheduleNext();
        }, delay).getTaskId();
    }

    public void cancel() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
    }

    private long minutesToTicks(int minutes) {
        return (long)minutes * 60L * 20L;
    }
}

