/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft;

import cz.softici.server.minecraft.HalloweenPlugin;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateChecker
implements Listener {
    private final HalloweenPlugin plugin;
    private final int resourceId = 129197;
    private final String currentVersion;
    private String latestVersion = null;
    private boolean updateAvailable = false;
    private boolean checkFailed = false;

    public UpdateChecker(HalloweenPlugin plugin) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
    }

    public void checkForUpdates() {
        if (!this.plugin.getConfig().getBoolean("update_checker.enabled", true)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String apiUrl = "https://api.spiget.org/v2/resources/129197/versions/latest";
                HttpURLConnection connection = (HttpURLConnection)new URL(apiUrl).openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "HalloweenPlugin-UpdateChecker");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    int quoteEnd;
                    int quoteStart;
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    String json = response.toString();
                    int nameIndex = json.indexOf("\"name\":");
                    if (nameIndex >= 0 && (quoteStart = json.indexOf("\"", nameIndex + 7)) >= 0 && (quoteEnd = json.indexOf("\"", quoteStart + 1)) > quoteStart) {
                        this.latestVersion = json.substring(quoteStart + 1, quoteEnd);
                        this.plugin.getLogger().info("\u2713 Successfully parsed latest version: " + this.latestVersion);
                    }
                    if (this.latestVersion == null || this.latestVersion.isEmpty()) {
                        this.plugin.getLogger().warning("\u274c Could not parse version from API response");
                        this.plugin.getLogger().warning("JSON received: " + json);
                        this.checkFailed = true;
                        return;
                    }
                    if (!this.currentVersion.equals(this.latestVersion)) {
                        this.updateAvailable = true;
                        this.plugin.getLogger().info("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
                        this.plugin.getLogger().info("\u2551  \ud83c\udf83 UPDATE AVAILABLE!                                     \u2551");
                        this.plugin.getLogger().info("\u2551  Current: " + String.format("%-48s", this.currentVersion) + "\u2551");
                        this.plugin.getLogger().info("\u2551  Latest:  " + String.format("%-48s", this.latestVersion) + "\u2551");
                        this.plugin.getLogger().info("\u2551  Download: https://www.spigotmc.org/resources/129197/    \u2551");
                        this.plugin.getLogger().info("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                    } else {
                        this.plugin.getLogger().info("\u2705 Halloween Plugin is up to date! (v" + this.currentVersion + ")");
                    }
                } else {
                    this.checkFailed = true;
                    this.plugin.getLogger().warning("\u26a0\ufe0f Could not check for updates (HTTP " + responseCode + ")");
                }
                connection.disconnect();
            }
            catch (Exception e) {
                this.checkFailed = true;
                this.plugin.getLogger().warning("\u26a0\ufe0f Update check failed: " + e.getMessage());
            }
        });
    }

    @EventHandler
    public void onAdminJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("halloween.admin")) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("update_checker.enabled", true)) {
            return;
        }
        if (!this.updateAvailable || this.latestVersion == null) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.isOnline()) {
                this.sendUpdateNotification(player);
            }
        }, 60L);
    }

    private void sendUpdateNotification(Player player) {
        String message = this.plugin.getConfig().getString("update_checker.message", "\u00a76[Halloween] \u00a7eNew version available: \u00a7a%new_version% \u00a77(current: \u00a7c%current_version%\u00a77)\n\u00a7eClick to download: %link%");
        if (message == null || message.isEmpty()) {
            message = "\u00a76[Halloween] \u00a7eNew version available: \u00a7a%new_version% \u00a77(current: \u00a7c%current_version%\u00a77)\n\u00a7eClick to download: %link%";
        }
        message = message.replace("%current_version%", this.currentVersion);
        message = message.replace("%new_version%", this.latestVersion);
        String resourceUrl = "https://www.spigotmc.org/resources/halloween-plugin.129197/updates";
        if (message.contains("%link%")) {
            String[] parts = message.split("%link%");
            if (parts.length > 0) {
                player.sendMessage(parts[0]);
            }
            TextComponent linkComponent = new TextComponent("\u00a7b\u00a7n[Click Here to Download]");
            linkComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, resourceUrl));
            HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7aOpen in browser\n\u00a77" + resourceUrl).create());
            linkComponent.setHoverEvent(hoverEvent);
            player.spigot().sendMessage((BaseComponent)linkComponent);
            if (parts.length > 1) {
                player.sendMessage(parts[1]);
            }
        } else {
            message = message.replace("{link}", resourceUrl);
            player.sendMessage(message);
        }
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public boolean hasCheckFailed() {
        return this.checkFailed;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }
}

