/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft;

import cz.softici.server.minecraft.HalloweenPlugin;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Husk;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class RandomPumpkinMobManager
implements Listener {
    private final HalloweenPlugin plugin;
    private final Set<UUID> pumpkinMobs = new HashSet<UUID>();

    public RandomPumpkinMobManager(HalloweenPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onMobSpawn(CreatureSpawnEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("random_pumpkin_mobs.enabled", true)) {
            return;
        }
        try {
            if (event.getSpawnReason() != CreatureSpawnEvent.SpawnReason.NATURAL && event.getSpawnReason() != CreatureSpawnEvent.SpawnReason.CHUNK_GEN && event.getSpawnReason() != CreatureSpawnEvent.SpawnReason.DEFAULT && event.getSpawnReason() != CreatureSpawnEvent.SpawnReason.SPAWNER) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Zombie || entity instanceof Skeleton || entity instanceof Creeper || entity instanceof Drowned || entity instanceof Husk || entity instanceof Stray || entity instanceof ZombieVillager || entity instanceof PiglinBrute || entity instanceof Piglin || entity instanceof Pillager || entity instanceof Vindicator)) {
            return;
        }
        double chance = this.plugin.getConfig().getDouble("random_pumpkin_mobs.chance", 0.05);
        if (this.plugin.getRandom().nextDouble() < chance) {
            try {
                if (entity.getEquipment() != null) {
                    entity.getEquipment().setHelmet(new ItemStack(Material.CARVED_PUMPKIN));
                    entity.getEquipment().setHelmetDropChance(0.0f);
                    this.pumpkinMobs.add(entity.getUniqueId());
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to add pumpkin to " + String.valueOf(entity.getType()) + ": " + e.getMessage());
            }
        }
    }

    @EventHandler
    public void onPumpkinMobDeath(EntityDeathEvent event) {
        if (!this.pumpkinMobs.contains(event.getEntity().getUniqueId())) {
            return;
        }
        this.pumpkinMobs.remove(event.getEntity().getUniqueId());
        int min = this.plugin.getConfig().getInt("random_pumpkin_mobs.pumpkin_drops.min", 5);
        int max = this.plugin.getConfig().getInt("random_pumpkin_mobs.pumpkin_drops.max", 10);
        int amount = min + this.plugin.getRandom().nextInt(max - min + 1);
        event.getDrops().add(new ItemStack(Material.CARVED_PUMPKIN, amount));
    }
}

