/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft;

import cz.softici.server.minecraft.HalloweenPlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.entity.Bat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class PumpkinWitchManager
implements Listener {
    private final HalloweenPlugin plugin;
    private final Map<UUID, String> pumpkinWitches = new HashMap<UUID, String>();
    private final Map<UUID, WitchBossData> witchData = new HashMap<UUID, WitchBossData>();

    public PumpkinWitchManager(HalloweenPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onFlintAndSteelUse(PlayerInteractEvent event) {
        if (!this.plugin.getData().isGlobalEnabled()) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("pumpkin_skeleton_boss.enabled", true)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getItem() == null || event.getItem().getType() != Material.FLINT_AND_STEEL) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null || clickedBlock.getType() != Material.CARVED_PUMPKIN) {
            return;
        }
        Block lapisBlock = clickedBlock.getRelative(BlockFace.DOWN);
        if (lapisBlock.getType() != Material.LAPIS_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.getData().isDisabled(player.getUniqueId())) {
            player.sendMessage("\u00a7cYou have Halloween disabled! Type \u00a7e/" + this.plugin.getCommandPrefix() + " enable \u00a7cto spawn bosses.");
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        Location spawnLoc = lapisBlock.getLocation().add(0.5, 0.0, 0.5);
        Block pumpkinBlock = clickedBlock;
        player.getWorld().playSound(pumpkinBlock.getLocation(), Sound.ENTITY_WITCH_AMBIENT, 1.0f, 0.5f);
        pumpkinBlock.getWorld().spawnParticle(Particle.WITCH, pumpkinBlock.getLocation().add(0.5, 0.5, 0.5), 30, 0.3, 0.3, 0.3, 0.05);
        ItemStack item = event.getItem();
        if (item.getType() == Material.FLINT_AND_STEEL && item.getItemMeta() instanceof Damageable) {
            Damageable damageable = (Damageable)item.getItemMeta();
            damageable.setDamage(damageable.getDamage() + 1);
            if (damageable.getDamage() >= Material.FLINT_AND_STEEL.getMaxDurability()) {
                player.getInventory().setItemInMainHand(null);
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            } else {
                item.setItemMeta((ItemMeta)damageable);
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            pumpkinBlock.getWorld().spawnParticle(Particle.SOUL, pumpkinBlock.getLocation().add(0.5, 0.5, 0.5), 15, 0.2, 0.2, 0.2, 0.1);
            pumpkinBlock.setType(Material.AIR);
            lapisBlock.setType(Material.AIR);
            this.spawnPumpkinWitch(spawnLoc, player);
        }, 10L);
    }

    private void spawnPumpkinWitch(Location loc, Player creator) {
        Skeleton witch = (Skeleton)loc.getWorld().spawnEntity(loc, EntityType.SKELETON);
        witch.setCustomName("\u00a76\u00a7lHalloween Boss");
        witch.setCustomNameVisible(true);
        witch.getEquipment().setHelmet(new ItemStack(Material.CARVED_PUMPKIN));
        witch.getEquipment().setChestplate(new ItemStack(Material.NETHERITE_CHESTPLATE));
        witch.getEquipment().setLeggings(new ItemStack(Material.NETHERITE_LEGGINGS));
        witch.getEquipment().setBoots(new ItemStack(Material.NETHERITE_BOOTS));
        witch.getEquipment().setItemInMainHand(new ItemStack(Material.BOW));
        witch.getEquipment().setHelmetDropChance(0.0f);
        witch.getEquipment().setChestplateDropChance(0.0f);
        witch.getEquipment().setLeggingsDropChance(0.0f);
        witch.getEquipment().setBootsDropChance(0.0f);
        witch.getEquipment().setItemInMainHandDropChance(0.0f);
        double health = this.plugin.getConfig().getDouble("pumpkin_skeleton_boss.health", 100.0);
        witch.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(health);
        witch.setHealth(health);
        double damageBoost = this.plugin.getConfig().getDouble("pumpkin_skeleton_boss.damage_boost", 3.0);
        witch.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(witch.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getBaseValue() + damageBoost);
        double speedBoost = this.plugin.getConfig().getDouble("pumpkin_skeleton_boss.speed_boost", 0.3);
        witch.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(witch.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getBaseValue() + speedBoost);
        witch.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, Integer.MAX_VALUE, 1, false, false));
        witch.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, Integer.MAX_VALUE, 1, false, false));
        this.pumpkinWitches.put(witch.getUniqueId(), creator.getName());
        WitchBossData bossData = new WitchBossData(witch);
        this.witchData.put(witch.getUniqueId(), bossData);
        this.startMinionSpawning(witch, bossData);
        this.plugin.broadcastAll(this.plugin.getMessages().getRandomMessage("pumpkinWitchSpawn", creator.getName()));
        loc.getWorld().playSound(loc, Sound.ENTITY_WITHER_SPAWN, 1.0f, 1.5f);
        loc.getWorld().playSound(loc, Sound.ENTITY_WITCH_CELEBRATE, 1.0f, 0.7f);
        loc.getWorld().spawnParticle(Particle.WITCH, loc.add(0.0, 1.0, 0.0), 100, 0.5, 1.0, 0.5, 0.1);
    }

    private void startMinionSpawning(Skeleton witch, WitchBossData bossData) {
        int batInterval = this.plugin.getConfig().getInt("pumpkin_skeleton_boss.bat_spawn_interval", 10);
        int phantomInterval = this.plugin.getConfig().getInt("pumpkin_skeleton_boss.phantom_spawn_interval", 60);
        bossData.batTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (witch.isDead() || !witch.isValid()) {
                this.stopMinionSpawning(witch.getUniqueId());
                return;
            }
            if (witch.getTarget() != null && witch.getTarget() instanceof Player) {
                this.spawnBatMinion(witch, bossData);
            }
        }, (long)batInterval * 20L, (long)batInterval * 20L);
        bossData.phantomTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (witch.isDead() || !witch.isValid()) {
                this.stopMinionSpawning(witch.getUniqueId());
                return;
            }
            if (witch.getTarget() != null && witch.getTarget() instanceof Player) {
                this.spawnPhantomMinion(witch, bossData);
            }
        }, (long)phantomInterval * 20L, (long)phantomInterval * 20L);
    }

    private void spawnBatMinion(Skeleton witch, WitchBossData bossData) {
        if (bossData.currentBat != null && !bossData.currentBat.isDead() && bossData.currentBat.isValid()) {
            bossData.currentBat.remove();
        }
        Location spawnLoc = witch.getLocation().clone();
        Bat bat = (Bat)witch.getWorld().spawnEntity(spawnLoc, EntityType.BAT);
        bat.setCustomName("\u00a78Cursed Bat");
        bat.setCustomNameVisible(false);
        if (witch.getTarget() instanceof Player) {
            // empty if block
        }
        bossData.currentBat = bat;
        witch.getWorld().playSound(witch.getLocation(), Sound.ENTITY_BAT_AMBIENT, 1.0f, 0.8f);
    }

    private void spawnPhantomMinion(Skeleton witch, WitchBossData bossData) {
        if (bossData.currentPhantom != null && !bossData.currentPhantom.isDead() && bossData.currentPhantom.isValid()) {
            bossData.currentPhantom.remove();
        }
        Location spawnLoc = witch.getLocation().clone();
        Phantom phantom = (Phantom)witch.getWorld().spawnEntity(spawnLoc, EntityType.PHANTOM);
        phantom.setCustomName("\u00a77Haunting Phantom");
        phantom.setCustomNameVisible(false);
        if (witch.getTarget() instanceof Player) {
            phantom.setTarget(witch.getTarget());
        }
        bossData.currentPhantom = phantom;
        witch.getWorld().playSound(witch.getLocation(), Sound.ENTITY_PHANTOM_AMBIENT, 1.0f, 0.7f);
    }

    private void stopMinionSpawning(UUID witchUUID) {
        WitchBossData bossData = this.witchData.get(witchUUID);
        if (bossData != null) {
            if (bossData.batTask != null) {
                bossData.batTask.cancel();
            }
            if (bossData.phantomTask != null) {
                bossData.phantomTask.cancel();
            }
            if (bossData.currentBat != null && !bossData.currentBat.isDead()) {
                bossData.currentBat.remove();
            }
            if (bossData.currentPhantom != null && !bossData.currentPhantom.isDead()) {
                bossData.currentPhantom.remove();
            }
            this.witchData.remove(witchUUID);
        }
    }

    @EventHandler
    public void onWitchDamagePlayer(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Skeleton)) {
            return;
        }
        Skeleton witch = (Skeleton)event.getDamager();
        if (!this.pumpkinWitches.containsKey(witch.getUniqueId())) {
            return;
        }
    }

    @EventHandler
    public void onWitchDeath(EntityDeathEvent event) {
        if (!(event.getEntity() instanceof Skeleton)) {
            return;
        }
        Skeleton witch = (Skeleton)event.getEntity();
        if (!this.pumpkinWitches.containsKey(witch.getUniqueId())) {
            return;
        }
        String creatorName = this.pumpkinWitches.remove(witch.getUniqueId());
        Player killer = witch.getKiller();
        this.stopMinionSpawning(witch.getUniqueId());
        if (killer != null) {
            event.getDrops().clear();
            event.setDroppedExp(1);
            int baseXpReward = this.plugin.getConfig().getInt("pumpkin_skeleton_boss.xp_reward", 15);
            this.plugin.giveSmartXpReward(killer, baseXpReward, 1.4);
            Location chestLoc = witch.getLocation();
            Block chestBlock = chestLoc.getBlock();
            chestBlock.setType(Material.AIR);
            chestBlock.setType(Material.CHEST);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (chestBlock.getType() == Material.CHEST) {
                    Chest chest = (Chest)chestBlock.getState();
                    try {
                        List rewards = this.plugin.getConfig().getMapList("pumpkin_skeleton_boss.rewards");
                        Random rand = this.plugin.getRandom();
                        for (Map rewardMap : rewards) {
                            try {
                                Material material;
                                int max;
                                String materialName = rewardMap.get("material").toString();
                                int min = Integer.parseInt(rewardMap.get("min").toString());
                                int amount = min == (max = Integer.parseInt(rewardMap.get("max").toString())) ? min : min + rand.nextInt(max - min + 1);
                                if (amount <= 0 || (material = Material.getMaterial((String)materialName)) == null) continue;
                                if (material == Material.POTION) {
                                    ItemStack potion = this.createRandomPotion();
                                    chest.getInventory().addItem(new ItemStack[]{potion});
                                    continue;
                                }
                                chest.getInventory().addItem(new ItemStack[]{new ItemStack(material, amount)});
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().warning("Invalid pumpkin_skeleton_boss reward config: " + e.getMessage());
                            }
                        }
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Could not load pumpkin_skeleton_boss rewards: " + e.getMessage());
                    }
                }
            }, 1L);
            this.plugin.broadcastAll(this.plugin.getMessages().getRandomMessage("pumpkinWitchDefeat", killer.getName()));
            chestLoc.getWorld().playSound(chestLoc, Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 0.8f);
            chestLoc.getWorld().spawnParticle(Particle.WITCH, chestLoc.add(0.0, 1.0, 0.0), 100, 0.5, 0.5, 0.5, 0.1);
        }
    }

    private ItemStack createRandomPotion() {
        PotionEffectType[] potionTypes = new PotionEffectType[]{PotionEffectType.SPEED, PotionEffectType.STRENGTH, PotionEffectType.REGENERATION, PotionEffectType.FIRE_RESISTANCE, PotionEffectType.NIGHT_VISION, PotionEffectType.INVISIBILITY, PotionEffectType.WATER_BREATHING, PotionEffectType.JUMP_BOOST};
        PotionEffectType selectedType = potionTypes[this.plugin.getRandom().nextInt(potionTypes.length)];
        ItemStack potion = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)potion.getItemMeta();
        meta.addCustomEffect(new PotionEffect(selectedType, 3600, 1), true);
        meta.setDisplayName("\u00a75Witch's Brew");
        potion.setItemMeta((ItemMeta)meta);
        return potion;
    }

    public void despawnAllBosses() {
        for (UUID bossId : this.pumpkinWitches.keySet()) {
            this.stopMinionSpawning(bossId);
            block1: for (World world : Bukkit.getWorlds()) {
                for (Skeleton skeleton : world.getEntitiesByClass(Skeleton.class)) {
                    if (!skeleton.getUniqueId().equals(bossId)) continue;
                    skeleton.remove();
                    this.plugin.getLogger().info("Despawned Halloween Boss (Halloween disabled)");
                    continue block1;
                }
            }
        }
        this.pumpkinWitches.clear();
        this.witchData.clear();
    }

    private static class WitchBossData {
        Skeleton witch;
        BukkitTask batTask;
        BukkitTask phantomTask;
        Bat currentBat;
        Phantom currentPhantom;

        WitchBossData(Skeleton witch) {
            this.witch = witch;
        }
    }
}

