/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft;

import cz.softici.server.minecraft.HalloweenPlugin;
import java.time.LocalDate;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.bukkit.event.entity.VillagerCareerChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PumpkinVillagerManager
implements Listener {
    private final HalloweenPlugin plugin;
    private final NamespacedKey pumpkinVillagerKey;
    private final NamespacedKey lastTradeDateKey;
    private final NamespacedKey tradeCountKey;

    public PumpkinVillagerManager(HalloweenPlugin plugin) {
        this.plugin = plugin;
        this.pumpkinVillagerKey = new NamespacedKey((Plugin)plugin, "pumpkin_villager");
        this.lastTradeDateKey = new NamespacedKey((Plugin)plugin, "last_trade_date");
        this.tradeCountKey = new NamespacedKey((Plugin)plugin, "trade_count");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteractVillager(PlayerInteractEntityEvent event) {
        if (!this.plugin.getConfig().getBoolean("pumpkin_villager.enabled", true)) {
            return;
        }
        if (!(event.getRightClicked() instanceof Villager)) {
            return;
        }
        Player player = event.getPlayer();
        Villager villager = (Villager)event.getRightClicked();
        ItemStack item = player.getInventory().getItemInMainHand();
        boolean isPumpkinVillager = villager.getPersistentDataContainer().has(this.pumpkinVillagerKey, PersistentDataType.BYTE);
        if (item.getType() == Material.CARVED_PUMPKIN && !isPumpkinVillager) {
            event.setCancelled(true);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.convertToPumpkinVillager(villager, player, item));
            return;
        }
        if (isPumpkinVillager) {
            this.checkAndResetDailyLimit(villager);
        }
    }

    @EventHandler
    public void onVillagerCareerChange(VillagerCareerChangeEvent event) {
        Villager villager = event.getEntity();
        if (villager.getPersistentDataContainer().has(this.pumpkinVillagerKey, PersistentDataType.BYTE)) {
            event.setCancelled(true);
            villager.setVillagerLevel(1);
            villager.setVillagerExperience(0);
            if (villager.getRecipes().isEmpty()) {
                this.setupPumpkinTrades(villager);
            }
        }
    }

    @EventHandler
    public void onVillagerGainExperience(VillagerAcquireTradeEvent event) {
        if (!(event.getEntity() instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)event.getEntity();
        if (villager.getPersistentDataContainer().has(this.pumpkinVillagerKey, PersistentDataType.BYTE)) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> villager.setVillagerExperience(0));
        }
    }

    private void convertToPumpkinVillager(Villager villager, Player player, ItemStack pumpkin) {
        villager.setProfession(Villager.Profession.TOOLSMITH);
        villager.setVillagerLevel(1);
        villager.setVillagerExperience(0);
        villager.getPersistentDataContainer().set(this.pumpkinVillagerKey, PersistentDataType.BYTE, (Object)1);
        villager.setCustomName("\u00a76Pumpkin Trader");
        villager.setCustomNameVisible(true);
        if (villager.getEquipment() != null) {
            villager.getEquipment().setHelmet(new ItemStack(Material.CARVED_PUMPKIN));
            villager.getEquipment().setHelmetDropChance(0.0f);
        }
        pumpkin.setAmount(pumpkin.getAmount() - 1);
        villager.setRecipes(new ArrayList());
        this.setupPumpkinTrades(villager);
    }

    private void setupPumpkinTrades(Villager villager) {
        ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
        MerchantRecipe recipe1 = new MerchantRecipe(new ItemStack(Material.CARVED_PUMPKIN, 64), 999999);
        recipe1.addIngredient(new ItemStack(Material.EMERALD, 1));
        recipes.add(recipe1);
        MerchantRecipe recipe2 = new MerchantRecipe(new ItemStack(Material.EMERALD, 1), 999999);
        recipe2.addIngredient(new ItemStack(Material.CARVED_PUMPKIN, 64));
        recipes.add(recipe2);
        villager.setRecipes(recipes);
    }

    private void checkAndResetDailyLimit(Villager villager) {
        String today = LocalDate.now().toString();
        String lastTradeDate = (String)villager.getPersistentDataContainer().get(this.lastTradeDateKey, PersistentDataType.STRING);
        if (lastTradeDate == null || !lastTradeDate.equals(today)) {
            villager.getPersistentDataContainer().set(this.lastTradeDateKey, PersistentDataType.STRING, (Object)today);
            villager.getPersistentDataContainer().set(this.tradeCountKey, PersistentDataType.INTEGER, (Object)0);
        }
    }

    public void incrementTradeCount(Villager villager) {
        if (!villager.getPersistentDataContainer().has(this.pumpkinVillagerKey, PersistentDataType.BYTE)) {
            return;
        }
        int currentCount = (Integer)villager.getPersistentDataContainer().getOrDefault(this.tradeCountKey, PersistentDataType.INTEGER, (Object)0);
        villager.getPersistentDataContainer().set(this.tradeCountKey, PersistentDataType.INTEGER, (Object)(currentCount + 1));
        int dailyLimit = this.plugin.getConfig().getInt("pumpkin_villager.daily_limit", 64);
        if (currentCount + 1 >= dailyLimit) {
            villager.setRecipes(new ArrayList());
        }
    }

    public void revertAllVillagers() {
        int count = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Villager villager : world.getEntitiesByClass(Villager.class)) {
                if (!villager.getPersistentDataContainer().has(this.pumpkinVillagerKey, PersistentDataType.BYTE)) continue;
                if (villager.getEquipment() != null) {
                    villager.getEquipment().setHelmet(null);
                }
                villager.setCustomName(null);
                villager.setCustomNameVisible(false);
                villager.setRecipes(new ArrayList());
                villager.getPersistentDataContainer().remove(this.pumpkinVillagerKey);
                villager.getPersistentDataContainer().remove(this.lastTradeDateKey);
                villager.getPersistentDataContainer().remove(this.tradeCountKey);
                villager.setVillagerLevel(1);
                villager.setVillagerExperience(0);
                ++count;
            }
        }
        if (count > 0) {
            this.plugin.getLogger().info("Reverted " + count + " pumpkin villagers to normal (Halloween disabled)");
        }
    }
}

