/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft;

import cz.softici.server.minecraft.HalloweenPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PumpkinProtectorManager
implements Listener {
    private final HalloweenPlugin plugin;

    public PumpkinProtectorManager(HalloweenPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPumpkinPlace(BlockPlaceEvent event) {
        if (!this.plugin.getConfig().getBoolean("pumpkin_protector.enabled", true)) {
            return;
        }
        Block placed = event.getBlockPlaced();
        if (placed.getType() != Material.CARVED_PUMPKIN) {
            return;
        }
        Block middleBlock = placed.getRelative(BlockFace.DOWN);
        if (middleBlock.getType() != Material.GOLD_BLOCK) {
            return;
        }
        Block bottomBlock = middleBlock.getRelative(BlockFace.DOWN);
        if (bottomBlock.getType() != Material.GOLD_BLOCK) {
            return;
        }
        Block leftArm = middleBlock.getRelative(BlockFace.NORTH);
        Block rightArm = middleBlock.getRelative(BlockFace.SOUTH);
        boolean hasArms = false;
        if (leftArm.getType() == Material.GOLD_BLOCK && rightArm.getType() == Material.GOLD_BLOCK) {
            hasArms = true;
        } else {
            leftArm = middleBlock.getRelative(BlockFace.EAST);
            rightArm = middleBlock.getRelative(BlockFace.WEST);
            if (leftArm.getType() == Material.GOLD_BLOCK && rightArm.getType() == Material.GOLD_BLOCK) {
                hasArms = true;
            }
        }
        if (!hasArms) {
            return;
        }
        Player player = event.getPlayer();
        Location spawnLoc = bottomBlock.getLocation().add(0.5, 0.0, 0.5);
        Block finalLeftArm = leftArm;
        Block finalRightArm = rightArm;
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            placed.setType(Material.AIR);
            middleBlock.setType(Material.AIR);
            bottomBlock.setType(Material.AIR);
            finalLeftArm.setType(Material.AIR);
            finalRightArm.setType(Material.AIR);
            this.spawnPumpkinProtector(spawnLoc, player);
        }, 2L);
    }

    private void spawnPumpkinProtector(Location loc, Player creator) {
        IronGolem golem = (IronGolem)loc.getWorld().spawnEntity(loc, EntityType.IRON_GOLEM);
        golem.setCustomName("\u00a76\u00a7lPumpkin Protector");
        golem.setCustomNameVisible(true);
        double health = this.plugin.getConfig().getDouble("pumpkin_protector.health", 200.0);
        golem.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(health);
        golem.setHealth(health);
        double damageBoost = this.plugin.getConfig().getDouble("pumpkin_protector.damage_boost", 5.0);
        golem.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(golem.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getBaseValue() + damageBoost);
        if (golem.getEquipment() != null) {
            ItemStack glowingPumpkin = new ItemStack(Material.CARVED_PUMPKIN);
            golem.getEquipment().setHelmet(glowingPumpkin);
            golem.getEquipment().setHelmetDropChance(0.0f);
        }
        if (this.plugin.getConfig().getBoolean("pumpkin_protector.glow_effect", true)) {
            golem.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, Integer.MAX_VALUE, 0, false, false, false));
        }
        golem.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, Integer.MAX_VALUE, 0, false, false, true));
        golem.setPlayerCreated(true);
        loc.getWorld().playSound(loc, Sound.BLOCK_ANVIL_LAND, 1.0f, 0.8f);
        loc.getWorld().playSound(loc, Sound.ENTITY_IRON_GOLEM_HURT, 1.0f, 0.7f);
        loc.getWorld().spawnParticle(Particle.FLAME, loc.add(0.0, 1.0, 0.0), 50, 0.5, 1.0, 0.5, 0.1);
        loc.getWorld().spawnParticle(Particle.TOTEM_OF_UNDYING, loc, 30, 0.5, 1.0, 0.5, 0.1);
        for (int i = 0; i < 360; i += 20) {
            double angle = Math.toRadians(i);
            double x = Math.cos(angle) * 1.5;
            double z = Math.sin(angle) * 1.5;
            loc.getWorld().spawnParticle(Particle.FLAME, loc.clone().add(x, 1.0, z), 1, 0.0, 0.0, 0.0, 0.0);
        }
        creator.sendMessage("\u00a76\u00a7l\u2728 You've created a Pumpkin Protector! \u00a7eIt will defend you from hostile mobs!");
        if (this.plugin.getConfig().getBoolean("broadcast_events", false)) {
            this.plugin.broadcastAll("\u00a76" + creator.getName() + " \u00a7ehas summoned a \u00a76\u00a7lPumpkin Protector\u00a7e!");
        }
    }
}

