/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft;

import cz.softici.server.minecraft.HalloweenPlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PumpkinMonsterManager
implements Listener {
    private final HalloweenPlugin plugin;
    private final Map<UUID, String> pumpkinMonsters = new HashMap<UUID, String>();

    public PumpkinMonsterManager(HalloweenPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onFlintAndSteelUse(PlayerInteractEvent event) {
        if (!this.plugin.getData().isGlobalEnabled()) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("pumpkin_zombie_boss.enabled", true)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getItem() == null || event.getItem().getType() != Material.FLINT_AND_STEEL) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null || clickedBlock.getType() != Material.CARVED_PUMPKIN) {
            return;
        }
        Block fenceBlock = clickedBlock.getRelative(BlockFace.DOWN);
        String typeName = fenceBlock.getType().name();
        if (!typeName.contains("FENCE")) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.getData().isDisabled(player.getUniqueId())) {
            player.sendMessage("\u00a7cYou have Halloween disabled! Type \u00a7e/" + this.plugin.getCommandPrefix() + " enable \u00a7cto spawn bosses.");
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        Location spawnLoc = fenceBlock.getLocation().add(0.5, 0.0, 0.5);
        Block pumpkinBlock = clickedBlock;
        player.getWorld().playSound(pumpkinBlock.getLocation(), Sound.ITEM_FLINTANDSTEEL_USE, 1.0f, 1.0f);
        pumpkinBlock.getWorld().spawnParticle(Particle.FLAME, pumpkinBlock.getLocation().add(0.5, 0.5, 0.5), 20, 0.3, 0.3, 0.3, 0.02);
        ItemStack item = event.getItem();
        if (item.getType() == Material.FLINT_AND_STEEL && item.getItemMeta() instanceof Damageable) {
            Damageable damageable = (Damageable)item.getItemMeta();
            damageable.setDamage(damageable.getDamage() + 1);
            if (damageable.getDamage() >= Material.FLINT_AND_STEEL.getMaxDurability()) {
                player.getInventory().setItemInMainHand(null);
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            } else {
                item.setItemMeta((ItemMeta)damageable);
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            pumpkinBlock.getWorld().spawnParticle(Particle.LAVA, pumpkinBlock.getLocation().add(0.5, 0.5, 0.5), 10, 0.2, 0.2, 0.2, 0.1);
            pumpkinBlock.setType(Material.AIR);
            fenceBlock.setType(Material.AIR);
            this.spawnPumpkinMonster(spawnLoc, player);
        }, 10L);
    }

    private void spawnPumpkinMonster(Location loc, Player creator) {
        Zombie zombie = (Zombie)loc.getWorld().spawnEntity(loc, EntityType.ZOMBIE);
        zombie.setCustomName("\u00a76\u00a7lPumpkin Monster");
        zombie.setCustomNameVisible(true);
        zombie.getEquipment().setHelmet(new ItemStack(Material.CARVED_PUMPKIN));
        zombie.getEquipment().setChestplate(new ItemStack(Material.DIAMOND_CHESTPLATE));
        zombie.getEquipment().setLeggings(new ItemStack(Material.DIAMOND_LEGGINGS));
        zombie.getEquipment().setBoots(new ItemStack(Material.DIAMOND_BOOTS));
        zombie.getEquipment().setItemInMainHand(new ItemStack(Material.MACE));
        zombie.getEquipment().setHelmetDropChance(0.0f);
        zombie.getEquipment().setChestplateDropChance(0.0f);
        zombie.getEquipment().setLeggingsDropChance(0.0f);
        zombie.getEquipment().setBootsDropChance(0.0f);
        zombie.getEquipment().setItemInMainHandDropChance(0.0f);
        double health = this.plugin.getConfig().getDouble("pumpkin_zombie_boss.health", 100.0);
        zombie.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(health);
        zombie.setHealth(health);
        double damageBoost = this.plugin.getConfig().getDouble("pumpkin_zombie_boss.damage_boost", 2.0);
        zombie.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(zombie.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getBaseValue() + damageBoost);
        double speedBoost = this.plugin.getConfig().getDouble("pumpkin_zombie_boss.speed_boost", 0.3);
        zombie.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(zombie.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getBaseValue() + speedBoost);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, Integer.MAX_VALUE, 1, false, false));
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, Integer.MAX_VALUE, 0, false, false));
        this.pumpkinMonsters.put(zombie.getUniqueId(), creator.getName());
        this.plugin.broadcastAll(this.plugin.getMessages().getRandomMessage("pumpkinMonsterSpawn", creator.getName()));
        loc.getWorld().playSound(loc, Sound.ENTITY_WITHER_SPAWN, 1.0f, 0.8f);
        loc.getWorld().playSound(loc, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 0.7f, 0.5f);
    }

    @EventHandler
    public void onPumpkinMonsterKill(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!(event.getDamager() instanceof Zombie)) {
            return;
        }
        Zombie zombie = (Zombie)event.getDamager();
        if (!this.pumpkinMonsters.containsKey(zombie.getUniqueId())) {
            return;
        }
        Player victim = (Player)event.getEntity();
        if (victim.getHealth() - event.getFinalDamage() <= 0.0) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.sendEventMessage(victim, this.plugin.getMessages().getRandomMessage("pumpkinMonsterKill", victim.getName())), 1L);
        }
    }

    @EventHandler
    public void onPumpkinMonsterDeath(EntityDeathEvent event) {
        if (!(event.getEntity() instanceof Zombie)) {
            return;
        }
        Zombie zombie = (Zombie)event.getEntity();
        if (!this.pumpkinMonsters.containsKey(zombie.getUniqueId())) {
            return;
        }
        String creatorName = this.pumpkinMonsters.remove(zombie.getUniqueId());
        Player killer = zombie.getKiller();
        if (killer != null) {
            event.getDrops().clear();
            event.setDroppedExp(1);
            int baseXpReward = this.plugin.getConfig().getInt("pumpkin_zombie_boss.xp_reward", 10);
            this.plugin.giveSmartXpReward(killer, baseXpReward, 1.0);
            Location chestLoc = zombie.getLocation();
            Block chestBlock = chestLoc.getBlock();
            chestBlock.setType(Material.AIR);
            chestBlock.setType(Material.CHEST);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (chestBlock.getType() == Material.CHEST) {
                    Chest chest = (Chest)chestBlock.getState();
                    try {
                        List rewards = this.plugin.getConfig().getMapList("pumpkin_zombie_boss.rewards");
                        Random rand = this.plugin.getRandom();
                        for (Map rewardMap : rewards) {
                            try {
                                Material material;
                                int max;
                                String materialName = rewardMap.get("material").toString();
                                int min = Integer.parseInt(rewardMap.get("min").toString());
                                int amount = min == (max = Integer.parseInt(rewardMap.get("max").toString())) ? min : min + rand.nextInt(max - min + 1);
                                if (amount <= 0 || (material = Material.getMaterial((String)materialName)) == null) continue;
                                chest.getInventory().addItem(new ItemStack[]{new ItemStack(material, amount)});
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().warning("Invalid pumpkin_zombie_boss reward config: " + e.getMessage());
                            }
                        }
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Could not load pumpkin_zombie_boss rewards: " + e.getMessage());
                    }
                }
            }, 1L);
            this.plugin.broadcastAll(this.plugin.getMessages().getRandomMessage("pumpkinMonsterDefeat", killer.getName()));
            chestLoc.getWorld().playSound(chestLoc, Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
            chestLoc.getWorld().spawnParticle(Particle.TOTEM_OF_UNDYING, chestLoc.add(0.0, 1.0, 0.0), 50, 0.5, 0.5, 0.5, 0.1);
        }
    }

    public void despawnAllBosses() {
        for (UUID bossId : this.pumpkinMonsters.keySet()) {
            block1: for (World world : Bukkit.getWorlds()) {
                for (Zombie zombie : world.getEntitiesByClass(Zombie.class)) {
                    if (!zombie.getUniqueId().equals(bossId)) continue;
                    zombie.remove();
                    this.plugin.getLogger().info("Despawned Pumpkin Monster boss (Halloween disabled)");
                    continue block1;
                }
            }
        }
        this.pumpkinMonsters.clear();
    }
}

