/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft;

import cz.softici.server.minecraft.HalloweenPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final HalloweenPlugin plugin;
    private File file;
    private FileConfiguration config;
    private final Random random = new Random();

    public MessageManager(HalloweenPlugin plugin) {
        this.plugin = plugin;
        this.createOrLoad();
    }

    private void createOrLoad() {
        this.file = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.file.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.mergeDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeDefaults() {
        InputStream defaultStream = null;
        try {
            defaultStream = this.plugin.getResource("messages.yml");
            if (defaultStream == null) {
                return;
            }
            YamlConfiguration defaults = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream, StandardCharsets.UTF_8));
            boolean modified = false;
            int newCategories = 0;
            int newMessages = 0;
            for (String key : defaults.getKeys(false)) {
                List defaultMessages = defaults.getStringList(key);
                if (!this.config.contains(key)) {
                    this.config.set(key, (Object)defaultMessages);
                    modified = true;
                    ++newCategories;
                    continue;
                }
                List existingMessages = this.config.getStringList(key);
                ArrayList<String> combined = new ArrayList<String>(existingMessages);
                for (String defaultMsg : defaultMessages) {
                    if (existingMessages.contains(defaultMsg)) continue;
                    combined.add(defaultMsg);
                    ++newMessages;
                    modified = true;
                }
                if (!modified || combined.size() <= existingMessages.size()) continue;
                this.config.set(key, combined);
            }
            if (modified) {
                this.save();
                if (newCategories > 0) {
                    this.plugin.getLogger().info("\u2713 Added " + newCategories + " new message categories");
                }
                if (newMessages > 0) {
                    this.plugin.getLogger().info("\u2713 Added " + newMessages + " new messages (appended to end)");
                }
            }
        }
        catch (Exception e) {
            String timestamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            File backupFile = new File(this.plugin.getDataFolder(), "messages_" + timestamp + ".backup.yml");
            try {
                Files.copy(this.file.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.plugin.getLogger().warning("\u26a0\ufe0f  Failed to merge messages.yml: " + e.getMessage());
                this.plugin.getLogger().warning("   Backup created: " + backupFile.getName());
                this.plugin.getLogger().warning("   You can recover your custom messages from this backup");
            }
            catch (IOException backupError) {
                this.plugin.getLogger().severe("\u26a0\ufe0f  Failed to backup messages.yml: " + backupError.getMessage());
            }
        }
        finally {
            if (defaultStream != null) {
                try {
                    defaultStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getRandomMessage(String category, String playerName) {
        List list = this.config.getStringList(category);
        if (list == null || list.isEmpty()) {
            return "[Missing message: " + category + "]";
        }
        String msg = (String)list.get(this.random.nextInt(list.size()));
        return msg.replace("%PLAYER%", playerName);
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save messages.yml!");
        }
    }
}

