/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft;

import cz.softici.server.minecraft.BatWitchManager;
import cz.softici.server.minecraft.GraveManager;
import cz.softici.server.minecraft.MessageManager;
import cz.softici.server.minecraft.PlayerDataManager;
import cz.softici.server.minecraft.PumpkinMonsterManager;
import cz.softici.server.minecraft.PumpkinVillagerManager;
import cz.softici.server.minecraft.PumpkinWitchManager;
import cz.softici.server.minecraft.RandomPumpkinMobManager;
import cz.softici.server.minecraft.UpdateChecker;
import cz.softici.server.minecraft.tasks.DarknessTask;
import cz.softici.server.minecraft.tasks.FireTask;
import cz.softici.server.minecraft.tasks.HerobrineTask;
import cz.softici.server.minecraft.tasks.LightningTask;
import cz.softici.server.minecraft.tasks.PumpkinTask;
import cz.softici.server.minecraft.tasks.SlendermanTask;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class HalloweenPlugin
extends JavaPlugin
implements Listener {
    private final Random random = new Random();
    private PlayerDataManager data;
    private MessageManager messages;
    private PumpkinMonsterManager pumpkinMonsterManager;
    private PumpkinWitchManager pumpkinWitchManager;
    private RandomPumpkinMobManager randomPumpkinMobManager;
    private PumpkinVillagerManager pumpkinVillagerManager;
    private GraveManager graveManager;
    private UpdateChecker updateChecker;
    private BatWitchManager batWitchManager;
    private final Set<UUID> fireProtected = new HashSet<UUID>();
    private final Map<UUID, Long> pumpkinHelmetStart = new HashMap<UUID, Long>();
    private final Map<UUID, PumpkinTask> pumpkinTasks = new HashMap<UUID, PumpkinTask>();
    private final Map<UUID, SlendermanTask> slendermanTasks = new HashMap<UUID, SlendermanTask>();
    private final Map<UUID, FireTask> fireTasks = new HashMap<UUID, FireTask>();
    private final Map<UUID, LightningTask> lightningTasks = new HashMap<UUID, LightningTask>();
    private final Map<UUID, DarknessTask> darknessTasks = new HashMap<UUID, DarknessTask>();
    private final Map<UUID, HerobrineTask> herobrineTasks = new HashMap<UUID, HerobrineTask>();
    private String commandPrefix;

    public void onEnable() {
        block8: {
            this.checkForFolderConflicts();
            this.saveDefaultConfig();
            this.reloadConfig();
            this.getConfig().options().copyDefaults(true);
            this.migrateAndMergeConfig();
            this.saveResource("messages.yml", false);
            this.commandPrefix = this.getConfig().getString("command_prefix", "halloween");
            if (this.commandPrefix.isEmpty() || this.commandPrefix.contains(" ")) {
                this.getLogger().warning("Invalid command_prefix in config! Using default 'halloween'");
                this.commandPrefix = "halloween";
            }
            this.data = new PlayerDataManager(this);
            this.data.load();
            this.messages = new MessageManager(this);
            this.pumpkinMonsterManager = new PumpkinMonsterManager(this);
            this.pumpkinWitchManager = new PumpkinWitchManager(this);
            this.randomPumpkinMobManager = new RandomPumpkinMobManager(this);
            this.pumpkinVillagerManager = new PumpkinVillagerManager(this);
            this.graveManager = new GraveManager(this);
            this.updateChecker = new UpdateChecker(this);
            this.batWitchManager = new BatWitchManager(this);
            this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.pumpkinMonsterManager, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.pumpkinWitchManager, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.randomPumpkinMobManager, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.pumpkinVillagerManager, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.graveManager, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.updateChecker, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.batWitchManager, (Plugin)this);
            if (this.commandPrefix.equals("halloween") || this.commandPrefix.equals("hlw")) {
                PluginCommand halloweenCommand = this.getCommand("halloween");
                if (halloweenCommand != null) {
                    halloweenCommand.setExecutor((CommandExecutor)this);
                    halloweenCommand.setTabCompleter((TabCompleter)this);
                }
                this.getLogger().info("\u2705 Using default commands: /halloween, /hlw");
            } else {
                try {
                    this.registerCustomCommand(this.commandPrefix);
                    this.unregisterDefaultCommand("halloween");
                    this.getLogger().info("\u2705 Registered custom command: /" + this.commandPrefix);
                    this.getLogger().info("   \u26a0\ufe0f Unregistered /halloween to avoid conflicts with other plugins");
                    this.getLogger().info("   Use /" + this.commandPrefix + " help for commands");
                }
                catch (Exception e) {
                    this.getLogger().warning("\u26a0\ufe0f Could not register custom command /" + this.commandPrefix);
                    this.getLogger().warning("   Reason: " + e.getMessage());
                    this.getLogger().warning("   Falling back to: /halloween and /hlw");
                    PluginCommand halloweenCommand = this.getCommand("halloween");
                    if (halloweenCommand == null) break block8;
                    halloweenCommand.setExecutor((CommandExecutor)this);
                    halloweenCommand.setTabCompleter((TabCompleter)this);
                }
            }
        }
        this.cleanupAllHerobrines();
        if (this.data.isGlobalEnabled()) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (this.data.isDisabled(p.getUniqueId())) continue;
                this.startTasksForPlayer(p);
            }
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this, this::applyPumpkinBuffs, 20L, 100L);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, this::checkHelmetRewards, 20L, 400L);
        this.updateChecker.checkForUpdates();
        this.getLogger().info("\ud83c\udf83 Halloween Plugin v3.0.0 enabled");
    }

    public void onDisable() {
        this.stopAllTasks();
        this.data.save();
        this.getLogger().info("\ud83c\udf83 Halloween Plugin v3.0.0 disabled");
    }

    private void registerCustomCommand(String commandName) {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            Command customCommand = new Command(commandName){

                public boolean execute(CommandSender sender, String label, String[] args) {
                    return HalloweenPlugin.this.onCommand(sender, this, label, args);
                }

                public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
                    return HalloweenPlugin.this.onTabComplete(sender, this, alias, args);
                }
            };
            customCommand.setDescription("Halloween plugin command (custom alias)");
            customCommand.setUsage("/" + commandName + " [help|enable|disable|on|off|reload|set|reset|buffs]");
            customCommand.setPermission("halloween.base");
            commandMap.register("halloween", customCommand);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register command: " + e.getMessage(), e);
        }
    }

    private void unregisterDefaultCommand(String commandName) {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            Map knownCommands = null;
            Field knownCommandsField = null;
            try {
                knownCommandsField = commandMap.getClass().getDeclaredField("knownCommands");
            }
            catch (NoSuchFieldException e1) {
                try {
                    knownCommandsField = commandMap.getClass().getSuperclass().getDeclaredField("knownCommands");
                }
                catch (NoSuchFieldException e2) {
                    for (Field field : commandMap.getClass().getDeclaredFields()) {
                        if (!Map.class.isAssignableFrom(field.getType())) continue;
                        field.setAccessible(true);
                        Object obj = field.get(commandMap);
                        if (!(obj instanceof Map)) continue;
                        knownCommandsField = field;
                        break;
                    }
                }
            }
            if (knownCommandsField != null) {
                Map commandsMap;
                knownCommandsField.setAccessible(true);
                knownCommands = commandsMap = (Map)knownCommandsField.get(commandMap);
            }
            if (knownCommands == null) {
                this.getLogger().warning("\u26a0\ufe0f Could not access command map via reflection");
                this.getLogger().warning("   /halloween may still be registered on this server type");
                return;
            }
            PluginCommand pluginCommand = this.getCommand(commandName);
            if (pluginCommand != null) {
                pluginCommand.unregister(commandMap);
            }
            knownCommands.remove(commandName);
            knownCommands.remove("halloween:halloween");
            knownCommands.remove("hlw");
            knownCommands.remove("halloween:hlw");
            knownCommands.entrySet().removeIf(entry -> {
                Command cmd = (Command)entry.getValue();
                return cmd instanceof PluginCommand && ((PluginCommand)cmd).getPlugin().equals((Object)this) && (((String)entry.getKey()).equalsIgnoreCase(commandName) || ((String)entry.getKey()).equalsIgnoreCase("hlw") || ((String)entry.getKey()).contains("halloween:"));
            });
            this.getLogger().info("\u2705 Successfully unregistered /" + commandName + " and /hlw");
        }
        catch (Exception e) {
            this.getLogger().warning("\u26a0\ufe0f Could not fully unregister /" + commandName + ": " + e.getMessage());
            this.getLogger().warning("   Server type: " + Bukkit.getServer().getClass().getName());
            this.getLogger().warning("   /halloween may still be registered. This could cause conflicts.");
        }
    }

    private void migrateToV3() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        String timestamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        File backupFile = new File(this.getDataFolder(), "config_" + timestamp + ".backup.yml");
        try {
            if (configFile.exists()) {
                Files.copy(configFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.getLogger().info("\ud83c\udf83 Migrating to v3.0.0");
                this.getLogger().info("   Backup: " + backupFile.getName());
            }
            configFile.delete();
            this.saveDefaultConfig();
            this.reloadConfig();
        }
        catch (Exception e) {
            this.getLogger().warning("Could not migrate to v3.0.0: " + e.getMessage());
            this.getLogger().warning("Skipping migration. You can manually delete config.yml to regenerate.");
        }
    }

    private void checkForFolderConflicts() {
        File pluginsFolder = this.getDataFolder().getParentFile();
        File oldHalloweenFolder = new File(pluginsFolder, "Halloween");
        if (oldHalloweenFolder.exists() && this.isOurPluginFolder(oldHalloweenFolder)) {
            this.getLogger().warning("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
            this.getLogger().warning("\u2551  NOTICE: Config folder changed in v3.0.0!           \u2551");
            this.getLogger().warning("\u2551  OLD: plugins/Halloween/                            \u2551");
            this.getLogger().warning("\u2551  NEW: plugins/Halloween_Softici/                    \u2551");
            this.getLogger().warning("\u2551                                                      \u2551");
            this.getLogger().warning("\u2551  Your old configs are still in plugins/Halloween/   \u2551");
            this.getLogger().warning("\u2551  Copy them to Halloween_Softici/ if you want to     \u2551");
            this.getLogger().warning("\u2551  preserve your settings, or delete Halloween/       \u2551");
            this.getLogger().warning("\u2551  folder to use fresh v3.0.0 defaults.               \u2551");
            this.getLogger().warning("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        }
    }

    private boolean isOurPluginFolder(File folder) {
        File configFile = new File(folder, "config.yml");
        if (!configFile.exists()) {
            return false;
        }
        try {
            Scanner scanner = new Scanner(configFile);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.contains("Halloween Plugin v") && !line.contains("pumpkin_zombie_boss:") && !line.contains("pumpkin_skeleton_boss:") && !line.contains("pumpkin_monster:") && !line.contains("pumpkin_witch:") && !line.contains("Softici")) continue;
                scanner.close();
                return true;
            }
            scanner.close();
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean migrateAndMergeConfig() {
        boolean isMissingMajorSections;
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            return false;
        }
        this.reloadConfig();
        boolean configChanged = false;
        boolean needsCleanup = false;
        this.getConfig().options().copyDefaults(true);
        String configVersion = this.getConfig().getString("config_version", "unknown");
        if (!configVersion.equals("3.0.0")) {
            this.getLogger().info("Detected config version: " + configVersion + " (expected: 3.0.0) - triggering migration");
            this.migrateToV3();
            return true;
        }
        if (this.getConfig().contains("disabledPlayers") || this.getConfig().contains("pumpkinPranked") || this.getConfig().contains("helmetRewarded") || this.getConfig().contains("pumpkinCounts") || this.getConfig().contains("helmetRewardTiers") || this.getConfig().contains("lastHelmetRewards") || this.getConfig().contains("lastPumpkinJoins")) {
            needsCleanup = true;
        }
        boolean bl = isMissingMajorSections = !this.getConfig().contains("pumpkin_zombie_boss") && !this.getConfig().contains("pumpkin_monster") || !this.getConfig().contains("grave") || !this.getConfig().contains("command_prefix");
        if (isMissingMajorSections) {
            this.getLogger().warning("\u26a0\ufe0f  Old config detected! Missing v1.5.0+ features (bosses, graves, buffs)");
            this.getLogger().warning("    Rename config.yml to config.yml.old and restart to regenerate");
        }
        if (this.getConfig().contains("enabled")) {
            this.getLogger().info("Note: 'enabled' in config.yml is deprecated. Use /halloween on|off instead.");
        }
        if (!this.getConfig().contains("command_prefix")) {
            this.getConfig().set("command_prefix", (Object)"halloween");
            configChanged = true;
            this.getLogger().info("Added new config option: command_prefix");
        }
        if (!this.getConfig().contains("broadcast_events")) {
            this.getConfig().set("broadcast_events", (Object)false);
            configChanged = true;
            this.getLogger().info("Added new config option: broadcast_events");
        }
        if (!this.getConfig().contains("pumpkin_zombie_boss") && !this.getConfig().contains("pumpkin_monster")) {
            this.getConfig().set("pumpkin_zombie_boss.enabled", (Object)true);
            this.getConfig().set("pumpkin_zombie_boss.health", (Object)100.0);
            this.getConfig().set("pumpkin_zombie_boss.damage_boost", (Object)2.0);
            this.getConfig().set("pumpkin_zombie_boss.speed_boost", (Object)0.3);
            this.getConfig().set("pumpkin_zombie_boss.xp_reward", (Object)10);
            configChanged = true;
            this.getLogger().info("Added new config section: pumpkin_zombie_boss");
        }
        if (!this.getConfig().contains("pumpkin_skeleton_boss") && !this.getConfig().contains("pumpkin_witch")) {
            this.getConfig().set("pumpkin_skeleton_boss.enabled", (Object)true);
            this.getConfig().set("pumpkin_skeleton_boss.health", (Object)100.0);
            this.getConfig().set("pumpkin_skeleton_boss.damage_boost", (Object)3.0);
            this.getConfig().set("pumpkin_skeleton_boss.speed_boost", (Object)0.3);
            this.getConfig().set("pumpkin_skeleton_boss.xp_reward", (Object)15);
            this.getConfig().set("pumpkin_skeleton_boss.bat_spawn_interval", (Object)10);
            this.getConfig().set("pumpkin_skeleton_boss.phantom_spawn_interval", (Object)60);
            this.getConfig().set("pumpkin_skeleton_boss.minion_range", (Object)20);
            configChanged = true;
            this.getLogger().info("Added new config section: pumpkin_skeleton_boss");
        }
        if (!this.getConfig().contains("random_pumpkin_mobs")) {
            this.getConfig().set("random_pumpkin_mobs.enabled", (Object)true);
            this.getConfig().set("random_pumpkin_mobs.chance", (Object)0.1);
            this.getConfig().set("random_pumpkin_mobs.pumpkin_drops.min", (Object)5);
            this.getConfig().set("random_pumpkin_mobs.pumpkin_drops.max", (Object)10);
            configChanged = true;
            this.getLogger().info("Added new config section: random_pumpkin_mobs");
        }
        if (!this.getConfig().contains("pumpkin_villager")) {
            this.getConfig().set("pumpkin_villager.enabled", (Object)true);
            this.getConfig().set("pumpkin_villager.daily_limit", (Object)64);
            configChanged = true;
            this.getLogger().info("Added new config section: pumpkin_villager");
        }
        if (!this.getConfig().contains("pumpkin_buffs")) {
            this.getConfig().set("pumpkin_buffs.enabled", (Object)true);
            this.getConfig().set("pumpkin_buffs.glowing", (Object)true);
            ArrayList<Map<String, Object>> effects = new ArrayList<Map<String, Object>>();
            effects.add(this.createEffectMap("HASTE", 1, true));
            effects.add(this.createEffectMap("SPEED", 1, true));
            effects.add(this.createEffectMap("STRENGTH", 1, true));
            effects.add(this.createEffectMap("REGENERATION", 1, true));
            effects.add(this.createEffectMap("RESISTANCE", 1, true));
            effects.add(this.createEffectMap("JUMP_BOOST", 1, true));
            this.getConfig().set("pumpkin_buffs.effects", effects);
            configChanged = true;
            this.getLogger().info("Added new config section: pumpkin_buffs");
        }
        if (!this.getConfig().contains("grave")) {
            this.getConfig().set("grave.enabled", (Object)true);
            this.getConfig().set("grave.spawns.skeleton", (Object)3);
            this.getConfig().set("grave.spawns.zombie", (Object)2);
            this.getConfig().set("grave.spawns.skeleton_horse", (Object)2);
            this.getConfig().set("grave.spawns.zombie_horse", (Object)3);
            this.getConfig().set("grave.health_boost", (Object)1.3);
            this.getConfig().set("grave.damage_boost", (Object)1.5);
            this.getConfig().set("grave.speed_boost", (Object)0.2);
            this.getConfig().set("grave.pumpkin_drops_per_mob", (Object)3);
            this.getConfig().set("grave.xp_per_mob", (Object)5);
            this.getConfig().set("grave.rewards.pumpkins_min", (Object)10);
            this.getConfig().set("grave.rewards.pumpkins_max", (Object)32);
            this.getConfig().set("grave.rewards.cakes_min", (Object)2);
            this.getConfig().set("grave.rewards.cakes_max", (Object)5);
            this.getConfig().set("grave.rewards.skeleton_skull_chance", (Object)0.5);
            this.getConfig().set("grave.rewards.zombie_head_chance", (Object)0.5);
            this.getConfig().set("grave.rewards.diamonds", (Object)5);
            this.getConfig().set("grave.rewards.treasure_map", (Object)1);
            configChanged = true;
            this.getLogger().info("Added new config section: grave");
        }
        if (!this.getConfig().contains("events.herobrine")) {
            this.getConfig().set("events.herobrine.min", (Object)40);
            this.getConfig().set("events.herobrine.max", (Object)80);
            this.getConfig().set("events.herobrine.enabled", (Object)true);
            this.getConfig().set("events.herobrine.render_distance", (Object)3);
            configChanged = true;
            this.getLogger().info("Added new config option: events.herobrine");
        }
        if (needsCleanup) {
            this.getLogger().info("Cleaning up config.yml (moving player data to data.yml)...");
            this.getConfig().set("disabledPlayers", null);
            this.getConfig().set("pumpkinPranked", null);
            this.getConfig().set("helmetRewarded", null);
            this.getConfig().set("pumpkinCounts", null);
            this.getConfig().set("helmetRewardTiers", null);
            this.getConfig().set("lastHelmetRewards", null);
            this.getConfig().set("lastPumpkinJoins", null);
            configChanged = true;
            this.getLogger().info("\u2713 Config cleanup complete");
        }
        if (configChanged) {
            this.saveConfig();
            this.getLogger().info("\u2713 Config updated with missing sections");
        }
        return configChanged || needsCleanup;
    }

    private Map<String, Object> createEffectMap(String type, int level, boolean enabled) {
        HashMap<String, Object> effect = new HashMap<String, Object>();
        effect.put("type", type);
        effect.put("level", level);
        effect.put("enabled", enabled);
        return effect;
    }

    public PlayerDataManager getData() {
        return this.data;
    }

    public MessageManager getMessages() {
        return this.messages;
    }

    public MessageManager getMessageManager() {
        return this.messages;
    }

    public Random getRandom() {
        return this.random;
    }

    public PumpkinMonsterManager getPumpkinMonsterManager() {
        return this.pumpkinMonsterManager;
    }

    public PumpkinWitchManager getPumpkinWitchManager() {
        return this.pumpkinWitchManager;
    }

    public PumpkinVillagerManager getPumpkinVillagerManager() {
        return this.pumpkinVillagerManager;
    }

    public GraveManager getGraveManager() {
        return this.graveManager;
    }

    public String getCommandPrefix() {
        return this.commandPrefix;
    }

    public void giveSmartXpReward(Player player, int baseReward, double multiplier) {
        int currentLevel = player.getLevel();
        int baseXpAmount = baseReward * 7;
        int adjustedXpAmount = (int)((double)baseXpAmount * multiplier);
        if (currentLevel >= 30) {
            player.giveExp(adjustedXpAmount);
            int xpForNextLevel = player.getExpToLevel();
            double levelsGained = (double)adjustedXpAmount / (double)xpForNextLevel;
            if (levelsGained >= 0.1) {
                player.sendMessage(String.format("\u00a76+%d XP \u00a77(~%.1f levels)", adjustedXpAmount, levelsGained));
            } else {
                player.sendMessage(String.format("\u00a76+%d XP", adjustedXpAmount));
            }
        } else {
            int levelsToGive = Math.max(1, adjustedXpAmount / 20);
            player.giveExpLevels(levelsToGive);
            player.sendMessage(String.format("\u00a76+%d Levels", levelsToGive));
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (this.data.isGlobalEnabled()) {
            if (!this.data.isDisabled(p.getUniqueId())) {
                this.startTasksForPlayer(p);
                boolean loginPumpkinEnabled = this.getConfig().getBoolean("login_pumpkin.enabled", true);
                int cooldownMinutes = this.getConfig().getInt("login_pumpkin.cooldown_minutes", 30);
                if (loginPumpkinEnabled && (p.getInventory().getHelmet() == null || p.getInventory().getHelmet().getType() != Material.CARVED_PUMPKIN)) {
                    if (this.data.canReceiveJoinPumpkin(p.getUniqueId(), cooldownMinutes)) {
                        this.applyPumpkinIfPossible(p, false);
                        this.data.setLastPumpkinJoin(p.getUniqueId());
                        this.data.saveAsync();
                    } else {
                        long remainingMs = this.data.getRemainingCooldown(p.getUniqueId(), cooldownMinutes);
                        long remainingMin = remainingMs / 60000L;
                        p.sendMessage("\u00a7e\ud83c\udf83 You're on pumpkin cooldown! Wait " + remainingMin + " more minutes.");
                    }
                }
                this.playSpookySound(p);
                p.sendMessage("\u00a76\ud83d\udc7b Spooky times have arrived... Type \u00a7e/" + this.commandPrefix + " disable \u00a76if you don't dare to be cursed.");
            } else {
                p.sendMessage("\u00a77\ud83d\udc7b Halloween event is active! Type \u00a7e/" + this.commandPrefix + " enable \u00a77to join the fun.");
            }
        } else if (!this.data.isDisabled(p.getUniqueId())) {
            p.sendMessage("\u00a77\ud83c\udf83 Halloween event is currently disabled by admins.");
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        p.setGlowing(false);
        this.stopTasksForPlayer(p);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        if (!this.fireProtected.contains(p.getUniqueId())) {
            return;
        }
        switch (e.getCause()) {
            case FIRE: 
            case FIRE_TICK: 
            case LIGHTNING: {
                e.setCancelled(true);
                e.setDamage(0.0);
                break;
            }
        }
    }

    public boolean isEligible(Player p) {
        return p != null && p.isOnline() && !this.data.isDisabled(p.getUniqueId());
    }

    public void broadcastAll(String msg) {
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (this.data.isDisabled(online.getUniqueId())) continue;
            online.sendMessage(msg);
        }
    }

    public void sendEventMessage(Player targetPlayer, String msg) {
        if (this.getConfig().getBoolean("broadcast_events", false)) {
            this.broadcastAll(msg);
        } else if (!this.data.isDisabled(targetPlayer.getUniqueId())) {
            targetPlayer.sendMessage(msg);
        }
    }

    public void playSpookySound(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 1.0f, 1.0f);
        player.playSound(player.getLocation(), Sound.AMBIENT_CAVE, 0.7f, 0.5f);
    }

    public void applyPumpkinIfPossible(Player player, boolean broadcast) {
        boolean hasSpace;
        if (player == null || !player.isOnline()) {
            return;
        }
        ItemStack pumpkin = new ItemStack(Material.CARVED_PUMPKIN);
        boolean bl = hasSpace = player.getInventory().firstEmpty() != -1;
        if (player.getInventory().getHelmet() == null) {
            if (hasSpace) {
                player.getInventory().setHelmet(pumpkin);
                this.afterPumpkinApplied(player, broadcast);
            }
        } else if (hasSpace) {
            ItemStack currentHelmet = player.getInventory().getHelmet();
            player.getInventory().addItem(new ItemStack[]{currentHelmet});
            player.getInventory().setHelmet(pumpkin);
            this.afterPumpkinApplied(player, broadcast);
        }
    }

    private void afterPumpkinApplied(Player player, boolean broadcast) {
        int count;
        this.playSpookySound(player);
        if (broadcast) {
            this.sendEventMessage(player, this.messages.getRandomMessage("pumpkin", player.getName()));
        }
        if ((count = this.data.incrementPumpkinCount(player.getUniqueId())) == 3 && !this.data.hasPumpkinPrank(player.getUniqueId())) {
            this.fillFreeSlotsWithPumpkins(player);
            this.data.setPumpkinPrank(player.getUniqueId(), true);
            this.sendEventMessage(player, this.messages.getRandomMessage("pumpkinEasterEgg", player.getName()));
        }
        this.data.saveAsync();
    }

    private void fillFreeSlotsWithPumpkins(Player p) {
        ItemStack stack = new ItemStack(Material.CARVED_PUMPKIN, 64);
        for (int i = 0; i < p.getInventory().getSize(); ++i) {
            if (p.getInventory().getItem(i) != null) continue;
            p.getInventory().setItem(i, stack.clone());
        }
        p.sendMessage("\ud83c\udf83 Surprise! Your love for pumpkins has been\u2026 noted.");
    }

    public void ignitePlayerHarmlessly(Player p, int seconds, boolean allowDamage) {
        if (p == null || !p.isOnline()) {
            return;
        }
        if (!allowDamage) {
            this.fireProtected.add(p.getUniqueId());
        }
        p.setFireTicks(seconds * 20);
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            if (!allowDamage) {
                this.fireProtected.remove(p.getUniqueId());
            }
            p.setFireTicks(0);
        }, (long)seconds * 20L + 1L);
    }

    private void applyPumpkinBuffs() {
        if (!this.getConfig().getBoolean("pumpkin_buffs.enabled", true)) {
            return;
        }
        boolean glowing = this.getConfig().getBoolean("pumpkin_buffs.glowing", true);
        int duration = this.getConfig().getInt("pumpkin_buffs.duration", 15);
        int durationTicks = duration * 20;
        for (Player p : Bukkit.getOnlinePlayers()) {
            String typeName;
            List effects;
            if (p.getInventory().getHelmet() != null && p.getInventory().getHelmet().getType() == Material.CARVED_PUMPKIN) {
                if (this.getConfig().contains("pumpkin_buffs.effects")) {
                    effects = this.getConfig().getMapList("pumpkin_buffs.effects");
                    for (Map effectMap : effects) {
                        try {
                            if (effectMap.get("enabled") != null && !Boolean.parseBoolean(effectMap.get("enabled").toString())) continue;
                            typeName = effectMap.get("type").toString();
                            int level = Integer.parseInt(effectMap.get("level").toString());
                            PotionEffectType effectType = PotionEffectType.getByName((String)typeName);
                            if (effectType == null) continue;
                            p.addPotionEffect(new PotionEffect(effectType, durationTicks, level, true, false, true));
                        }
                        catch (Exception typeName2) {}
                    }
                }
                if (!glowing) continue;
                p.setGlowing(true);
                continue;
            }
            if (this.getConfig().contains("pumpkin_buffs.effects")) {
                effects = this.getConfig().getMapList("pumpkin_buffs.effects");
                for (Map effectMap : effects) {
                    try {
                        typeName = effectMap.get("type").toString();
                        PotionEffectType effectType = PotionEffectType.getByName((String)typeName);
                        if (effectType == null || !p.hasPotionEffect(effectType)) continue;
                        p.removePotionEffect(effectType);
                    }
                    catch (Exception exception) {}
                }
            }
            p.setGlowing(false);
        }
    }

    private void checkHelmetRewards() {
        if (!this.getConfig().getBoolean("helmet_rewards.enabled", true)) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!this.isEligible(p)) continue;
            UUID id = p.getUniqueId();
            if (p.getInventory().getHelmet() == null) {
                this.pumpkinHelmetStart.remove(id);
                continue;
            }
            if (p.getInventory().getHelmet().getType() == Material.CARVED_PUMPKIN) {
                boolean firstReward;
                this.pumpkinHelmetStart.putIfAbsent(id, System.currentTimeMillis());
                long start = this.pumpkinHelmetStart.get(id);
                long elapsed = System.currentTimeMillis() - start;
                long lastReward = this.data.getLastHelmetReward(id);
                int currentTier = this.data.getHelmetRewardTier(id);
                int requiredMinutes = this.data.getRequiredMinutesForTier(currentTier);
                long requiredMillis = (long)requiredMinutes * 60L * 1000L;
                long timeSinceLastReward = System.currentTimeMillis() - lastReward;
                boolean bl = firstReward = lastReward == 0L;
                if ((!firstReward || elapsed < requiredMillis) && (firstReward || timeSinceLastReward < requiredMillis)) continue;
                p.getInventory().addItem(new ItemStack[]{new ItemStack(Material.CAKE)});
                this.data.incrementHelmetRewardTier(id);
                this.data.setLastHelmetReward(id, System.currentTimeMillis());
                if (!this.data.hasHelmetReward(id)) {
                    this.data.setHelmetReward(id, true);
                }
                int nextTier = this.data.getHelmetRewardTier(id);
                int nextMinutes = this.data.getRequiredMinutesForTier(nextTier);
                this.broadcastAll(this.messages.getRandomMessage("helmetReward", p.getName()));
                p.sendMessage(String.format("\u00a76\ud83c\udf70 Next reward in %d minutes of continuous pumpkin wearing!", nextMinutes));
                this.data.saveAsync();
                continue;
            }
            this.pumpkinHelmetStart.remove(id);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("Halloween plugin by Softici s.r.o.");
            return true;
        }
        String sub = args[0].toLowerCase(Locale.ROOT);
        if (sub.equals("help")) {
            String cmdPrefix = "/" + this.commandPrefix;
            sender.sendMessage("\u00a76=== Halloween Plugin Commands ===");
            sender.sendMessage("\u00a7e" + cmdPrefix + " help \u00a77- Show commands");
            sender.sendMessage("\u00a7e" + cmdPrefix + " enable|disable \u00a77- Player controls");
            sender.sendMessage("\u00a7c=== Admin Commands ===");
            sender.sendMessage("\u00a7e" + cmdPrefix + " on|off \u00a77- Global toggle");
            sender.sendMessage("\u00a7e" + cmdPrefix + " set <action> <min> <max> \u00a77- Adjust intervals");
            sender.sendMessage("\u00a7e" + cmdPrefix + " reset <pumpkin|helmet|all> \u00a77- Reset states");
            sender.sendMessage("\u00a7e" + cmdPrefix + " reload \u00a77- Reload configs");
            sender.sendMessage("\u00a7e" + cmdPrefix + " sound <player|@a> <sound> \u00a77- Play horror sound");
            sender.sendMessage("\u00a7e" + cmdPrefix + " buffs list \u00a77- List all pumpkin buffs");
            sender.sendMessage("\u00a7e" + cmdPrefix + " buffs toggle \u00a77- Toggle all buffs on/off");
            sender.sendMessage("\u00a7e" + cmdPrefix + " buffs glow <on|off> \u00a77- Toggle glowing effect");
            sender.sendMessage("\u00a7e" + cmdPrefix + " buffs add <effect> <level> \u00a77- Add a buff");
            sender.sendMessage("\u00a7e" + cmdPrefix + " buffs remove <effect> \u00a77- Remove a buff");
            sender.sendMessage("\u00a7e" + cmdPrefix + " buffs enable <effect> \u00a77- Enable a buff");
            sender.sendMessage("\u00a7e" + cmdPrefix + " buffs disable <effect> \u00a77- Disable a buff");
            sender.sendMessage("\u00a7e" + cmdPrefix + " buffs level <effect> <level> \u00a77- Change buff level");
            sender.sendMessage("\u00a7e" + cmdPrefix + " cleanup \u00a77- Remove leftover Herobrine entities");
            return true;
        }
        if (sub.equals("enable") || sub.equals("disable")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Only players can use this command.");
                return true;
            }
            Player p = (Player)sender;
            boolean disable = sub.equals("disable");
            this.data.setDisabled(p.getUniqueId(), disable);
            this.data.saveAsync();
            p.sendMessage("\ud83c\udf83 Halloween effects " + (disable ? "disabled" : "enabled") + " for you.");
            return true;
        }
        if (!sender.hasPermission("halloween.use")) {
            sender.sendMessage("You don't have permission.");
            return true;
        }
        switch (sub) {
            case "on": {
                this.data.setGlobalEnabled(true);
                this.data.saveAsync();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    this.startTasksForPlayer(p);
                }
                this.broadcastAll("\ud83c\udf83 Halloween mode ENABLED!");
                break;
            }
            case "off": {
                this.data.setGlobalEnabled(false);
                this.data.saveAsync();
                this.stopAllTasks();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    p.setGlowing(false);
                }
                this.pumpkinMonsterManager.despawnAllBosses();
                this.pumpkinWitchManager.despawnAllBosses();
                this.graveManager.despawnAllGraves();
                this.batWitchManager.despawnAllWitches();
                this.pumpkinVillagerManager.revertAllVillagers();
                this.broadcastAll("\ud83d\udd6f\ufe0f Halloween mode DISABLED.");
                sender.sendMessage("\u00a77All bosses, graves, bat witches, and villagers have been cleaned up.");
                break;
            }
            case "reload": {
                this.reloadConfig();
                this.data.load();
                this.messages.reload();
                this.stopAllTasks();
                if (this.data.isGlobalEnabled()) {
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        if (this.data.isDisabled(p.getUniqueId())) continue;
                        this.startTasksForPlayer(p);
                    }
                }
                sender.sendMessage("\ud83c\udf83 Halloween config and messages reloaded.");
                sender.sendMessage("\u2705 All player tasks restarted with new intervals.");
                break;
            }
            case "set": {
                if (args.length != 4) {
                    sender.sendMessage("Usage: /" + this.commandPrefix + " set <pumpkin|slenderman|fire|lightning|darkness|herobrine> <min> <max>");
                    return true;
                }
                try {
                    String action = args[1].toLowerCase();
                    int min = Integer.parseInt(args[2]);
                    int max = Integer.parseInt(args[3]);
                    this.getConfig().set("events." + action + ".min", (Object)min);
                    this.getConfig().set("events." + action + ".max", (Object)max);
                    this.saveConfig();
                    if (min == 0 && max == 0) {
                        sender.sendMessage("\u00a7c\u26a0\ufe0f Event '" + action + "' has been DISABLED (interval 0 0).");
                        this.getLogger().info("\u2705 Event '" + action + "' has been DISABLED (interval 0 0) by " + sender.getName());
                    } else {
                        sender.sendMessage("\u00a7aInterval for " + action + " set to " + min + "-" + max + " minutes.");
                    }
                    this.stopAllTasks();
                    if (this.data.isGlobalEnabled()) {
                        for (Player p : Bukkit.getOnlinePlayers()) {
                            if (this.data.isDisabled(p.getUniqueId())) continue;
                            this.startTasksForPlayer(p);
                        }
                        sender.sendMessage("\u00a7e\u2705 All player tasks restarted with new interval.");
                        break;
                    }
                    sender.sendMessage("\u00a77Note: Halloween is globally disabled. Enable with /" + this.commandPrefix + " on");
                }
                catch (Exception e) {
                    sender.sendMessage("\u00a7cInvalid values. Use: /" + this.commandPrefix + " set <action> <min> <max>");
                }
                break;
            }
            case "reset": {
                String what;
                if (args.length != 2) {
                    sender.sendMessage("Usage: /" + this.commandPrefix + " reset <pumpkin|helmet|all>");
                    return true;
                }
                switch (what = args[1].toLowerCase()) {
                    case "pumpkin": {
                        this.data.resetPumpkinPranked();
                        sender.sendMessage("\ud83c\udf83 Pumpkin easter egg states have been reset.");
                        break;
                    }
                    case "helmet": {
                        this.data.resetHelmetRewarded();
                        sender.sendMessage("\ud83c\udf70 Helmet reward states have been reset.");
                        break;
                    }
                    case "all": {
                        this.data.resetAll();
                        sender.sendMessage("\ud83d\udd04 All one-time events have been reset.");
                        break;
                    }
                    default: {
                        sender.sendMessage("Invalid reset type. Use pumpkin|helmet|all");
                        return true;
                    }
                }
                this.data.saveAsync();
                break;
            }
            case "buffs": {
                return this.handleBuffsCommand(sender, args);
            }
            case "sound": {
                return this.handleSoundCommand(sender, args);
            }
            case "cleanup": {
                boolean includeTraders = args.length > 1 && args[1].equalsIgnoreCase("all");
                this.cleanupAllEntities(includeTraders);
                if (includeTraders) {
                    sender.sendMessage("\u00a7a\u2705 Cleaned up ALL Halloween entities including Pumpkin Traders.");
                    break;
                }
                sender.sendMessage("\u00a7a\u2705 Cleaned up all Halloween entities (Herobrines, bosses, grave mobs).");
                sender.sendMessage("\u00a77Use '/" + this.commandPrefix + " cleanup all' to also remove Pumpkin Traders.");
                break;
            }
            default: {
                sender.sendMessage("Unknown command. Try /" + this.commandPrefix + " help");
            }
        }
        return true;
    }

    private boolean handleBuffsCommand(CommandSender sender, String[] args) {
        String subCmd;
        if (args.length < 2) {
            sender.sendMessage("Usage: /" + this.commandPrefix + " buffs <list|toggle|glow|add|remove|enable|disable|level>");
            return true;
        }
        switch (subCmd = args[1].toLowerCase()) {
            case "list": {
                sender.sendMessage("\u00a76=== Pumpkin Helmet Buffs ===");
                sender.sendMessage("\u00a77Status: " + (this.getConfig().getBoolean("pumpkin_buffs.enabled", true) ? "\u00a7aEnabled" : "\u00a7cDisabled"));
                sender.sendMessage("\u00a77Glowing: " + (this.getConfig().getBoolean("pumpkin_buffs.glowing", true) ? "\u00a7aOn" : "\u00a7cOff"));
                sender.sendMessage("\u00a76Active Effects:");
                if (!this.getConfig().contains("pumpkin_buffs.effects")) break;
                List effects = this.getConfig().getMapList("pumpkin_buffs.effects");
                for (Map effectMap : effects) {
                    String type = effectMap.get("type").toString();
                    int level = Integer.parseInt(effectMap.get("level").toString());
                    boolean enabled = effectMap.get("enabled") == null || Boolean.parseBoolean(effectMap.get("enabled").toString());
                    String status = enabled ? "\u00a7a\u2713" : "\u00a7c\u2717";
                    sender.sendMessage(String.format("  %s \u00a7e%s \u00a77Level %d", status, type, level + 1));
                }
                break;
            }
            case "toggle": {
                boolean currentEnabled = this.getConfig().getBoolean("pumpkin_buffs.enabled", true);
                this.getConfig().set("pumpkin_buffs.enabled", (Object)(!currentEnabled ? 1 : 0));
                this.saveConfig();
                sender.sendMessage("\u00a76Pumpkin buffs " + (!currentEnabled ? "\u00a7aenabled" : "\u00a7cdisabled") + "\u00a76.");
                break;
            }
            case "glow": {
                if (args.length < 3) {
                    sender.sendMessage("Usage: /" + this.commandPrefix + " buffs glow <on|off>");
                    return true;
                }
                boolean glowOn = args[2].equalsIgnoreCase("on");
                this.getConfig().set("pumpkin_buffs.glowing", (Object)glowOn);
                this.saveConfig();
                if (!glowOn) {
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        p.setGlowing(false);
                    }
                }
                sender.sendMessage("\u00a76Glowing effect " + (glowOn ? "\u00a7aenabled" : "\u00a7cdisabled") + "\u00a76.");
                break;
            }
            case "add": {
                if (args.length < 4) {
                    sender.sendMessage("Usage: /" + this.commandPrefix + " buffs add <effect> <level>");
                    return true;
                }
                return this.addBuff(sender, args[2].toUpperCase(), Integer.parseInt(args[3]) - 1);
            }
            case "remove": {
                if (args.length < 3) {
                    sender.sendMessage("Usage: /" + this.commandPrefix + " buffs remove <effect>");
                    return true;
                }
                return this.removeBuff(sender, args[2].toUpperCase());
            }
            case "enable": 
            case "disable": {
                if (args.length < 3) {
                    sender.sendMessage("Usage: /" + this.commandPrefix + " buffs " + subCmd + " <effect>");
                    return true;
                }
                return this.toggleBuff(sender, args[2].toUpperCase(), subCmd.equals("enable"));
            }
            case "level": {
                if (args.length < 4) {
                    sender.sendMessage("Usage: /" + this.commandPrefix + " buffs level <effect> <level>");
                    return true;
                }
                return this.setBuffLevel(sender, args[2].toUpperCase(), Integer.parseInt(args[3]) - 1);
            }
            default: {
                sender.sendMessage("Unknown buffs command. Try /" + this.commandPrefix + " help");
            }
        }
        return true;
    }

    private boolean addBuff(CommandSender sender, String effectName, int level) {
        List effects = this.getConfig().getMapList("pumpkin_buffs.effects");
        for (Map effectMap : effects) {
            if (!effectMap.get("type").toString().equalsIgnoreCase(effectName)) continue;
            sender.sendMessage("\u00a7cEffect " + effectName + " already exists. Use /" + this.commandPrefix + " buffs level to change it.");
            return true;
        }
        PotionEffectType effectType = PotionEffectType.getByName((String)effectName);
        if (effectType == null) {
            sender.sendMessage("\u00a7cInvalid effect type: " + effectName);
            return true;
        }
        HashMap<String, Object> newEffect = new HashMap<String, Object>();
        newEffect.put("type", effectName);
        newEffect.put("level", level);
        newEffect.put("enabled", true);
        ArrayList newEffects = new ArrayList();
        for (Map oldMap : effects) {
            HashMap copy = new HashMap();
            copy.put("type", oldMap.get("type"));
            copy.put("level", oldMap.get("level"));
            copy.put("enabled", oldMap.get("enabled"));
            newEffects.add(copy);
        }
        newEffects.add(newEffect);
        this.getConfig().set("pumpkin_buffs.effects", newEffects);
        this.saveConfig();
        sender.sendMessage("\u00a7aAdded effect " + effectName + " at level " + (level + 1) + ".");
        return true;
    }

    private boolean removeBuff(CommandSender sender, String effectName) {
        List effects = this.getConfig().getMapList("pumpkin_buffs.effects");
        ArrayList newEffects = new ArrayList();
        boolean found = false;
        for (Map effectMap : effects) {
            if (!effectMap.get("type").toString().equalsIgnoreCase(effectName)) {
                HashMap copy = new HashMap();
                copy.put("type", effectMap.get("type"));
                copy.put("level", effectMap.get("level"));
                copy.put("enabled", effectMap.get("enabled"));
                newEffects.add(copy);
                continue;
            }
            found = true;
        }
        if (!found) {
            sender.sendMessage("\u00a7cEffect " + effectName + " not found.");
            return true;
        }
        this.getConfig().set("pumpkin_buffs.effects", newEffects);
        this.saveConfig();
        sender.sendMessage("\u00a7aRemoved effect " + effectName + ".");
        return true;
    }

    private boolean toggleBuff(CommandSender sender, String effectName, boolean enable) {
        List effects = this.getConfig().getMapList("pumpkin_buffs.effects");
        ArrayList newEffects = new ArrayList();
        boolean found = false;
        for (Map effectMap : effects) {
            HashMap copy = new HashMap();
            copy.put("type", effectMap.get("type"));
            copy.put("level", effectMap.get("level"));
            if (effectMap.get("type").toString().equalsIgnoreCase(effectName)) {
                copy.put("enabled", enable);
                found = true;
            } else {
                copy.put("enabled", effectMap.get("enabled"));
            }
            newEffects.add(copy);
        }
        if (!found) {
            sender.sendMessage("\u00a7cEffect " + effectName + " not found.");
            return true;
        }
        this.getConfig().set("pumpkin_buffs.effects", newEffects);
        this.saveConfig();
        sender.sendMessage("\u00a7a" + (enable ? "Enabled" : "Disabled") + " effect " + effectName + ".");
        return true;
    }

    private boolean setBuffLevel(CommandSender sender, String effectName, int level) {
        List effects = this.getConfig().getMapList("pumpkin_buffs.effects");
        ArrayList newEffects = new ArrayList();
        boolean found = false;
        for (Map effectMap : effects) {
            HashMap copy = new HashMap();
            copy.put("type", effectMap.get("type"));
            copy.put("enabled", effectMap.get("enabled"));
            if (effectMap.get("type").toString().equalsIgnoreCase(effectName)) {
                copy.put("level", level);
                found = true;
            } else {
                copy.put("level", effectMap.get("level"));
            }
            newEffects.add(copy);
        }
        if (!found) {
            sender.sendMessage("\u00a7cEffect " + effectName + " not found.");
            return true;
        }
        this.getConfig().set("pumpkin_buffs.effects", newEffects);
        this.saveConfig();
        sender.sendMessage("\u00a7aSet " + effectName + " to level " + (level + 1) + ".");
        return true;
    }

    private boolean handleSoundCommand(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage("\u00a7cUsage: /" + this.commandPrefix + " sound <player|@a> <sound>");
            sender.sendMessage("\u00a77Example: /" + this.commandPrefix + " sound PlayerName cave_ambience");
            sender.sendMessage("\u00a77Example: /" + this.commandPrefix + " sound @a witch_cackle");
            return true;
        }
        String targetName = args[1];
        String soundName = args[2].toLowerCase();
        Sound sound = this.getHorrorSound(soundName);
        if (sound == null) {
            sender.sendMessage("\u00a7cUnknown sound: " + soundName);
            sender.sendMessage("\u00a77Use tab completion to see available sounds.");
            return true;
        }
        if (targetName.equals("@a")) {
            int count = 0;
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.playSound(p.getLocation(), sound, 1.0f, 1.0f);
                ++count;
            }
            sender.sendMessage("\u00a7aPlayed \u00a7e" + soundName + " \u00a7ato \u00a7e" + count + " \u00a7aplayer(s).");
            return true;
        }
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found: " + targetName);
            return true;
        }
        target.playSound(target.getLocation(), sound, 1.0f, 1.0f);
        sender.sendMessage("\u00a7aPlayed \u00a7e" + soundName + " \u00a7ato \u00a7e" + target.getName() + "\u00a7a.");
        return true;
    }

    private Sound getHorrorSound(String name) {
        switch (name) {
            case "cave_ambience": 
            case "cave": {
                return Sound.AMBIENT_CAVE;
            }
            case "witch_cackle": 
            case "witch": {
                return Sound.ENTITY_WITCH_AMBIENT;
            }
            case "ghast_scream": 
            case "ghast": {
                return Sound.ENTITY_GHAST_SCREAM;
            }
            case "enderman_scream": 
            case "enderman": {
                return Sound.ENTITY_ENDERMAN_SCREAM;
            }
            case "zombie_growl": 
            case "zombie": {
                return Sound.ENTITY_ZOMBIE_AMBIENT;
            }
            case "skeleton_rattle": 
            case "skeleton": {
                return Sound.ENTITY_SKELETON_AMBIENT;
            }
            case "creeper_hiss": 
            case "creeper": {
                return Sound.ENTITY_CREEPER_PRIMED;
            }
            case "wither": {
                return Sound.ENTITY_WITHER_AMBIENT;
            }
            case "ender_dragon": 
            case "dragon": {
                return Sound.ENTITY_ENDER_DRAGON_GROWL;
            }
            case "thunder": {
                return Sound.ENTITY_LIGHTNING_BOLT_THUNDER;
            }
            case "bell": {
                return Sound.BLOCK_BELL_USE;
            }
            case "portal": {
                return Sound.BLOCK_PORTAL_AMBIENT;
            }
            case "soul": {
                return Sound.PARTICLE_SOUL_ESCAPE;
            }
            case "sculk_shriek": 
            case "sculk": {
                return Sound.BLOCK_SCULK_SHRIEKER_SHRIEK;
            }
            case "warden_heartbeat": 
            case "warden": {
                return Sound.ENTITY_WARDEN_HEARTBEAT;
            }
            case "horse_death": 
            case "dying_horse": 
            case "horse": {
                return Sound.ENTITY_HORSE_DEATH;
            }
        }
        return null;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("help", "enable", "disable", "on", "off", "set", "reset", "reload", "buffs", "sound", "cleanup");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("cleanup")) {
            return Arrays.asList("all");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("set")) {
            return Arrays.asList("pumpkin", "slenderman", "fire", "lightning", "darkness", "herobrine");
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("set")) {
            return Arrays.asList("0", "1", "5", "10", "20", "30", "60", "120");
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("set")) {
            return Arrays.asList("0", "1", "5", "10", "20", "30", "60", "120");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("reset")) {
            return Arrays.asList("pumpkin", "helmet", "all");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("buffs")) {
            return Arrays.asList("list", "toggle", "glow", "add", "remove", "enable", "disable", "level");
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("buffs") && args[1].equalsIgnoreCase("glow")) {
            return Arrays.asList("on", "off");
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("buffs") && (args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("remove") || args[1].equalsIgnoreCase("enable") || args[1].equalsIgnoreCase("disable") || args[1].equalsIgnoreCase("level"))) {
            return Arrays.asList("SPEED", "HASTE", "STRENGTH", "REGENERATION", "RESISTANCE", "JUMP_BOOST", "NIGHT_VISION", "INVISIBILITY", "FIRE_RESISTANCE", "WATER_BREATHING", "ABSORPTION", "HEALTH_BOOST", "LUCK", "SLOW_FALLING");
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("buffs") && (args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("level"))) {
            return Arrays.asList("1", "2", "3", "4", "5");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("sound")) {
            ArrayList<String> suggestions = new ArrayList<String>();
            suggestions.add("@a");
            for (Player p : Bukkit.getOnlinePlayers()) {
                suggestions.add(p.getName());
            }
            return suggestions;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("sound")) {
            return Arrays.asList("cave_ambience", "witch_cackle", "ghast_scream", "enderman_scream", "zombie_growl", "skeleton_rattle", "creeper_hiss", "wither", "ender_dragon", "thunder", "bell", "portal", "soul", "sculk_shriek", "warden_heartbeat", "horse_death");
        }
        return Collections.emptyList();
    }

    private void startTasksForPlayer(Player p) {
        int[] herobrineInterval;
        int[] darknessInterval;
        int[] lightningInterval;
        int[] fireInterval;
        int[] slendermanInterval;
        int[] pumpkinInterval;
        UUID id = p.getUniqueId();
        if (!(this.pumpkinTasks.containsKey(id) || (pumpkinInterval = this.data.getInterval("pumpkin"))[0] <= 0 && pumpkinInterval[1] <= 0)) {
            PumpkinTask pt = new PumpkinTask(this, p);
            pt.scheduleNext();
            this.pumpkinTasks.put(id, pt);
        }
        if (!(this.slendermanTasks.containsKey(id) || (slendermanInterval = this.data.getInterval("slenderman"))[0] <= 0 && slendermanInterval[1] <= 0)) {
            SlendermanTask st = new SlendermanTask(this, p);
            st.scheduleNext();
            this.slendermanTasks.put(id, st);
        }
        if (!(this.fireTasks.containsKey(id) || (fireInterval = this.data.getInterval("fire"))[0] <= 0 && fireInterval[1] <= 0)) {
            FireTask ft = new FireTask(this, p);
            ft.scheduleNext();
            this.fireTasks.put(id, ft);
        }
        if (!(this.lightningTasks.containsKey(id) || (lightningInterval = this.data.getInterval("lightning"))[0] <= 0 && lightningInterval[1] <= 0)) {
            LightningTask lt = new LightningTask(this, p);
            lt.scheduleNext();
            this.lightningTasks.put(id, lt);
        }
        if (!(this.darknessTasks.containsKey(id) || (darknessInterval = this.data.getInterval("darkness"))[0] <= 0 && darknessInterval[1] <= 0)) {
            DarknessTask dt = new DarknessTask(this, p);
            dt.scheduleNext();
            this.darknessTasks.put(id, dt);
        }
        if (!(this.herobrineTasks.containsKey(id) || (herobrineInterval = this.data.getInterval("herobrine"))[0] <= 0 && herobrineInterval[1] <= 0)) {
            HerobrineTask ht = new HerobrineTask(this, p);
            ht.scheduleNext();
            this.herobrineTasks.put(id, ht);
        }
    }

    private void stopTasksForPlayer(Player p) {
        UUID id = p.getUniqueId();
        p.setGlowing(false);
        if (this.pumpkinTasks.containsKey(id)) {
            this.pumpkinTasks.remove(id).cancel();
        }
        if (this.slendermanTasks.containsKey(id)) {
            this.slendermanTasks.remove(id).cancel();
        }
        if (this.fireTasks.containsKey(id)) {
            this.fireTasks.remove(id).cancel();
        }
        if (this.lightningTasks.containsKey(id)) {
            this.lightningTasks.remove(id).cancel();
        }
        if (this.darknessTasks.containsKey(id)) {
            this.darknessTasks.remove(id).cancel();
        }
        if (this.herobrineTasks.containsKey(id)) {
            this.herobrineTasks.remove(id).cancel();
        }
    }

    private void stopAllTasks() {
        this.pumpkinTasks.values().forEach(PumpkinTask::cancel);
        this.slendermanTasks.values().forEach(SlendermanTask::cancel);
        this.fireTasks.values().forEach(FireTask::cancel);
        this.lightningTasks.values().forEach(LightningTask::cancel);
        this.darknessTasks.values().forEach(DarknessTask::cancel);
        this.herobrineTasks.values().forEach(HerobrineTask::cancel);
        this.pumpkinTasks.clear();
        this.slendermanTasks.clear();
        this.fireTasks.clear();
        this.lightningTasks.clear();
        this.darknessTasks.clear();
        this.herobrineTasks.clear();
    }

    private void cleanupAllEntities(boolean includeTraders) {
        int herobrineCount = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                ArmorStand stand;
                if (!(entity instanceof ArmorStand) || (stand = (ArmorStand)entity).getCustomName() == null || !stand.getCustomName().contains("Herobrine")) continue;
                stand.remove();
                ++herobrineCount;
            }
        }
        for (HerobrineTask task : this.herobrineTasks.values()) {
            task.resetSequence();
        }
        this.pumpkinMonsterManager.despawnAllBosses();
        this.pumpkinWitchManager.despawnAllBosses();
        this.graveManager.despawnAllGraves();
        this.batWitchManager.despawnAllWitches();
        if (includeTraders) {
            this.pumpkinVillagerManager.revertAllVillagers();
        }
        if (herobrineCount > 0) {
            this.getLogger().info("\ud83e\uddf9 Cleaned up " + herobrineCount + " Herobrine entit" + (herobrineCount == 1 ? "y" : "ies"));
        }
        this.getLogger().info("\ud83e\uddf9 Despawned all bosses and closed all grave events");
        if (includeTraders) {
            this.getLogger().info("\ud83e\uddf9 Reverted all Pumpkin Traders to normal villagers");
        }
    }

    @Deprecated
    private void cleanupAllHerobrines() {
        this.cleanupAllEntities(false);
    }
}

