/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft;

import cz.softici.server.minecraft.HalloweenPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Candle;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class GraveManager
implements Listener {
    private final HalloweenPlugin plugin;
    private final Map<Location, GraveData> activeGraves = new HashMap<Location, GraveData>();
    private final Map<UUID, GraveData> participantGraves = new HashMap<UUID, GraveData>();

    public GraveManager(HalloweenPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onCandleLight(PlayerInteractEvent event) {
        Material item;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!(block.getBlockData() instanceof Candle)) {
            return;
        }
        Material material = item = event.getItem() != null ? event.getItem().getType() : Material.AIR;
        if (item != Material.FLINT_AND_STEEL && item != Material.FIRE_CHARGE) {
            return;
        }
        Player player = event.getPlayer();
        Candle candleData = (Candle)block.getBlockData();
        if (candleData.isLit()) {
            return;
        }
        if (this.plugin.getData().isDisabled(player.getUniqueId())) {
            player.sendMessage("\u00a7c\u00a7l[Halloween] \u00a77You have Halloween disabled. Enable it with \u00a7e/" + this.plugin.getCommandPrefix() + " enable\u00a77 to interact with graves.");
            event.setCancelled(true);
            return;
        }
        if (!this.plugin.getData().isGlobalEnabled()) {
            player.sendMessage("\u00a7c\u00a7l[Halloween] \u00a77Halloween is currently disabled! An admin must enable it with \u00a7e/" + this.plugin.getCommandPrefix() + " on\u00a77.");
            event.setCancelled(true);
            return;
        }
        if (!this.plugin.getConfig().getBoolean("grave.enabled", true)) {
            return;
        }
        GraveStructure structure = this.validateGraveStructure(block.getLocation());
        if (structure == null) {
            return;
        }
        if (this.activeGraves.containsKey(structure.getCenterLocation())) {
            player.sendMessage("\u00a7c\u00a7l[Halloween] \u00a77This grave has already been disturbed!");
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        candleData.setLit(true);
        block.setBlockData((BlockData)candleData);
        block.getWorld().playSound(block.getLocation(), Sound.ITEM_FLINTANDSTEEL_USE, 1.0f, 1.0f);
        this.startGraveEvent(player, structure);
    }

    private GraveStructure validateGraveStructure(Location candleLocation) {
        Block candleBlock = candleLocation.getBlock();
        Block dirtBase = candleBlock.getRelative(BlockFace.DOWN);
        if (!this.isDirt(dirtBase)) {
            return null;
        }
        Location[] dirtBlocks = this.findDirtRow(dirtBase.getLocation());
        if (dirtBlocks == null) {
            return null;
        }
        if (!this.validateCoffin(dirtBlocks)) {
            return null;
        }
        Block signBlock = this.findRIPSign(dirtBlocks[1]);
        if (signBlock == null) {
            return null;
        }
        if (dirtBase.getLocation().equals((Object)dirtBlocks[1])) {
            return null;
        }
        Location crossLocation = this.findCrossAboveDirt(dirtBlocks, dirtBase.getLocation());
        if (crossLocation == null) {
            return null;
        }
        Block crossBase = crossLocation.getBlock();
        Block armsLevel = crossBase.getRelative(0, 2, 0);
        boolean crossXAxis = this.isStoneWall(armsLevel.getRelative(1, 0, 0)) && this.isStoneWall(armsLevel.getRelative(-1, 0, 0));
        boolean dirtRowXAxis = dirtBlocks[0].getX() != dirtBlocks[1].getX();
        return new GraveStructure(dirtBlocks[0], crossLocation, dirtBlocks[0].clone().add(0.0, -1.0, 0.0), signBlock.getLocation(), candleBlock.getLocation(), crossXAxis, dirtRowXAxis);
    }

    private Location[] findDirtRow(Location dirtLoc) {
        Block center = dirtLoc.getBlock();
        if (this.isDirtWithCoffin(center.getRelative(-1, 0, 0)) && this.isDirtWithCoffin(center) && this.isDirtWithCoffin(center.getRelative(1, 0, 0))) {
            return new Location[]{center.getRelative(-1, 0, 0).getLocation(), center.getLocation(), center.getRelative(1, 0, 0).getLocation()};
        }
        if (this.isDirtWithCoffin(center) && this.isDirtWithCoffin(center.getRelative(1, 0, 0)) && this.isDirtWithCoffin(center.getRelative(2, 0, 0))) {
            return new Location[]{center.getLocation(), center.getRelative(1, 0, 0).getLocation(), center.getRelative(2, 0, 0).getLocation()};
        }
        if (this.isDirtWithCoffin(center.getRelative(-2, 0, 0)) && this.isDirtWithCoffin(center.getRelative(-1, 0, 0)) && this.isDirtWithCoffin(center)) {
            return new Location[]{center.getRelative(-2, 0, 0).getLocation(), center.getRelative(-1, 0, 0).getLocation(), center.getLocation()};
        }
        if (this.isDirtWithCoffin(center.getRelative(0, 0, -1)) && this.isDirtWithCoffin(center) && this.isDirtWithCoffin(center.getRelative(0, 0, 1))) {
            return new Location[]{center.getRelative(0, 0, -1).getLocation(), center.getLocation(), center.getRelative(0, 0, 1).getLocation()};
        }
        if (this.isDirtWithCoffin(center) && this.isDirtWithCoffin(center.getRelative(0, 0, 1)) && this.isDirtWithCoffin(center.getRelative(0, 0, 2))) {
            return new Location[]{center.getLocation(), center.getRelative(0, 0, 1).getLocation(), center.getRelative(0, 0, 2).getLocation()};
        }
        if (this.isDirtWithCoffin(center.getRelative(0, 0, -2)) && this.isDirtWithCoffin(center.getRelative(0, 0, -1)) && this.isDirtWithCoffin(center)) {
            return new Location[]{center.getRelative(0, 0, -2).getLocation(), center.getRelative(0, 0, -1).getLocation(), center.getLocation()};
        }
        return null;
    }

    private boolean isDirtWithCoffin(Block block) {
        if (!this.isDirt(block)) {
            return false;
        }
        Block below = block.getRelative(0, -1, 0);
        return this.isWoodPlanks(below);
    }

    private boolean validateCoffin(Location[] dirtBlocks) {
        for (Location dirtLoc : dirtBlocks) {
            Block below = dirtLoc.getBlock().getRelative(0, -1, 0);
            if (this.isWoodPlanks(below)) continue;
            return false;
        }
        return true;
    }

    private Block findRIPSign(Location middleDirt) {
        Sign sign;
        CharSequence[] lines;
        String text;
        Block above = middleDirt.getBlock().getRelative(BlockFace.UP);
        if (above.getState() instanceof Sign && ((text = String.join((CharSequence)" ", lines = (sign = (Sign)above.getState()).getLines()).toLowerCase()).contains("rip") || text.contains("r.i.p") || text.contains("r i p"))) {
            return above;
        }
        return null;
    }

    private Location findCrossAboveDirt(Location[] dirtBlocks, Location candleDirt) {
        for (int i = 0; i < dirtBlocks.length; ++i) {
            Location dirtLoc = dirtBlocks[i];
            if (dirtLoc.equals((Object)candleDirt)) continue;
            Block aboveDirt = dirtLoc.getBlock().getRelative(BlockFace.UP);
            if (aboveDirt.getState() instanceof Sign) {
                aboveDirt = aboveDirt.getRelative(BlockFace.UP);
            }
            if (!this.isValidCrossBase(aboveDirt.getLocation())) continue;
            return aboveDirt.getLocation();
        }
        return null;
    }

    private boolean isValidCrossBase(Location baseLoc) {
        boolean hasZArms;
        Block base = baseLoc.getBlock();
        if (!this.isStoneWall(base)) {
            return false;
        }
        Block secondLayer = base.getRelative(0, 1, 0);
        if (!this.isStoneWall(secondLayer)) {
            return false;
        }
        Block armsMiddle = base.getRelative(0, 2, 0);
        if (!this.isStoneWall(armsMiddle)) {
            return false;
        }
        Block xLeft = armsMiddle.getRelative(-1, 0, 0);
        Block xRight = armsMiddle.getRelative(1, 0, 0);
        boolean hasXArms = this.isStoneWall(xLeft) && this.isStoneWall(xRight);
        Block zFront = armsMiddle.getRelative(0, 0, 1);
        Block zBack = armsMiddle.getRelative(0, 0, -1);
        boolean bl = hasZArms = this.isStoneWall(zFront) && this.isStoneWall(zBack);
        if (!hasXArms && !hasZArms) {
            return false;
        }
        Block top = armsMiddle.getRelative(0, 1, 0);
        return this.isStoneWall(top);
    }

    private boolean isDirt(Block block) {
        return block.getType() == Material.DIRT || block.getType() == Material.GRASS_BLOCK;
    }

    private boolean isStoneWall(Block block) {
        return block.getType() == Material.COBBLESTONE_WALL || block.getType() == Material.MOSSY_COBBLESTONE_WALL || block.getType().toString().endsWith("_WALL");
    }

    private boolean isWoodPlanks(Block block) {
        return block.getType().toString().endsWith("_PLANKS");
    }

    private void startGraveEvent(Player player, GraveStructure structure) {
        String message = this.plugin.getMessageManager().getRandomMessage("graveAwaken", player.getName());
        Bukkit.broadcastMessage((String)message);
        GraveData graveData = new GraveData(structure, player);
        this.activeGraves.put(structure.getCenterLocation(), graveData);
        this.startSinkingAnimation(graveData);
    }

    private void startSinkingAnimation(final GraveData graveData) {
        new BukkitRunnable(){
            int sinkStage = 0;

            public void run() {
                if (this.sinkStage < 4) {
                    GraveManager.this.sinkCrossOneBlock(graveData.getStructure());
                    ++this.sinkStage;
                } else if (this.sinkStage == 4) {
                    GraveManager.this.removeDirtLayer(graveData.getStructure());
                    ++this.sinkStage;
                } else if (this.sinkStage == 5) {
                    GraveManager.this.transformCoffinAndSpawnMobs(graveData);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 60L);
    }

    private void sinkCrossOneBlock(GraveStructure structure) {
        Location cross = structure.getCrossLocation();
        Block base = cross.getBlock();
        this.moveArmsDown(structure);
        base.setType(Material.AIR);
        for (int y = 0; y < 3; ++y) {
            Block current = base.getRelative(0, y + 1, 0);
            Block below = base.getRelative(0, y, 0);
            below.setType(current.getType());
            below.setBlockData(current.getBlockData());
        }
        base.getRelative(0, 3, 0).setType(Material.AIR);
        cross.getWorld().playSound(cross, Sound.BLOCK_STONE_BREAK, 1.0f, 0.8f);
        cross.getWorld().spawnParticle(Particle.BLOCK, cross, 20, 0.3, 0.3, 0.3, 0.0, (Object)Material.COBBLESTONE_WALL.createBlockData());
    }

    private void moveArmsDown(GraveStructure structure) {
        Location cross = structure.getCrossLocation();
        Block base = cross.getBlock();
        boolean xAxis = structure.isCrossXAxis();
        for (int y = 3; y >= 0; --y) {
            Block below;
            Block levelBlock = base.getRelative(0, y, 0);
            if (xAxis) {
                Block right = levelBlock.getRelative(1, 0, 0);
                Block left = levelBlock.getRelative(-1, 0, 0);
                if (this.isStoneWall(right)) {
                    if (y > 0) {
                        below = levelBlock.getRelative(1, -1, 0);
                        below.setType(right.getType());
                        below.setBlockData(right.getBlockData());
                    }
                    right.setType(Material.AIR);
                }
                if (!this.isStoneWall(left)) continue;
                if (y > 0) {
                    below = levelBlock.getRelative(-1, -1, 0);
                    below.setType(left.getType());
                    below.setBlockData(left.getBlockData());
                }
                left.setType(Material.AIR);
                continue;
            }
            Block front = levelBlock.getRelative(0, 0, 1);
            Block back = levelBlock.getRelative(0, 0, -1);
            if (this.isStoneWall(front)) {
                if (y > 0) {
                    below = levelBlock.getRelative(0, -1, 1);
                    below.setType(front.getType());
                    below.setBlockData(front.getBlockData());
                }
                front.setType(Material.AIR);
            }
            if (!this.isStoneWall(back)) continue;
            if (y > 0) {
                below = levelBlock.getRelative(0, -1, -1);
                below.setType(back.getType());
                below.setBlockData(back.getBlockData());
            }
            back.setType(Material.AIR);
        }
    }

    private void removeDirtLayer(GraveStructure structure) {
        Location dirtStart = structure.getDirtLocation();
        boolean xAxis = structure.isDirtRowXAxis();
        for (int i = 0; i < 3; ++i) {
            Block dirt = xAxis ? dirtStart.clone().add((double)i, 0.0, 0.0).getBlock() : dirtStart.clone().add(0.0, 0.0, (double)i).getBlock();
            dirt.setType(Material.AIR);
            dirt.getRelative(BlockFace.UP).setType(Material.AIR);
        }
        dirtStart.getWorld().playSound(dirtStart, Sound.BLOCK_GRASS_BREAK, 1.0f, 0.7f);
        dirtStart.getWorld().spawnParticle(Particle.BLOCK, dirtStart, 30, 1.0, 0.3, 1.0, 0.0, (Object)Material.DIRT.createBlockData());
    }

    private void removeAllCrossBlocks(GraveStructure structure) {
        int y;
        Location cross = structure.getCrossLocation();
        Block base = cross.getBlock();
        boolean xAxis = structure.isCrossXAxis();
        for (y = 0; y < 4; ++y) {
            Block vertical = base.getRelative(0, y, 0);
            if (!this.isStoneWall(vertical)) continue;
            vertical.setType(Material.AIR);
        }
        for (y = 0; y < 4; ++y) {
            Block level = base.getRelative(0, y, 0);
            if (xAxis) {
                Block left = level.getRelative(-1, 0, 0);
                Block right = level.getRelative(1, 0, 0);
                if (this.isStoneWall(left)) {
                    left.setType(Material.AIR);
                }
                if (!this.isStoneWall(right)) continue;
                right.setType(Material.AIR);
                continue;
            }
            Block front = level.getRelative(0, 0, 1);
            Block back = level.getRelative(0, 0, -1);
            if (this.isStoneWall(front)) {
                front.setType(Material.AIR);
            }
            if (!this.isStoneWall(back)) continue;
            back.setType(Material.AIR);
        }
    }

    private void transformCoffinAndSpawnMobs(final GraveData graveData) {
        GraveStructure structure = graveData.getStructure();
        Location coffinStart = structure.getCoffinLocation();
        World world = coffinStart.getWorld();
        world.setTime(13000L);
        Block firstWood = coffinStart.getBlock();
        if (this.isWoodPlanks(firstWood) && this.isWoodPlanks(firstWood.getRelative(1, 0, 0)) && this.isWoodPlanks(firstWood.getRelative(2, 0, 0))) {
            firstWood.setType(Material.NETHER_BRICKS);
            firstWood.getRelative(1, 0, 0).setType(Material.NETHER_BRICKS);
            firstWood.getRelative(2, 0, 0).setType(Material.NETHER_BRICKS);
        } else if (this.isWoodPlanks(firstWood) && this.isWoodPlanks(firstWood.getRelative(0, 0, 1)) && this.isWoodPlanks(firstWood.getRelative(0, 0, 2))) {
            firstWood.setType(Material.NETHER_BRICKS);
            firstWood.getRelative(0, 0, 1).setType(Material.NETHER_BRICKS);
            firstWood.getRelative(0, 0, 2).setType(Material.NETHER_BRICKS);
        } else if (this.isWoodPlanks(firstWood) && this.isWoodPlanks(firstWood.getRelative(-1, 0, 0)) && this.isWoodPlanks(firstWood.getRelative(-2, 0, 0))) {
            firstWood.setType(Material.NETHER_BRICKS);
            firstWood.getRelative(-1, 0, 0).setType(Material.NETHER_BRICKS);
            firstWood.getRelative(-2, 0, 0).setType(Material.NETHER_BRICKS);
        } else if (this.isWoodPlanks(firstWood) && this.isWoodPlanks(firstWood.getRelative(0, 0, -1)) && this.isWoodPlanks(firstWood.getRelative(0, 0, -2))) {
            firstWood.setType(Material.NETHER_BRICKS);
            firstWood.getRelative(0, 0, -1).setType(Material.NETHER_BRICKS);
            firstWood.getRelative(0, 0, -2).setType(Material.NETHER_BRICKS);
        }
        this.removeAllCrossBlocks(structure);
        this.removeBlocksAroundGrave(coffinStart);
        world.playSound(coffinStart, Sound.ENTITY_WITHER_SPAWN, 0.5f, 0.7f);
        world.spawnParticle(Particle.LARGE_SMOKE, coffinStart.clone().add(1.0, 1.0, 1.0), 50, 1.0, 1.0, 1.0, 0.05);
        new BukkitRunnable(){

            public void run() {
                GraveManager.this.spawnWave(graveData);
            }
        }.runTaskLater((Plugin)this.plugin, 60L);
    }

    private void removeBlocksAroundGrave(Location center) {
        for (int x = -3; x <= 3; ++x) {
            for (int y = 0; y <= 6; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    Block block = center.clone().add((double)x, (double)y, (double)z).getBlock();
                    Material type = block.getType();
                    if (type == Material.DIRT || type == Material.GRASS_BLOCK || type == Material.STONE || type == Material.NETHER_BRICKS || type == Material.AIR || type == Material.CAVE_AIR) continue;
                    block.setType(Material.AIR);
                }
            }
        }
    }

    private void spawnWave(GraveData graveData) {
        int wave = graveData.getCurrentWave();
        String waveMsg = "\u00a7c\u00a7l\u2694 WAVE " + wave + "/" + graveData.getTotalWaves() + " \u00a77has spawned!";
        Bukkit.broadcastMessage((String)waveMsg);
        Location graveLocation = graveData.getStructure().getCoffinLocation();
        this.playHornForNearbyPlayers(graveLocation, 20.0);
        this.spawnGraveMobs(graveData, wave);
        this.startWaveTimeout(graveData);
    }

    private void playHornForNearbyPlayers(Location location, double radius) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        for (Player player : world.getPlayers()) {
            if (!(player.getLocation().distance(location) <= radius)) continue;
            player.playSound(player.getLocation(), Sound.ENTITY_WITHER_SPAWN, 1.5f, 0.8f);
        }
    }

    private void spawnGraveMobs(GraveData graveData, int wave) {
        Skeleton rider;
        SkeletonHorse horse;
        int i;
        GraveStructure structure = graveData.getStructure();
        Location spawnLoc = structure.getCoffinLocation().clone().add(1.0, 1.0, 0.0);
        World world = spawnLoc.getWorld();
        String wavePath = "grave.spawns.wave" + wave;
        int skeletonCount = this.plugin.getConfig().getInt(wavePath + ".skeleton", 3);
        int zombieCount = this.plugin.getConfig().getInt(wavePath + ".zombie", 2);
        int skeletonHorseCount = this.plugin.getConfig().getInt(wavePath + ".skeleton_horse", 2);
        int zombieHorseCount = this.plugin.getConfig().getInt(wavePath + ".zombie_horse", 3);
        int blazeCount = this.plugin.getConfig().getInt(wavePath + ".blaze", 0);
        ArrayList<LivingEntity> mobs = new ArrayList<LivingEntity>();
        for (i = 0; i < skeletonCount; ++i) {
            Skeleton skeleton = (Skeleton)world.spawnEntity(spawnLoc, EntityType.SKELETON);
            this.setupGraveMob((LivingEntity)skeleton, graveData, wave);
            mobs.add((LivingEntity)skeleton);
        }
        for (i = 0; i < zombieCount; ++i) {
            Zombie zombie = (Zombie)world.spawnEntity(spawnLoc, EntityType.ZOMBIE);
            this.setupGraveMob((LivingEntity)zombie, graveData, wave);
            mobs.add((LivingEntity)zombie);
        }
        for (i = 0; i < skeletonHorseCount; ++i) {
            horse = (SkeletonHorse)world.spawnEntity(spawnLoc, EntityType.SKELETON_HORSE);
            rider = (Skeleton)world.spawnEntity(spawnLoc, EntityType.SKELETON);
            horse.addPassenger((Entity)rider);
            this.setupGraveMob((LivingEntity)horse, graveData, wave);
            this.setupGraveMob((LivingEntity)rider, graveData, wave);
            graveData.linkRiderToHorse(rider.getUniqueId(), horse.getUniqueId());
            mobs.add((LivingEntity)horse);
            mobs.add((LivingEntity)rider);
        }
        for (i = 0; i < zombieHorseCount; ++i) {
            horse = (ZombieHorse)world.spawnEntity(spawnLoc, EntityType.ZOMBIE_HORSE);
            rider = (Zombie)world.spawnEntity(spawnLoc, EntityType.ZOMBIE);
            horse.addPassenger((Entity)rider);
            this.setupGraveMob((LivingEntity)horse, graveData, wave);
            this.setupGraveMob((LivingEntity)rider, graveData, wave);
            graveData.linkRiderToHorse(rider.getUniqueId(), horse.getUniqueId());
            mobs.add((LivingEntity)horse);
            mobs.add((LivingEntity)rider);
        }
        for (i = 0; i < blazeCount; ++i) {
            Blaze blaze = (Blaze)world.spawnEntity(spawnLoc.clone().add(0.0, 2.0, 0.0), EntityType.BLAZE);
            this.setupGraveMob((LivingEntity)blaze, graveData, wave);
            mobs.add((LivingEntity)blaze);
        }
        graveData.setMobs(mobs);
        graveData.setTotalMobsInWave(mobs.size());
        this.teleportMobsAboveRoof(mobs, spawnLoc);
        world.playSound(spawnLoc, Sound.ENTITY_ZOMBIE_VILLAGER_CONVERTED, 1.0f, 0.7f);
    }

    private void teleportMobsAboveRoof(List<LivingEntity> mobs, Location originalSpawn) {
        ArrayList<LivingEntity> shuffled = new ArrayList<LivingEntity>(mobs);
        Collections.shuffle(shuffled);
        int teleportCount = Math.min(10, shuffled.size());
        Random random = new Random();
        for (int i = 0; i < teleportCount; ++i) {
            LivingEntity mob = (LivingEntity)shuffled.get(i);
            double offsetX = (random.nextDouble() - 0.5) * 10.0;
            double offsetZ = (random.nextDouble() - 0.5) * 10.0;
            Location newLoc = originalSpawn.clone().add(offsetX, 5.0, offsetZ);
            mob.teleport(newLoc);
        }
    }

    private void setupGraveMob(LivingEntity entity, GraveData graveData, int wave) {
        if (entity.getEquipment() != null && !(entity instanceof Bat)) {
            entity.getEquipment().setHelmet(new ItemStack(Material.CARVED_PUMPKIN));
            entity.getEquipment().setHelmetDropChance(0.0f);
        }
        entity.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, Integer.MAX_VALUE, 0, false, false));
        double waveMultiplier = 1.0 + (double)(wave - 1) * 0.5;
        double healthBoost = this.plugin.getConfig().getDouble("grave.health_boost", 1.3) * waveMultiplier;
        double damageBoost = this.plugin.getConfig().getDouble("grave.damage_boost", 1.5) * waveMultiplier;
        double speedBoost = this.plugin.getConfig().getDouble("grave.speed_boost", 0.2);
        if (entity.getAttribute(Attribute.GENERIC_MAX_HEALTH) != null) {
            entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue() * healthBoost);
            entity.setHealth(entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
        }
        if (entity.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE) != null) {
            entity.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(entity.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getBaseValue() * damageBoost);
        }
        if (entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED) != null) {
            entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getBaseValue() + speedBoost);
        }
        entity.setPersistent(true);
        graveData.addMobUUID(entity.getUniqueId());
    }

    @EventHandler
    public void onGraveMobDeath(EntityDeathEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        GraveData graveData = null;
        for (GraveData graveData2 : this.activeGraves.values()) {
            if (!graveData2.containsMob(entity.getUniqueId())) continue;
            graveData = graveData2;
            break;
        }
        if (graveData == null) {
            return;
        }
        UUID linkedHorseUUID = graveData.getLinkedHorse(entity.getUniqueId());
        if (linkedHorseUUID != null) {
            for (Entity worldEntity : entity.getWorld().getEntities()) {
                if (!worldEntity.getUniqueId().equals(linkedHorseUUID) || !(worldEntity instanceof LivingEntity)) continue;
                LivingEntity horse = (LivingEntity)worldEntity;
                horse.damage(999999.0);
                graveData.removeMob(linkedHorseUUID);
                break;
            }
        }
        if ((player = entity.getKiller()) != null) {
            graveData.addParticipant(player.getUniqueId());
            this.participantGraves.put(player.getUniqueId(), graveData);
        }
        event.getDrops().clear();
        if (Math.random() < 0.1) {
            event.getDrops().add(new ItemStack(Material.CARVED_PUMPKIN, 1));
        }
        int extraXP = this.plugin.getConfig().getInt("grave.xp_per_mob", 5);
        int totalXP = event.getDroppedExp() + extraXP;
        if (totalXP > 0) {
            event.setDroppedExp(totalXP);
        }
        graveData.removeMob(entity.getUniqueId());
        if (graveData.allMobsDefeated()) {
            this.checkWaveProgression(graveData);
        }
    }

    private void checkWaveProgression(final GraveData graveData) {
        graveData.cancelWaveTimeout();
        int currentWave = graveData.getCurrentWave();
        if (graveData.isLastWave()) {
            this.completeGraveEvent(graveData);
        } else {
            graveData.nextWave();
            String waveMsg = "\u00a7e\u00a7l\u2694 Wave " + currentWave + " cleared! Preparing wave " + graveData.getCurrentWave() + "...";
            Bukkit.broadcastMessage((String)waveMsg);
            new BukkitRunnable(){

                public void run() {
                    GraveManager.this.spawnWave(graveData);
                }
            }.runTaskLater((Plugin)this.plugin, 100L);
        }
    }

    private void startWaveTimeout(GraveData graveData) {
        int wave = graveData.getCurrentWave();
        int timeoutSeconds = this.plugin.getConfig().getInt("grave.wave_timeouts.wave" + wave, 120);
        long timeoutTicks = (long)timeoutSeconds * 20L;
        graveData.setWaveStartTime(System.currentTimeMillis());
        int warningSeconds = 30;
        long warningTicks = (long)(timeoutSeconds - warningSeconds) * 20L;
        if (warningTicks > 0L) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (!graveData.allMobsDefeated()) {
                    int remaining = graveData.getRemainingMobs();
                    Bukkit.broadcastMessage((String)("\u00a7c\u00a7l\u26a0 WARNING: \u00a7e30 seconds remaining! \u00a77(" + remaining + " mobs left)"));
                }
            }, warningTicks);
        }
        int taskId = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (!graveData.allMobsDefeated()) {
                this.handleWaveTimeout(graveData);
            }
        }, timeoutTicks).getTaskId();
        graveData.setWaveTimeoutTask(taskId);
    }

    private void handleWaveTimeout(final GraveData graveData) {
        int wave = graveData.getCurrentWave();
        int remaining = graveData.getRemainingMobs();
        double completionPercent = graveData.getCompletionPercentage() * 100.0;
        Bukkit.broadcastMessage((String)("\u00a7c\u00a7l\u23f1 WAVE " + wave + " TIMEOUT!"));
        Bukkit.broadcastMessage((String)("\u00a77Time's up! \u00a7e" + remaining + " \u00a77mobs remaining."));
        Bukkit.broadcastMessage((String)String.format("\u00a77Completion: \u00a7e%.1f%%", completionPercent));
        Bukkit.broadcastMessage((String)"\u00a7c\u00a7lRewards reduced by remaining mobs!");
        ArrayList<UUID> mobsToRemove = new ArrayList<UUID>(graveData.getMobUUIDs());
        for (UUID mobUUID : mobsToRemove) {
            block1: for (World world : Bukkit.getWorlds()) {
                for (LivingEntity entity : world.getLivingEntities()) {
                    if (!entity.getUniqueId().equals(mobUUID)) continue;
                    entity.remove();
                    continue block1;
                }
            }
            graveData.removeMob(mobUUID);
        }
        if (graveData.isLastWave()) {
            this.completeGraveEventWithPenalty(graveData, completionPercent);
        } else {
            graveData.nextWave();
            String waveMsg = "\u00a7e\u00a7lProceeding to Wave " + graveData.getCurrentWave() + "...";
            Bukkit.broadcastMessage((String)waveMsg);
            new BukkitRunnable(){

                public void run() {
                    GraveManager.this.spawnWave(graveData);
                }
            }.runTaskLater((Plugin)this.plugin, 100L);
        }
    }

    private void completeGraveEventWithPenalty(GraveData graveData, double completionPercent) {
        GraveStructure structure = graveData.getStructure();
        Location rewardLoc = structure.getCoffinLocation().clone().add(1.0, 1.0, 0.0);
        String playerName = Bukkit.getOfflinePlayer((UUID)graveData.getInitiator()).getName();
        if (playerName == null) {
            playerName = "Unknown";
        }
        Bukkit.broadcastMessage((String)"\u00a7e\u00a7l\u2694 Grave event completed (with timeout penalty)");
        Bukkit.broadcastMessage((String)String.format("\u00a77Final completion: \u00a7e%.1f%%", completionPercent));
        this.spawnGraveRewardChest(graveData, rewardLoc, completionPercent / 100.0);
        this.activeGraves.remove(structure.getCenterLocation());
        graveData.getKillCounts().keySet().forEach(this.participantGraves::remove);
    }

    private void completeGraveEvent(GraveData graveData) {
        graveData.cancelWaveTimeout();
        GraveStructure structure = graveData.getStructure();
        Location rewardLoc = structure.getCoffinLocation().clone().add(1.0, 1.0, 0.0);
        String playerName = Bukkit.getOfflinePlayer((UUID)graveData.getInitiator()).getName();
        if (playerName == null) {
            playerName = "Unknown";
        }
        String message = this.plugin.getMessageManager().getRandomMessage("graveCurseBroken", playerName);
        Bukkit.broadcastMessage((String)message);
        Bukkit.broadcastMessage((String)"\u00a7a\u00a7l\u2714 All waves defeated! Rewards await...");
        this.spawnGraveRewardChest(graveData, rewardLoc, 1.0);
    }

    private void spawnGraveRewardChest(GraveData graveData, Location rewardLoc, double completionMultiplier) {
        Location finalRewardLoc = rewardLoc.clone();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Block chestBlock = finalRewardLoc.getBlock();
            chestBlock.setType(Material.CHEST);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                Block freshBlock = finalRewardLoc.getBlock();
                if (freshBlock.getType() != Material.CHEST) {
                    this.plugin.getLogger().warning("Failed to place chest - block is: " + String.valueOf(freshBlock.getType()));
                    return;
                }
                if (freshBlock.getState() instanceof Chest) {
                    Chest chestState = (Chest)freshBlock.getState();
                    Inventory inv = chestState.getInventory();
                    List rewards = this.plugin.getConfig().getMapList("grave.rewards");
                    Random rand = new Random();
                    int slot = 0;
                    for (Map rewardMap : rewards) {
                        try {
                            Material material;
                            int amount;
                            String materialName = rewardMap.get("material").toString();
                            int min = Integer.parseInt(rewardMap.get("min").toString());
                            int max = Integer.parseInt(rewardMap.get("max").toString());
                            double chance = rewardMap.containsKey("chance") ? Double.parseDouble(rewardMap.get("chance").toString()) : 1.0;
                            min = (int)Math.ceil((double)min * completionMultiplier);
                            max = (int)Math.ceil((double)max * completionMultiplier);
                            if (rand.nextDouble() > chance || (amount = min == max ? min : min + rand.nextInt(max - min + 1)) <= 0 || (material = Material.getMaterial((String)materialName)) == null || slot >= inv.getSize()) continue;
                            inv.setItem(slot++, new ItemStack(material, amount));
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().warning("Invalid grave reward config: " + e.getMessage());
                        }
                    }
                    this.plugin.getLogger().info("Successfully filled chest at " + String.valueOf(finalRewardLoc) + String.format(" (%.0f%% completion)", completionMultiplier * 100.0));
                }
            }, 2L);
        }, 5L);
        this.distributeParticipantXP(graveData);
        this.activeGraves.remove(graveData.getStructure().getCenterLocation());
        graveData.getKillCounts().keySet().forEach(this.participantGraves::remove);
        finalRewardLoc.getWorld().playSound(finalRewardLoc, Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
        finalRewardLoc.getWorld().spawnParticle(Particle.TOTEM_OF_UNDYING, finalRewardLoc.clone().add(0.5, 0.5, 0.5), 50, 0.5, 0.5, 0.5, 0.1);
    }

    private void distributeParticipantXP(GraveData graveData) {
        Map<UUID, Integer> killCounts = graveData.getKillCounts();
        if (killCounts.isEmpty()) {
            return;
        }
        int totalKills = killCounts.values().stream().mapToInt(Integer::intValue).sum();
        int totalXP = 70;
        for (Map.Entry<UUID, Integer> entry : killCounts.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null || !player.isOnline()) continue;
            double percentage = (double)entry.getValue().intValue() / (double)totalKills;
            int xpReward = (int)((double)totalXP * percentage);
            player.giveExp(xpReward);
            player.sendMessage(String.format("\u00a7a\u00a7l[Halloween] \u00a77You received \u00a7e%d XP \u00a77for helping defeat the grave! (%.1f%% contribution)", xpReward, percentage * 100.0));
        }
    }

    public void despawnAllGraves() {
        for (GraveData graveData : this.activeGraves.values()) {
            for (UUID mobUUID : graveData.getMobUUIDs()) {
                block2: for (World world : Bukkit.getWorlds()) {
                    for (Entity entity : world.getEntities()) {
                        if (!entity.getUniqueId().equals(mobUUID)) continue;
                        entity.remove();
                        continue block2;
                    }
                }
            }
        }
        this.activeGraves.clear();
        this.participantGraves.clear();
    }

    private static class GraveStructure {
        private final Location dirtLocation;
        private final Location crossLocation;
        private final Location coffinLocation;
        private final Location signLocation;
        private final Location candleLocation;
        private final boolean crossXAxis;
        private final boolean dirtRowXAxis;

        public GraveStructure(Location dirtLocation, Location crossLocation, Location coffinLocation, Location signLocation, Location candleLocation, boolean crossXAxis, boolean dirtRowXAxis) {
            this.dirtLocation = dirtLocation;
            this.crossLocation = crossLocation;
            this.coffinLocation = coffinLocation;
            this.signLocation = signLocation;
            this.candleLocation = candleLocation;
            this.crossXAxis = crossXAxis;
            this.dirtRowXAxis = dirtRowXAxis;
        }

        public Location getDirtLocation() {
            return this.dirtLocation;
        }

        public Location getCrossLocation() {
            return this.crossLocation;
        }

        public Location getCoffinLocation() {
            return this.coffinLocation;
        }

        public Location getSignLocation() {
            return this.signLocation;
        }

        public Location getCandleLocation() {
            return this.candleLocation;
        }

        public boolean isCrossXAxis() {
            return this.crossXAxis;
        }

        public boolean isDirtRowXAxis() {
            return this.dirtRowXAxis;
        }

        public Location getCenterLocation() {
            if (this.dirtRowXAxis) {
                return this.dirtLocation.clone().add(1.0, 0.0, 0.0);
            }
            return this.dirtLocation.clone().add(0.0, 0.0, 1.0);
        }
    }

    private static class GraveData {
        private final GraveStructure structure;
        private final UUID initiator;
        private final List<LivingEntity> mobs = new ArrayList<LivingEntity>();
        private final Set<UUID> mobUUIDs = new HashSet<UUID>();
        private final Map<UUID, Integer> killCounts = new HashMap<UUID, Integer>();
        private final Map<UUID, UUID> riderToHorse = new HashMap<UUID, UUID>();
        private int currentWave = 1;
        private static final int TOTAL_WAVES = 3;
        private int waveTimeoutTaskId = -1;
        private long waveStartTime = 0L;
        private int totalMobsInWave = 0;

        public GraveData(GraveStructure structure, Player initiator) {
            this.structure = structure;
            this.initiator = initiator.getUniqueId();
        }

        public int getCurrentWave() {
            return this.currentWave;
        }

        public void nextWave() {
            ++this.currentWave;
        }

        public boolean isLastWave() {
            return this.currentWave >= 3;
        }

        public int getTotalWaves() {
            return 3;
        }

        public GraveStructure getStructure() {
            return this.structure;
        }

        public UUID getInitiator() {
            return this.initiator;
        }

        public void setMobs(List<LivingEntity> mobs) {
            this.mobs.addAll(mobs);
            for (LivingEntity mob : mobs) {
                this.mobUUIDs.add(mob.getUniqueId());
            }
        }

        public void addMobUUID(UUID uuid) {
            this.mobUUIDs.add(uuid);
        }

        public Set<UUID> getMobUUIDs() {
            return this.mobUUIDs;
        }

        public boolean containsMob(UUID uuid) {
            return this.mobUUIDs.contains(uuid);
        }

        public void removeMob(UUID uuid) {
            this.mobUUIDs.remove(uuid);
        }

        public boolean allMobsDefeated() {
            return this.mobUUIDs.isEmpty();
        }

        public void addParticipant(UUID playerUUID) {
            this.killCounts.put(playerUUID, this.killCounts.getOrDefault(playerUUID, 0) + 1);
        }

        public Map<UUID, Integer> getKillCounts() {
            return this.killCounts;
        }

        public void linkRiderToHorse(UUID riderUUID, UUID horseUUID) {
            this.riderToHorse.put(riderUUID, horseUUID);
        }

        public UUID getLinkedHorse(UUID riderUUID) {
            return this.riderToHorse.get(riderUUID);
        }

        public void setWaveTimeoutTask(int taskId) {
            this.waveTimeoutTaskId = taskId;
        }

        public int getWaveTimeoutTask() {
            return this.waveTimeoutTaskId;
        }

        public void cancelWaveTimeout() {
            if (this.waveTimeoutTaskId != -1) {
                Bukkit.getScheduler().cancelTask(this.waveTimeoutTaskId);
                this.waveTimeoutTaskId = -1;
            }
        }

        public void setWaveStartTime(long time) {
            this.waveStartTime = time;
        }

        public long getWaveStartTime() {
            return this.waveStartTime;
        }

        public void setTotalMobsInWave(int count) {
            this.totalMobsInWave = count;
        }

        public int getTotalMobsInWave() {
            return this.totalMobsInWave;
        }

        public int getRemainingMobs() {
            return this.mobUUIDs.size();
        }

        public double getCompletionPercentage() {
            if (this.totalMobsInWave == 0) {
                return 1.0;
            }
            return 1.0 - (double)this.mobUUIDs.size() / (double)this.totalMobsInWave;
        }
    }
}

