/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft;

import cz.softici.server.minecraft.HalloweenPlugin;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Bat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Witch;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class BatWitchManager
implements Listener {
    private final HalloweenPlugin plugin;
    private final Set<UUID> transformedWitches = new HashSet<UUID>();

    public BatWitchManager(HalloweenPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBatDeath(EntityDeathEvent event) {
        if (!this.plugin.getConfig().getBoolean("bat_transformation.enabled", true)) {
            return;
        }
        if (!(event.getEntity() instanceof Bat)) {
            return;
        }
        Bat bat = (Bat)event.getEntity();
        if (bat.getKiller() == null) {
            return;
        }
        if (!this.plugin.getData().isGlobalEnabled()) {
            return;
        }
        if (this.plugin.getData().isDisabled(bat.getKiller().getUniqueId())) {
            return;
        }
        double chance = this.plugin.getConfig().getDouble("bat_transformation.chance", 0.33);
        if (Math.random() > chance) {
            return;
        }
        Location spawnLoc = bat.getLocation();
        Witch witch = (Witch)bat.getWorld().spawnEntity(spawnLoc, EntityType.WITCH);
        witch.getEquipment().setHelmet(new ItemStack(Material.CARVED_PUMPKIN));
        double healthMultiplier = this.plugin.getConfig().getDouble("bat_transformation.health_multiplier", 1.5);
        double maxHealth = witch.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue();
        witch.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(maxHealth * healthMultiplier);
        witch.setHealth(maxHealth * healthMultiplier);
        witch.setGlowing(true);
        this.transformedWitches.add(witch.getUniqueId());
        String message = this.plugin.getConfig().getString("bat_transformation.message", "\u00a75\u00a7l\u2726 \u00a7dThe bat transforms into a witch! \u00a75\u00a7l\u2726");
        bat.getKiller().sendMessage(message.replace("%PLAYER%", bat.getKiller().getName()));
        this.plugin.playSpookySound(bat.getKiller());
    }

    @EventHandler
    public void onTransformedWitchDeath(EntityDeathEvent event) {
        if (!(event.getEntity() instanceof Witch)) {
            return;
        }
        Witch witch = (Witch)event.getEntity();
        if (!this.transformedWitches.contains(witch.getUniqueId())) {
            return;
        }
        this.transformedWitches.remove(witch.getUniqueId());
        event.getDrops().clear();
        event.setDroppedExp(1);
        if (witch.getKiller() != null) {
            int pumpkinMin = this.plugin.getConfig().getInt("bat_transformation.rewards.pumpkins_min", 3);
            int pumpkinMax = this.plugin.getConfig().getInt("bat_transformation.rewards.pumpkins_max", 8);
            int pumpkinAmount = pumpkinMin + this.plugin.getRandom().nextInt(pumpkinMax - pumpkinMin + 1);
            event.getDrops().add(new ItemStack(Material.CARVED_PUMPKIN, pumpkinAmount));
            if (this.plugin.getConfig().getBoolean("bat_transformation.rewards.potion_drop", true)) {
                ItemStack potion = new ItemStack(Material.POTION);
                PotionMeta meta = (PotionMeta)potion.getItemMeta();
                PotionType[] potionTypes = new PotionType[]{PotionType.STRENGTH, PotionType.SWIFTNESS, PotionType.REGENERATION, PotionType.HEALING, PotionType.FIRE_RESISTANCE};
                PotionType randomType = potionTypes[this.plugin.getRandom().nextInt(potionTypes.length)];
                meta.setBasePotionType(randomType);
                potion.setItemMeta((ItemMeta)meta);
                event.getDrops().add(potion);
            }
            int xpReward = this.plugin.getConfig().getInt("bat_transformation.xp_reward", 5);
            this.plugin.giveSmartXpReward(witch.getKiller(), xpReward, 1.0);
            witch.getKiller().sendMessage(String.format("\u00a7d\u2726 Bat Witch defeated! \u00a7e+%d pumpkins", pumpkinAmount));
        }
    }

    public void despawnAllWitches() {
        block0: for (UUID witchId : new HashSet<UUID>(this.transformedWitches)) {
            for (LivingEntity entity : ((World)this.plugin.getServer().getWorlds().get(0)).getLivingEntities()) {
                if (!entity.getUniqueId().equals(witchId)) continue;
                entity.remove();
                continue block0;
            }
        }
        this.transformedWitches.clear();
    }
}

