/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft.tasks;

import cz.softici.server.minecraft.HalloweenPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SlendermanTask {
    private final HalloweenPlugin plugin;
    private final Player player;
    private int taskId = -1;

    public SlendermanTask(HalloweenPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void scheduleNext() {
        int[] range = this.plugin.getData().getInterval("slenderman");
        int min = range[0];
        int max = range[1];
        long delay = this.minutesToTicks(min + this.plugin.getRandom().nextInt(max - min + 1));
        this.taskId = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.plugin.getData().isGlobalEnabled() && this.plugin.isEligible(this.player)) {
                Location loc = this.player.getLocation().add(this.player.getLocation().getDirection().normalize().multiply(1));
                Enderman enderman = (Enderman)this.player.getWorld().spawn(loc, Enderman.class);
                this.plugin.broadcastAll(this.plugin.getMessages().getRandomMessage("slenderman", this.player.getName()));
                this.plugin.playSpookySound(this.player);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> ((Enderman)enderman).remove(), 10L);
            }
            this.scheduleNext();
        }, delay).getTaskId();
    }

    public void cancel() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
    }

    private long minutesToTicks(int minutes) {
        return (long)minutes * 60L * 20L;
    }
}

