/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft.tasks;

import cz.softici.server.minecraft.HalloweenPlugin;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PumpkinTask {
    private final HalloweenPlugin plugin;
    private final Player player;
    private int taskId = -1;

    public PumpkinTask(HalloweenPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void scheduleNext() {
        int[] range = this.plugin.getData().getInterval("pumpkin");
        int min = range[0];
        int max = range[1];
        long delay = this.minutesToTicks(min + this.plugin.getRandom().nextInt(max - min + 1));
        this.taskId = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.plugin.getData().isGlobalEnabled() && this.plugin.isEligible(this.player)) {
                this.plugin.applyPumpkinIfPossible(this.player, true);
            }
            this.scheduleNext();
        }, delay).getTaskId();
    }

    public void cancel() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
    }

    private long minutesToTicks(int minutes) {
        return (long)minutes * 60L * 20L;
    }
}

