/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft.tasks;

import cz.softici.server.minecraft.HalloweenPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DarknessTask {
    private final HalloweenPlugin plugin;
    private final Player player;
    private int taskId = -1;

    public DarknessTask(HalloweenPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void scheduleNext() {
        int[] range = this.plugin.getData().getInterval("darkness");
        int min = range[0];
        int max = range[1];
        long delay = this.minutesToTicks(min + this.plugin.getRandom().nextInt(max - min + 1));
        this.taskId = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.plugin.getData().isGlobalEnabled() && this.plugin.isEligible(this.player)) {
                this.player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 20, 0, false, false, true));
                this.player.playSound(this.player.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_CLOSE, 1.0f, 0.5f);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (this.player.isOnline()) {
                        this.player.playSound(this.player.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_OPEN, 0.9f, 0.6f);
                    }
                }, 3L);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (this.player.isOnline()) {
                        this.player.playSound(this.player.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_CLOSE, 0.8f, 0.4f);
                    }
                }, 6L);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (this.player.isOnline()) {
                        this.player.playSound(this.player.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_OPEN, 1.0f, 0.5f);
                    }
                }, 9L);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (this.player.isOnline()) {
                        this.player.playSound(this.player.getLocation(), Sound.AMBIENT_CAVE, 0.4f, 0.5f);
                    }
                }, 5L);
                this.plugin.broadcastAll(this.plugin.getMessages().getRandomMessage("darkness", this.player.getName()));
            }
            this.scheduleNext();
        }, delay).getTaskId();
    }

    public void cancel() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
    }

    private long minutesToTicks(int minutes) {
        return (long)minutes * 60L * 20L;
    }
}

