/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft;

import cz.softici.server.minecraft.HalloweenPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class PlayerDataManager {
    private final HalloweenPlugin plugin;
    private File file;
    private FileConfiguration config;
    private boolean globalEnabled;
    private final Set<UUID> disabledPlayers = new HashSet<UUID>();
    private final Map<UUID, Integer> pumpkinCounts = new HashMap<UUID, Integer>();
    private final Set<UUID> pumpkinPranked = new HashSet<UUID>();
    private final Set<UUID> helmetRewarded = new HashSet<UUID>();
    private final Map<UUID, Integer> helmetRewardTier = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> lastHelmetReward = new HashMap<UUID, Long>();
    private final Map<String, int[]> intervals = new HashMap<String, int[]>();

    public PlayerDataManager(HalloweenPlugin plugin) {
        this.plugin = plugin;
    }

    public void load() {
        this.file = new File(this.plugin.getDataFolder(), "data.yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Could not create data.yml!");
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.globalEnabled = this.config.getBoolean("global-enabled", true);
        this.disabledPlayers.clear();
        for (String s : this.config.getStringList("disabled")) {
            try {
                this.disabledPlayers.add(UUID.fromString(s));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.pumpkinCounts.clear();
        if (this.config.isConfigurationSection("pumpkin-counts")) {
            for (String key : this.config.getConfigurationSection("pumpkin-counts").getKeys(false)) {
                this.pumpkinCounts.put(UUID.fromString(key), this.config.getInt("pumpkin-counts." + key, 0));
            }
        }
        this.pumpkinPranked.clear();
        for (String s : this.config.getStringList("pumpkin-pranked")) {
            try {
                this.pumpkinPranked.add(UUID.fromString(s));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.helmetRewarded.clear();
        for (String s : this.config.getStringList("helmet-rewarded")) {
            try {
                this.helmetRewarded.add(UUID.fromString(s));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.helmetRewardTier.clear();
        if (this.config.isConfigurationSection("helmet-reward-tier")) {
            for (String key : this.config.getConfigurationSection("helmet-reward-tier").getKeys(false)) {
                this.helmetRewardTier.put(UUID.fromString(key), this.config.getInt("helmet-reward-tier." + key, 0));
            }
        }
        this.lastHelmetReward.clear();
        if (this.config.isConfigurationSection("last-helmet-reward")) {
            for (String key : this.config.getConfigurationSection("last-helmet-reward").getKeys(false)) {
                this.lastHelmetReward.put(UUID.fromString(key), this.config.getLong("last-helmet-reward." + key, 0L));
            }
        }
        this.loadIntervals("pumpkin", 1, 10);
        this.loadIntervals("slenderman", 10, 15);
        this.loadIntervals("fire", 30, 60);
        this.loadIntervals("lightning", 20, 40);
        this.loadIntervals("darkness", 10, 50);
    }

    public void save() {
        if (this.config == null) {
            return;
        }
        this.config.set("global-enabled", (Object)this.globalEnabled);
        ArrayList<String> disabledList = new ArrayList<String>();
        for (UUID uUID : this.disabledPlayers) {
            disabledList.add(uUID.toString());
        }
        this.config.set("disabled", disabledList);
        for (UUID uUID : this.pumpkinCounts.keySet()) {
            this.config.set("pumpkin-counts." + String.valueOf(uUID), (Object)this.pumpkinCounts.get(uUID));
        }
        ArrayList<String> prankList = new ArrayList<String>();
        for (UUID uUID : this.pumpkinPranked) {
            prankList.add(uUID.toString());
        }
        this.config.set("pumpkin-pranked", prankList);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (UUID uUID : this.helmetRewarded) {
            arrayList.add(uUID.toString());
        }
        this.config.set("helmet-rewarded", arrayList);
        for (UUID uUID : this.helmetRewardTier.keySet()) {
            this.config.set("helmet-reward-tier." + String.valueOf(uUID), (Object)this.helmetRewardTier.get(uUID));
        }
        for (UUID uUID : this.lastHelmetReward.keySet()) {
            this.config.set("last-helmet-reward." + String.valueOf(uUID), (Object)this.lastHelmetReward.get(uUID));
        }
        for (Map.Entry<String, int[]> entry : this.intervals.entrySet()) {
            this.config.set("intervals." + entry.getKey() + ".min", (Object)entry.getValue()[0]);
            this.config.set("intervals." + entry.getKey() + ".max", (Object)entry.getValue()[1]);
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException iOException) {
            this.plugin.getLogger().warning("Could not save data.yml!");
        }
    }

    public void saveAsync() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::save);
    }

    public boolean isGlobalEnabled() {
        return this.globalEnabled;
    }

    public void setGlobalEnabled(boolean enabled) {
        this.globalEnabled = enabled;
    }

    public boolean isDisabled(UUID id) {
        return this.disabledPlayers.contains(id);
    }

    public void setDisabled(UUID id, boolean disabled) {
        if (disabled) {
            this.disabledPlayers.add(id);
        } else {
            this.disabledPlayers.remove(id);
        }
    }

    public int incrementPumpkinCount(UUID id) {
        int newCount = this.pumpkinCounts.getOrDefault(id, 0) + 1;
        this.pumpkinCounts.put(id, newCount);
        return newCount;
    }

    public boolean hasPumpkinPrank(UUID id) {
        return this.pumpkinPranked.contains(id);
    }

    public void setPumpkinPrank(UUID id, boolean prank) {
        if (prank) {
            this.pumpkinPranked.add(id);
        } else {
            this.pumpkinPranked.remove(id);
        }
    }

    public boolean hasHelmetReward(UUID id) {
        return this.helmetRewarded.contains(id);
    }

    public void setHelmetReward(UUID id, boolean reward) {
        if (reward) {
            this.helmetRewarded.add(id);
        } else {
            this.helmetRewarded.remove(id);
        }
    }

    public int getHelmetRewardTier(UUID id) {
        return this.helmetRewardTier.getOrDefault(id, 0);
    }

    public void incrementHelmetRewardTier(UUID id) {
        int tier = this.helmetRewardTier.getOrDefault(id, 0) + 1;
        this.helmetRewardTier.put(id, tier);
    }

    public long getLastHelmetReward(UUID id) {
        return this.lastHelmetReward.getOrDefault(id, 0L);
    }

    public void setLastHelmetReward(UUID id, long time) {
        this.lastHelmetReward.put(id, time);
    }

    public int getRequiredMinutesForTier(int tier) {
        if (tier == 0) {
            return 3;
        }
        if (tier >= 10) {
            return 30;
        }
        return tier * 3;
    }

    public void resetPumpkinPranked() {
        this.pumpkinPranked.clear();
    }

    public void resetHelmetRewarded() {
        this.helmetRewarded.clear();
        this.helmetRewardTier.clear();
        this.lastHelmetReward.clear();
    }

    public void resetAll() {
        this.pumpkinPranked.clear();
        this.helmetRewarded.clear();
        this.helmetRewardTier.clear();
        this.lastHelmetReward.clear();
        this.pumpkinCounts.clear();
    }

    private void loadIntervals(String key, int defMin, int defMax) {
        int min = this.config.getInt("intervals." + key + ".min", defMin);
        int max = this.config.getInt("intervals." + key + ".max", defMax);
        this.intervals.put(key, new int[]{min, max});
    }

    public int[] getInterval(String action) {
        return this.intervals.getOrDefault(action, new int[]{5, 10});
    }

    public void setInterval(String action, int min, int max) {
        this.intervals.put(action, new int[]{min, max});
    }
}

