/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft;

import cz.softici.server.minecraft.HalloweenPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final HalloweenPlugin plugin;
    private File file;
    private FileConfiguration config;
    private final Random random = new Random();

    public MessageManager(HalloweenPlugin plugin) {
        this.plugin = plugin;
        this.createOrLoad();
    }

    private void createOrLoad() {
        this.file = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.file.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.mergeDefaults();
    }

    private void mergeDefaults() {
        InputStream defaultStream = this.plugin.getResource("messages.yml");
        if (defaultStream == null) {
            return;
        }
        YamlConfiguration defaults = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream, StandardCharsets.UTF_8));
        boolean modified = false;
        for (String key : defaults.getKeys(false)) {
            if (this.config.contains(key)) continue;
            this.config.set(key, (Object)defaults.getStringList(key));
            modified = true;
            this.plugin.getLogger().info("Added new message category: " + key);
        }
        if (modified) {
            this.save();
        }
        try {
            defaultStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getRandomMessage(String category, String playerName) {
        List list = this.config.getStringList(category);
        if (list == null || list.isEmpty()) {
            return "[Missing message: " + category + "]";
        }
        String msg = (String)list.get(this.random.nextInt(list.size()));
        return msg.replace("%PLAYER%", playerName);
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save messages.yml!");
        }
    }
}

