/*
 * Decompiled with CFR 0.152.
 */
package cz.softici.server.minecraft;

import cz.softici.server.minecraft.MessageManager;
import cz.softici.server.minecraft.PlayerDataManager;
import cz.softici.server.minecraft.tasks.DarknessTask;
import cz.softici.server.minecraft.tasks.FireTask;
import cz.softici.server.minecraft.tasks.LightningTask;
import cz.softici.server.minecraft.tasks.PumpkinTask;
import cz.softici.server.minecraft.tasks.SlendermanTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class HalloweenPlugin
extends JavaPlugin
implements Listener,
TabExecutor {
    private final Random random = new Random();
    private PlayerDataManager data;
    private MessageManager messages;
    private final Set<UUID> fireProtected = new HashSet<UUID>();
    private final Map<UUID, Long> pumpkinHelmetStart = new HashMap<UUID, Long>();
    private final Map<UUID, PumpkinTask> pumpkinTasks = new HashMap<UUID, PumpkinTask>();
    private final Map<UUID, SlendermanTask> slendermanTasks = new HashMap<UUID, SlendermanTask>();
    private final Map<UUID, FireTask> fireTasks = new HashMap<UUID, FireTask>();
    private final Map<UUID, LightningTask> lightningTasks = new HashMap<UUID, LightningTask>();
    private final Map<UUID, DarknessTask> darknessTasks = new HashMap<UUID, DarknessTask>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.saveResource("messages.yml", false);
        this.data = new PlayerDataManager(this);
        this.data.load();
        this.messages = new MessageManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("halloween")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("halloween")).setTabCompleter((TabCompleter)this);
        if (this.data.isGlobalEnabled()) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.startTasksForPlayer(p);
            }
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this, this::applyPumpkinBuffs, 20L, 100L);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, this::checkHelmetRewards, 20L, 400L);
        this.getLogger().info("Halloween Plugin v1.4.0 enabled \ud83c\udf83");
    }

    public void onDisable() {
        this.stopAllTasks();
        this.data.save();
        this.getLogger().info("Halloween Plugin v1.4.0 disabled.");
    }

    public PlayerDataManager getData() {
        return this.data;
    }

    public MessageManager getMessages() {
        return this.messages;
    }

    public Random getRandom() {
        return this.random;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (this.data.isGlobalEnabled()) {
            this.startTasksForPlayer(p);
            if (!this.data.isDisabled(p.getUniqueId())) {
                this.applyPumpkinIfPossible(p, false);
                this.playSpookySound(p);
            }
        }
        p.sendMessage("\ud83d\udc7b Spooky times have arrived... Type /halloween disable if you don't dare to be cursed.");
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.stopTasksForPlayer(e.getPlayer());
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        if (!this.fireProtected.contains(p.getUniqueId())) {
            return;
        }
        switch (e.getCause()) {
            case FIRE: 
            case FIRE_TICK: 
            case LIGHTNING: {
                e.setCancelled(true);
                e.setDamage(0.0);
                break;
            }
        }
    }

    public boolean isEligible(Player p) {
        return p != null && p.isOnline() && !this.data.isDisabled(p.getUniqueId());
    }

    public void broadcastAll(String msg) {
        for (Player online : Bukkit.getOnlinePlayers()) {
            online.sendMessage(msg);
        }
    }

    public void playSpookySound(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 1.0f, 1.0f);
        player.playSound(player.getLocation(), Sound.AMBIENT_CAVE, 0.7f, 0.5f);
    }

    public void applyPumpkinIfPossible(Player player, boolean broadcast) {
        boolean hasSpace;
        if (player == null || !player.isOnline()) {
            return;
        }
        ItemStack pumpkin = new ItemStack(Material.CARVED_PUMPKIN);
        boolean bl = hasSpace = player.getInventory().firstEmpty() != -1;
        if (player.getInventory().getHelmet() == null) {
            if (hasSpace) {
                player.getInventory().setHelmet(pumpkin);
                this.afterPumpkinApplied(player, broadcast);
            }
        } else if (hasSpace) {
            ItemStack currentHelmet = player.getInventory().getHelmet();
            player.getInventory().addItem(new ItemStack[]{currentHelmet});
            player.getInventory().setHelmet(pumpkin);
            this.afterPumpkinApplied(player, broadcast);
        }
    }

    private void afterPumpkinApplied(Player player, boolean broadcast) {
        int count;
        this.playSpookySound(player);
        if (broadcast) {
            this.broadcastAll(this.messages.getRandomMessage("pumpkin", player.getName()));
        }
        if ((count = this.data.incrementPumpkinCount(player.getUniqueId())) == 3 && !this.data.hasPumpkinPrank(player.getUniqueId())) {
            this.fillFreeSlotsWithPumpkins(player);
            this.data.setPumpkinPrank(player.getUniqueId(), true);
            this.broadcastAll(this.messages.getRandomMessage("pumpkinEasterEgg", player.getName()));
        }
        this.data.saveAsync();
    }

    private void fillFreeSlotsWithPumpkins(Player p) {
        ItemStack stack = new ItemStack(Material.CARVED_PUMPKIN, 64);
        for (int i = 0; i < p.getInventory().getSize(); ++i) {
            if (p.getInventory().getItem(i) != null) continue;
            p.getInventory().setItem(i, stack.clone());
        }
        p.sendMessage("\ud83c\udf83 Surprise! Your love for pumpkins has been\u2026 noted.");
    }

    public void ignitePlayerHarmlessly(Player p, int seconds) {
        if (p == null || !p.isOnline()) {
            return;
        }
        this.fireProtected.add(p.getUniqueId());
        p.setFireTicks(seconds * 20);
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            this.fireProtected.remove(p.getUniqueId());
            p.setFireTicks(0);
        }, (long)seconds * 20L + 1L);
    }

    private void applyPumpkinBuffs() {
        if (!this.getConfig().getBoolean("pumpkin_buffs.enabled", true)) {
            return;
        }
        boolean glowing = this.getConfig().getBoolean("pumpkin_buffs.glowing", true);
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.getInventory().getHelmet() != null && p.getInventory().getHelmet().getType() == Material.CARVED_PUMPKIN) {
                if (this.getConfig().contains("pumpkin_buffs.effects")) {
                    List effects = this.getConfig().getMapList("pumpkin_buffs.effects");
                    for (Map effectMap : effects) {
                        try {
                            if (effectMap.get("enabled") != null && !Boolean.parseBoolean(effectMap.get("enabled").toString())) continue;
                            String typeName = effectMap.get("type").toString();
                            int level = Integer.parseInt(effectMap.get("level").toString());
                            PotionEffectType effectType = PotionEffectType.getByName((String)typeName);
                            if (effectType == null) continue;
                            p.addPotionEffect(new PotionEffect(effectType, 220, level, true, false, true));
                        }
                        catch (Exception exception) {}
                    }
                }
                if (!glowing) continue;
                p.setGlowing(true);
                continue;
            }
            if (!glowing) continue;
            p.setGlowing(false);
        }
    }

    private void checkHelmetRewards() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!this.isEligible(p)) continue;
            UUID id = p.getUniqueId();
            if (p.getInventory().getHelmet() == null) {
                this.pumpkinHelmetStart.remove(id);
                continue;
            }
            if (p.getInventory().getHelmet().getType() == Material.CARVED_PUMPKIN) {
                boolean firstReward;
                this.pumpkinHelmetStart.putIfAbsent(id, System.currentTimeMillis());
                long start = this.pumpkinHelmetStart.get(id);
                long elapsed = System.currentTimeMillis() - start;
                long lastReward = this.data.getLastHelmetReward(id);
                int currentTier = this.data.getHelmetRewardTier(id);
                int requiredMinutes = this.data.getRequiredMinutesForTier(currentTier);
                long requiredMillis = (long)requiredMinutes * 60L * 1000L;
                long timeSinceLastReward = System.currentTimeMillis() - lastReward;
                boolean bl = firstReward = lastReward == 0L;
                if ((!firstReward || elapsed < requiredMillis) && (firstReward || timeSinceLastReward < requiredMillis)) continue;
                p.getInventory().addItem(new ItemStack[]{new ItemStack(Material.CAKE)});
                this.data.incrementHelmetRewardTier(id);
                this.data.setLastHelmetReward(id, System.currentTimeMillis());
                if (!this.data.hasHelmetReward(id)) {
                    this.data.setHelmetReward(id, true);
                }
                int nextTier = this.data.getHelmetRewardTier(id);
                int nextMinutes = this.data.getRequiredMinutesForTier(nextTier);
                this.broadcastAll(this.messages.getRandomMessage("helmetReward", p.getName()));
                p.sendMessage(String.format("\u00a76\ud83c\udf70 Next reward in %d minutes of continuous pumpkin wearing!", nextMinutes));
                this.data.saveAsync();
                continue;
            }
            this.pumpkinHelmetStart.remove(id);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("Halloween plugin by Softici s.r.o.");
            return true;
        }
        String sub = args[0].toLowerCase(Locale.ROOT);
        if (sub.equals("help")) {
            sender.sendMessage("\u00a76=== Halloween Plugin Commands ===");
            sender.sendMessage("\u00a7e/halloween help \u00a77- Show commands");
            sender.sendMessage("\u00a7e/halloween enable|disable \u00a77- Player controls");
            sender.sendMessage("\u00a7c=== Admin Commands ===");
            sender.sendMessage("\u00a7e/halloween on|off \u00a77- Global toggle");
            sender.sendMessage("\u00a7e/halloween set <action> <min> <max> \u00a77- Adjust intervals");
            sender.sendMessage("\u00a7e/halloween reset <pumpkin|helmet|all> \u00a77- Reset states");
            sender.sendMessage("\u00a7e/halloween reload \u00a77- Reload configs");
            sender.sendMessage("\u00a7e/halloween buffs list \u00a77- List all pumpkin buffs");
            sender.sendMessage("\u00a7e/halloween buffs toggle \u00a77- Toggle all buffs on/off");
            sender.sendMessage("\u00a7e/halloween buffs glow <on|off> \u00a77- Toggle glowing effect");
            sender.sendMessage("\u00a7e/halloween buffs add <effect> <level> \u00a77- Add a buff");
            sender.sendMessage("\u00a7e/halloween buffs remove <effect> \u00a77- Remove a buff");
            sender.sendMessage("\u00a7e/halloween buffs enable <effect> \u00a77- Enable a buff");
            sender.sendMessage("\u00a7e/halloween buffs disable <effect> \u00a77- Disable a buff");
            sender.sendMessage("\u00a7e/halloween buffs level <effect> <level> \u00a77- Change buff level");
            return true;
        }
        if (sub.equals("enable") || sub.equals("disable")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Only players can use this command.");
                return true;
            }
            Player p = (Player)sender;
            boolean disable = sub.equals("disable");
            this.data.setDisabled(p.getUniqueId(), disable);
            this.data.saveAsync();
            p.sendMessage("\ud83c\udf83 Halloween effects " + (disable ? "disabled" : "enabled") + " for you.");
            return true;
        }
        if (!sender.hasPermission("halloween.use")) {
            sender.sendMessage("You don't have permission.");
            return true;
        }
        switch (sub) {
            case "on": {
                this.data.setGlobalEnabled(true);
                this.data.saveAsync();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    this.startTasksForPlayer(p);
                }
                this.broadcastAll("\ud83c\udf83 Halloween mode ENABLED!");
                break;
            }
            case "off": {
                this.data.setGlobalEnabled(false);
                this.data.saveAsync();
                this.stopAllTasks();
                this.broadcastAll("\ud83d\udd6f\ufe0f Halloween mode DISABLED.");
                break;
            }
            case "reload": {
                this.reloadConfig();
                this.data.load();
                this.messages.reload();
                sender.sendMessage("\ud83c\udf83 Halloween config and messages reloaded.");
                break;
            }
            case "set": {
                if (args.length != 4) {
                    sender.sendMessage("Usage: /halloween set <pumpkin|slenderman|fire|lightning|darkness> <min> <max>");
                    return true;
                }
                try {
                    String action = args[1].toLowerCase();
                    int min = Integer.parseInt(args[2]);
                    int max = Integer.parseInt(args[3]);
                    this.data.setInterval(action, min, max);
                    this.data.saveAsync();
                    sender.sendMessage("Interval for " + action + " set to " + min + "-" + max + " minutes.");
                }
                catch (Exception e) {
                    sender.sendMessage("Invalid values.");
                }
                break;
            }
            case "reset": {
                String what;
                if (args.length != 2) {
                    sender.sendMessage("Usage: /halloween reset <pumpkin|helmet|all>");
                    return true;
                }
                switch (what = args[1].toLowerCase()) {
                    case "pumpkin": {
                        this.data.resetPumpkinPranked();
                        sender.sendMessage("\ud83c\udf83 Pumpkin easter egg states have been reset.");
                        break;
                    }
                    case "helmet": {
                        this.data.resetHelmetRewarded();
                        sender.sendMessage("\ud83c\udf70 Helmet reward states have been reset.");
                        break;
                    }
                    case "all": {
                        this.data.resetAll();
                        sender.sendMessage("\ud83d\udd04 All one-time events have been reset.");
                        break;
                    }
                    default: {
                        sender.sendMessage("Invalid reset type. Use pumpkin|helmet|all");
                        return true;
                    }
                }
                this.data.saveAsync();
                break;
            }
            case "buffs": {
                return this.handleBuffsCommand(sender, args);
            }
            default: {
                sender.sendMessage("Unknown command. Try /halloween help");
            }
        }
        return true;
    }

    private boolean handleBuffsCommand(CommandSender sender, String[] args) {
        String subCmd;
        if (args.length < 2) {
            sender.sendMessage("Usage: /halloween buffs <list|toggle|glow|add|remove|enable|disable|level>");
            return true;
        }
        switch (subCmd = args[1].toLowerCase()) {
            case "list": {
                sender.sendMessage("\u00a76=== Pumpkin Helmet Buffs ===");
                sender.sendMessage("\u00a77Status: " + (this.getConfig().getBoolean("pumpkin_buffs.enabled", true) ? "\u00a7aEnabled" : "\u00a7cDisabled"));
                sender.sendMessage("\u00a77Glowing: " + (this.getConfig().getBoolean("pumpkin_buffs.glowing", true) ? "\u00a7aOn" : "\u00a7cOff"));
                sender.sendMessage("\u00a76Active Effects:");
                if (!this.getConfig().contains("pumpkin_buffs.effects")) break;
                List effects = this.getConfig().getMapList("pumpkin_buffs.effects");
                for (Map effectMap : effects) {
                    String type = effectMap.get("type").toString();
                    int level = Integer.parseInt(effectMap.get("level").toString());
                    boolean enabled = effectMap.get("enabled") == null || Boolean.parseBoolean(effectMap.get("enabled").toString());
                    String status = enabled ? "\u00a7a\u2713" : "\u00a7c\u2717";
                    sender.sendMessage(String.format("  %s \u00a7e%s \u00a77Level %d", status, type, level + 1));
                }
                break;
            }
            case "toggle": {
                boolean currentEnabled = this.getConfig().getBoolean("pumpkin_buffs.enabled", true);
                this.getConfig().set("pumpkin_buffs.enabled", (Object)(!currentEnabled ? 1 : 0));
                this.saveConfig();
                sender.sendMessage("\u00a76Pumpkin buffs " + (!currentEnabled ? "\u00a7aenabled" : "\u00a7cdisabled") + "\u00a76.");
                break;
            }
            case "glow": {
                if (args.length < 3) {
                    sender.sendMessage("Usage: /halloween buffs glow <on|off>");
                    return true;
                }
                boolean glowOn = args[2].equalsIgnoreCase("on");
                this.getConfig().set("pumpkin_buffs.glowing", (Object)glowOn);
                this.saveConfig();
                sender.sendMessage("\u00a76Glowing effect " + (glowOn ? "\u00a7aenabled" : "\u00a7cdisabled") + "\u00a76.");
                break;
            }
            case "add": {
                if (args.length < 4) {
                    sender.sendMessage("Usage: /halloween buffs add <effect> <level>");
                    return true;
                }
                return this.addBuff(sender, args[2].toUpperCase(), Integer.parseInt(args[3]) - 1);
            }
            case "remove": {
                if (args.length < 3) {
                    sender.sendMessage("Usage: /halloween buffs remove <effect>");
                    return true;
                }
                return this.removeBuff(sender, args[2].toUpperCase());
            }
            case "enable": 
            case "disable": {
                if (args.length < 3) {
                    sender.sendMessage("Usage: /halloween buffs " + subCmd + " <effect>");
                    return true;
                }
                return this.toggleBuff(sender, args[2].toUpperCase(), subCmd.equals("enable"));
            }
            case "level": {
                if (args.length < 4) {
                    sender.sendMessage("Usage: /halloween buffs level <effect> <level>");
                    return true;
                }
                return this.setBuffLevel(sender, args[2].toUpperCase(), Integer.parseInt(args[3]) - 1);
            }
            default: {
                sender.sendMessage("Unknown buffs command. Try /halloween help");
            }
        }
        return true;
    }

    private boolean addBuff(CommandSender sender, String effectName, int level) {
        List effects = this.getConfig().getMapList("pumpkin_buffs.effects");
        for (Map effectMap : effects) {
            if (!effectMap.get("type").toString().equalsIgnoreCase(effectName)) continue;
            sender.sendMessage("\u00a7cEffect " + effectName + " already exists. Use /halloween buffs level to change it.");
            return true;
        }
        PotionEffectType effectType = PotionEffectType.getByName((String)effectName);
        if (effectType == null) {
            sender.sendMessage("\u00a7cInvalid effect type: " + effectName);
            return true;
        }
        HashMap<String, Object> newEffect = new HashMap<String, Object>();
        newEffect.put("type", effectName);
        newEffect.put("level", level);
        newEffect.put("enabled", true);
        ArrayList newEffects = new ArrayList();
        for (Map oldMap : effects) {
            HashMap copy = new HashMap();
            copy.put("type", oldMap.get("type"));
            copy.put("level", oldMap.get("level"));
            copy.put("enabled", oldMap.get("enabled"));
            newEffects.add(copy);
        }
        newEffects.add(newEffect);
        this.getConfig().set("pumpkin_buffs.effects", newEffects);
        this.saveConfig();
        sender.sendMessage("\u00a7aAdded effect " + effectName + " at level " + (level + 1) + ".");
        return true;
    }

    private boolean removeBuff(CommandSender sender, String effectName) {
        List effects = this.getConfig().getMapList("pumpkin_buffs.effects");
        ArrayList newEffects = new ArrayList();
        boolean found = false;
        for (Map effectMap : effects) {
            if (!effectMap.get("type").toString().equalsIgnoreCase(effectName)) {
                HashMap copy = new HashMap();
                copy.put("type", effectMap.get("type"));
                copy.put("level", effectMap.get("level"));
                copy.put("enabled", effectMap.get("enabled"));
                newEffects.add(copy);
                continue;
            }
            found = true;
        }
        if (!found) {
            sender.sendMessage("\u00a7cEffect " + effectName + " not found.");
            return true;
        }
        this.getConfig().set("pumpkin_buffs.effects", newEffects);
        this.saveConfig();
        sender.sendMessage("\u00a7aRemoved effect " + effectName + ".");
        return true;
    }

    private boolean toggleBuff(CommandSender sender, String effectName, boolean enable) {
        List effects = this.getConfig().getMapList("pumpkin_buffs.effects");
        ArrayList newEffects = new ArrayList();
        boolean found = false;
        for (Map effectMap : effects) {
            HashMap copy = new HashMap();
            copy.put("type", effectMap.get("type"));
            copy.put("level", effectMap.get("level"));
            if (effectMap.get("type").toString().equalsIgnoreCase(effectName)) {
                copy.put("enabled", enable);
                found = true;
            } else {
                copy.put("enabled", effectMap.get("enabled"));
            }
            newEffects.add(copy);
        }
        if (!found) {
            sender.sendMessage("\u00a7cEffect " + effectName + " not found.");
            return true;
        }
        this.getConfig().set("pumpkin_buffs.effects", newEffects);
        this.saveConfig();
        sender.sendMessage("\u00a7a" + (enable ? "Enabled" : "Disabled") + " effect " + effectName + ".");
        return true;
    }

    private boolean setBuffLevel(CommandSender sender, String effectName, int level) {
        List effects = this.getConfig().getMapList("pumpkin_buffs.effects");
        ArrayList newEffects = new ArrayList();
        boolean found = false;
        for (Map effectMap : effects) {
            HashMap copy = new HashMap();
            copy.put("type", effectMap.get("type"));
            copy.put("enabled", effectMap.get("enabled"));
            if (effectMap.get("type").toString().equalsIgnoreCase(effectName)) {
                copy.put("level", level);
                found = true;
            } else {
                copy.put("level", effectMap.get("level"));
            }
            newEffects.add(copy);
        }
        if (!found) {
            sender.sendMessage("\u00a7cEffect " + effectName + " not found.");
            return true;
        }
        this.getConfig().set("pumpkin_buffs.effects", newEffects);
        this.saveConfig();
        sender.sendMessage("\u00a7aSet " + effectName + " to level " + (level + 1) + ".");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("help", "enable", "disable", "on", "off", "set", "reset", "reload", "buffs");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("set")) {
            return Arrays.asList("pumpkin", "slenderman", "fire", "lightning", "darkness");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("reset")) {
            return Arrays.asList("pumpkin", "helmet", "all");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("buffs")) {
            return Arrays.asList("list", "toggle", "glow", "add", "remove", "enable", "disable", "level");
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("buffs") && args[1].equalsIgnoreCase("glow")) {
            return Arrays.asList("on", "off");
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("buffs") && (args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("remove") || args[1].equalsIgnoreCase("enable") || args[1].equalsIgnoreCase("disable") || args[1].equalsIgnoreCase("level"))) {
            return Arrays.asList("SPEED", "HASTE", "STRENGTH", "REGENERATION", "RESISTANCE", "JUMP_BOOST", "NIGHT_VISION", "INVISIBILITY", "FIRE_RESISTANCE", "WATER_BREATHING", "ABSORPTION", "HEALTH_BOOST", "LUCK", "SLOW_FALLING");
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("buffs") && (args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("level"))) {
            return Arrays.asList("1", "2", "3", "4", "5");
        }
        return Collections.emptyList();
    }

    private void startTasksForPlayer(Player p) {
        UUID id = p.getUniqueId();
        if (!this.pumpkinTasks.containsKey(id)) {
            PumpkinTask pt = new PumpkinTask(this, p);
            pt.scheduleNext();
            this.pumpkinTasks.put(id, pt);
        }
        if (!this.slendermanTasks.containsKey(id)) {
            SlendermanTask st = new SlendermanTask(this, p);
            st.scheduleNext();
            this.slendermanTasks.put(id, st);
        }
        if (!this.fireTasks.containsKey(id)) {
            FireTask ft = new FireTask(this, p);
            ft.scheduleNext();
            this.fireTasks.put(id, ft);
        }
        if (!this.lightningTasks.containsKey(id)) {
            LightningTask lt = new LightningTask(this, p);
            lt.scheduleNext();
            this.lightningTasks.put(id, lt);
        }
        if (!this.darknessTasks.containsKey(id)) {
            DarknessTask dt = new DarknessTask(this, p);
            dt.scheduleNext();
            this.darknessTasks.put(id, dt);
        }
    }

    private void stopTasksForPlayer(Player p) {
        UUID id = p.getUniqueId();
        if (this.pumpkinTasks.containsKey(id)) {
            this.pumpkinTasks.remove(id).cancel();
        }
        if (this.slendermanTasks.containsKey(id)) {
            this.slendermanTasks.remove(id).cancel();
        }
        if (this.fireTasks.containsKey(id)) {
            this.fireTasks.remove(id).cancel();
        }
        if (this.lightningTasks.containsKey(id)) {
            this.lightningTasks.remove(id).cancel();
        }
        if (this.darknessTasks.containsKey(id)) {
            this.darknessTasks.remove(id).cancel();
        }
    }

    private void stopAllTasks() {
        this.pumpkinTasks.values().forEach(PumpkinTask::cancel);
        this.slendermanTasks.values().forEach(SlendermanTask::cancel);
        this.fireTasks.values().forEach(FireTask::cancel);
        this.lightningTasks.values().forEach(LightningTask::cancel);
        this.darknessTasks.values().forEach(DarknessTask::cancel);
        this.pumpkinTasks.clear();
        this.slendermanTasks.clear();
        this.fireTasks.clear();
        this.lightningTasks.clear();
        this.darknessTasks.clear();
    }
}

