/*
 * Decompiled with CFR 0.152.
 */
package net.cherryleaves.import_midi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import net.cherryleaves.import_midi.MidiAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public final class Import_midi
extends JavaPlugin {
    private final Map<Integer, Float> noteToPitch = new HashMap<Integer, Float>();
    private final Map<UUID, List<BukkitTask>> playerTasks = new HashMap<UUID, List<BukkitTask>>();
    private static Import_midi instance;
    String line = "----------------------------------------";

    public void onEnable() {
        instance = this;
        this.initNotePitchMap();
        MidiAPI.initialize(this);
        this.getServer().getCommandMap().register("parsemidi", new Command("parsemidi"){

            public boolean execute(CommandSender sender, String commandLabel, String[] args) {
                return Import_midi.this.parseMidiCommand(sender, args);
            }
        });
        this.getServer().getCommandMap().register("playmidi", new Command("playmidi"){

            public boolean execute(CommandSender sender, String commandLabel, String[] args) {
                return Import_midi.this.playMidiCommand(sender, args);
            }
        });
        this.getServer().getCommandMap().register("stopmidi", new Command("stopmidi"){

            public boolean execute(CommandSender sender, String commandLabel, String[] args) {
                return Import_midi.this.stopMidiCommand(sender, args);
            }
        });
        if (!this.getDataFolder().exists()) {
            this.makeFolder();
        }
        this.getLogger().info(this.line);
        this.getLogger().info("Import MIDI\u30d7\u30e9\u30b0\u30a4\u30f3\u304c\u6709\u52b9\u5316\u3055\u308c\u307e\u3057\u305f\uff01");
        this.getLogger().info(" ");
        this.getLogger().info("Import MIDI plugin is enabled!");
        this.getLogger().info(this.line);
    }

    public static Import_midi getInstance() {
        return instance;
    }

    public boolean playMidiToPlayerAPI(Player player, File midiFile) throws InvalidMidiDataException, IOException {
        if (!player.isOnline()) {
            return false;
        }
        this.stopMidiPlaybackAPI(player);
        Sequence sequence = MidiSystem.getSequence(midiFile);
        this.playMidiToPlayer(player, sequence);
        return true;
    }

    public boolean stopMidiPlaybackAPI(Player player) {
        UUID playerId = player.getUniqueId();
        if (!this.playerTasks.containsKey(playerId) || this.playerTasks.get(playerId).isEmpty()) {
            return false;
        }
        List<BukkitTask> tasks = this.playerTasks.get(playerId);
        for (BukkitTask task : tasks) {
            task.cancel();
        }
        tasks.clear();
        return true;
    }

    public String analyzeMidiFileAPI(File midiFile) throws InvalidMidiDataException, IOException {
        Sequence sequence = MidiSystem.getSequence(midiFile);
        StringJoiner info = new StringJoiner("\n");
        info.add("\u89e3\u50cf\u5ea6: " + sequence.getResolution() + " PPQ");
        info.add("\u30c8\u30e9\u30c3\u30af\u6570: " + sequence.getTracks().length);
        for (int t = 0; t < sequence.getTracks().length; ++t) {
            Track track = sequence.getTracks()[t];
            info.add("\u30c8\u30e9\u30c3\u30af " + t + " (\u30a4\u30d9\u30f3\u30c8\u6570: " + track.size() + ")");
            if (track.size() <= 0) continue;
            info.add("  \u6700\u521d\u306e\u30a4\u30d9\u30f3\u30c8: " + Import_midi.messageToString(track.get(0).getMessage()));
            info.add("  \u6700\u5f8c\u306e\u30a4\u30d9\u30f3\u30c8: " + Import_midi.messageToString(track.get(track.size() - 1).getMessage()));
        }
        return info.toString();
    }

    public void onDisable() {
        this.stopAllPlayback();
        this.getLogger().info(this.line);
        this.getLogger().info("Import MIDI\u30d7\u30e9\u30b0\u30a4\u30f3\u304c\u7121\u52b9\u5316\u3055\u308c\u307e\u3057\u305f\uff01");
        this.getLogger().info(" ");
        this.getLogger().info("Import MIDI plugin is disabled!");
        this.getLogger().info(this.line);
    }

    public void makeFolder() {
        this.getDataFolder().mkdirs();
        this.getLogger().info(this.line);
        this.getLogger().info("\u30c7\u30fc\u30bf\u30d5\u30a9\u30eb\u30c0\u3092\u4f5c\u6210\u3057\u307e\u3057\u305f\uff01");
        this.getLogger().info(" ");
        this.getLogger().info("Folder Path ");
        this.getLogger().info("> " + this.getDataFolder().getAbsolutePath());
        this.getLogger().info(this.line);
    }

    private void stopAllPlayback() {
        for (List<BukkitTask> tasks : this.playerTasks.values()) {
            for (BukkitTask task : tasks) {
                task.cancel();
            }
        }
        this.playerTasks.clear();
    }

    private void initNotePitchMap() {
        int baseNote = 54;
        for (int note = 0; note < 128; ++note) {
            int semitonesDiff = note - baseNote;
            float rawPitch = (float)(0.5 * Math.pow(2.0, (double)semitonesDiff / 12.0));
            float adjustedPitch = this.adjustPitchToRange(rawPitch);
            this.noteToPitch.put(note, Float.valueOf(adjustedPitch));
        }
    }

    private float adjustPitchToRange(float pitch) {
        float adjustedPitch;
        for (adjustedPitch = pitch; adjustedPitch < 0.5f; adjustedPitch *= 2.0f) {
        }
        while (adjustedPitch > 2.0f) {
            adjustedPitch /= 2.0f;
        }
        return adjustedPitch;
    }

    private boolean stopMidiCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u3053\u306e\u30b3\u30de\u30f3\u30c9\u306f\u30d7\u30ec\u30a4\u30e4\u30fc\u306e\u307f\u304c\u4f7f\u7528\u3067\u304d\u307e\u3059");
            return false;
        }
        Player player = (Player)sender;
        UUID playerId = player.getUniqueId();
        if (!this.playerTasks.containsKey(playerId) || this.playerTasks.get(playerId).isEmpty()) {
            player.sendMessage("\u518d\u751f\u4e2d\u306eMIDI\u30d5\u30a1\u30a4\u30eb\u306f\u3042\u308a\u307e\u305b\u3093");
            return false;
        }
        List<BukkitTask> tasks = this.playerTasks.get(playerId);
        int canceledCount = 0;
        for (BukkitTask task : tasks) {
            task.cancel();
            ++canceledCount;
        }
        tasks.clear();
        player.sendMessage("MIDI\u518d\u751f\u3092\u505c\u6b62\u3057\u307e\u3057\u305f\uff08" + canceledCount + "\u500b\u306e\u30ce\u30fc\u30c8\u3092\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u307e\u3057\u305f\uff09");
        return true;
    }

    private boolean playMidiCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u3053\u306e\u30b3\u30de\u30f3\u30c9\u306f\u30d7\u30ec\u30a4\u30e4\u30fc\u306e\u307f\u304c\u4f7f\u7528\u3067\u304d\u307e\u3059");
            return false;
        }
        Player player = (Player)sender;
        UUID playerId = player.getUniqueId();
        if (this.playerTasks.containsKey(playerId)) {
            List<BukkitTask> existingTasks = this.playerTasks.get(playerId);
            for (BukkitTask task : existingTasks) {
                task.cancel();
            }
            existingTasks.clear();
            player.sendMessage("\u65e2\u5b58\u306e\u518d\u751f\u3092\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u307e\u3057\u305f");
        }
        try {
            String midiFilePath = args.length > 0 ? args[0] : "index.mid";
            File midiFile = new File(this.getDataFolder(), midiFilePath);
            if (!midiFile.exists()) {
                player.sendMessage("MIDI\u30d5\u30a1\u30a4\u30eb '" + midiFilePath + "' \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
                return false;
            }
            Sequence sequence = MidiSystem.getSequence(midiFile);
            player.sendMessage("MIDI\u30d5\u30a1\u30a4\u30eb '" + midiFilePath + "' \u3092\u518d\u751f\u3057\u307e\u3059...");
            player.sendMessage("\u518d\u751f\u3092\u505c\u6b62\u3059\u308b\u306b\u306f /stopmidi \u30b3\u30de\u30f3\u30c9\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044");
            this.playMidiToPlayer(player, sequence);
            return true;
        }
        catch (Exception e) {
            player.sendMessage("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void playMidiToPlayer(final Player player, Sequence sequence) {
        final UUID playerId = player.getUniqueId();
        List tasks = this.playerTasks.computeIfAbsent(playerId, k -> new ArrayList());
        int resolution = sequence.getResolution();
        float tempoFactor = 1.0f;
        int ticksPerSecond = (int)((float)(resolution * 2) * 1.0f);
        float bpm = 120.0f;
        for (Track track : sequence.getTracks()) {
            for (int i = 0; i < track.size(); ++i) {
                MetaMessage mm;
                MidiEvent event = track.get(i);
                MidiMessage message = event.getMessage();
                if (!(message instanceof MetaMessage) || (mm = (MetaMessage)message).getType() != 81) continue;
                byte[] data = mm.getData();
                int tempo = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
                bpm = 6.0E7f / (float)tempo;
            }
        }
        int adjustedTicksPerSecond = (int)((float)resolution * bpm / 60.0f);
        for (Track track : sequence.getTracks()) {
            for (int i = 0; i < track.size(); ++i) {
                ShortMessage sm;
                MidiEvent event = track.get(i);
                MidiMessage message = event.getMessage();
                if (!(message instanceof ShortMessage) || (sm = (ShortMessage)message).getCommand() != 144 || sm.getData2() <= 0) continue;
                final int note = sm.getData1();
                final int velocity = sm.getData2();
                final int channel = sm.getChannel();
                long delayTicks = event.getTick() * 20L / (long)adjustedTicksPerSecond;
                BukkitTask task = new BukkitRunnable(this){
                    final /* synthetic */ Import_midi this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        if (player.isOnline()) {
                            this.this$0.playNoteToPlayer(player, note, velocity, channel);
                        } else {
                            List<BukkitTask> playerTaskList = this.this$0.playerTasks.get(playerId);
                            if (playerTaskList != null) {
                                playerTaskList.remove(this.getTaskId());
                            }
                            this.cancel();
                        }
                    }
                }.runTaskLater((Plugin)this, delayTicks);
                tasks.add(task);
            }
        }
        long maxTick = this.getMaxTick(sequence);
        long finalDelayTicks = maxTick * 20L / (long)adjustedTicksPerSecond + 20L;
        BukkitTask cleanupTask = new BukkitRunnable(this){
            final /* synthetic */ Import_midi this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                List<BukkitTask> playerTaskList = this.this$0.playerTasks.get(playerId);
                if (playerTaskList != null) {
                    playerTaskList.clear();
                }
                if (player.isOnline()) {
                    player.sendMessage("MIDI\u306e\u518d\u751f\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f");
                }
            }
        }.runTaskLater((Plugin)this, finalDelayTicks);
        tasks.add(cleanupTask);
    }

    private long getMaxTick(Sequence sequence) {
        long maxTick = 0L;
        for (Track track : sequence.getTracks()) {
            for (int i = 0; i < track.size(); ++i) {
                MidiEvent event = track.get(i);
                if (event.getTick() <= maxTick) continue;
                maxTick = event.getTick();
            }
        }
        return maxTick;
    }

    private void playNoteToPlayer(Player player, int note, int velocity, int channel) {
        Location location = player.getLocation();
        float pitch = this.noteToPitch.getOrDefault(note, Float.valueOf(1.0f)).floatValue();
        float volume = Math.max(0.1f, (float)velocity / 127.0f);
        Sound instrument = this.selectInstrument(channel);
        player.playSound(location, instrument, volume, pitch);
    }

    private Sound selectInstrument(int channel) {
        return switch (channel) {
            case 9 -> Sound.BLOCK_NOTE_BLOCK_BASEDRUM;
            case 0, 1 -> Sound.BLOCK_NOTE_BLOCK_HARP;
            case 2, 3, 4, 5 -> Sound.BLOCK_NOTE_BLOCK_GUITAR;
            case 6, 7, 8 -> Sound.BLOCK_NOTE_BLOCK_CHIME;
            case 10, 11, 12, 13 -> Sound.BLOCK_NOTE_BLOCK_BASS;
            case 14, 15 -> Sound.BLOCK_NOTE_BLOCK_FLUTE;
            default -> Sound.BLOCK_NOTE_BLOCK_HARP;
        };
    }

    private boolean parseMidiCommand(CommandSender sender, String[] args) {
        try {
            Sequence sequence;
            String midiFilePath = args.length > 0 ? args[0] : "index.mid";
            File midiFile = new File(this.getDataFolder(), midiFilePath);
            if (!this.getDataFolder().exists()) {
                this.makeFolder();
            }
            if (midiFile.exists()) {
                sequence = MidiSystem.getSequence(midiFile);
                sender.sendMessage("MIDI\u30d5\u30a1\u30a4\u30eb '" + midiFilePath + "' \u3092\u89e3\u6790\u3057\u3066\u3044\u307e\u3059...");
                for (Player p : Bukkit.getOnlinePlayers()) {
                    p.sendMessage(midiFilePath);
                }
            } else {
                sender.sendMessage("\u8b66\u544a: \u30d5\u30a1\u30a4\u30eb '" + midiFilePath + "' \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                sender.sendMessage("\u30b5\u30f3\u30d7\u30eb\u306eMIDI\u30b7\u30fc\u30b1\u30f3\u30b9\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
                sequence = new Sequence(0.0f, 24);
                Track track = sequence.createTrack();
                ShortMessage noteOn = new ShortMessage();
                noteOn.setMessage(144, 0, 60, 93);
                track.add(new MidiEvent(noteOn, 0L));
                ShortMessage noteOff = new ShortMessage();
                noteOff.setMessage(128, 0, 60, 0);
                track.add(new MidiEvent(noteOff, 24L));
            }
            sender.sendMessage("\u30b7\u30fc\u30b1\u30f3\u30b9\u60c5\u5831:");
            sender.sendMessage("- \u89e3\u50cf\u5ea6: " + sequence.getResolution() + " PPQ");
            sender.sendMessage("- \u30c8\u30e9\u30c3\u30af\u6570: " + sequence.getTracks().length);
            for (int t = 0; t < sequence.getTracks().length; ++t) {
                Track track = sequence.getTracks()[t];
                sender.sendMessage("\n\u30c8\u30e9\u30c3\u30af " + t + " (\u30a4\u30d9\u30f3\u30c8\u6570: " + track.size() + "):");
                for (int i = 0; i < track.size(); ++i) {
                    MidiEvent event = track.get(i);
                    MidiMessage message = event.getMessage();
                    sender.sendMessage("  Tick: " + event.getTick() + ", Message: " + Import_midi.messageToString(message));
                }
            }
            return true;
        }
        catch (InvalidMidiDataException e) {
            sender.sendMessage("MIDI\u30c7\u30fc\u30bf\u304c\u7121\u52b9\u3067\u3059: " + e.getMessage());
        }
        catch (IOException e) {
            sender.sendMessage("\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc: " + e.getMessage());
        }
        catch (Exception e) {
            sender.sendMessage("\u4e88\u671f\u3057\u306a\u3044\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: " + e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    private static String messageToString(MidiMessage message) {
        if (message instanceof ShortMessage) {
            ShortMessage sm = (ShortMessage)message;
            String command = switch (sm.getCommand()) {
                case 144 -> "NOTE_ON";
                case 128 -> "NOTE_OFF";
                case 176 -> "CONTROL_CHANGE";
                case 192 -> "PROGRAM_CHANGE";
                default -> "\u30b3\u30de\u30f3\u30c9 " + sm.getCommand();
            };
            return command + " \u30c1\u30e3\u30f3\u30cd\u30eb=" + sm.getChannel() + " \u30c7\u30fc\u30bf1=" + sm.getData1() + " \u30c7\u30fc\u30bf2=" + sm.getData2();
        }
        if (message instanceof MetaMessage) {
            MetaMessage mm = (MetaMessage)message;
            return "META \u30bf\u30a4\u30d7=" + mm.getType() + " \u30c7\u30fc\u30bf\u9577=" + mm.getData().length;
        }
        return message.toString();
    }
}

