/*
 * Decompiled with CFR 0.152.
 */
package nl.robertvankammen.scoreboard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import nl.robertvankammen.scoreboard.LobbyBoard;
import nl.robertvankammen.scoreboard.ScoreboardEntityTypeInfo;
import nl.robertvankammen.scoreboard.ScoreboardInfo;
import org.apache.commons.lang3.ClassUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class SimpleScoreboard
extends JavaPlugin
implements Listener {
    private static final TreeMap<String, ScoreboardInfo> SCOREBOARD_INFO_MAP = new TreeMap();
    private static final HashMap<Player, String[]> playerSubCommand = new HashMap();
    private static final Set<String> IGNORE_PLAYER_NAMES = new HashSet<String>();
    private static final String COMMAND_STRING = "scb";
    private static final String COMMAND_SUB_CLEAR = "clear";
    private static final Integer TICKS_TO_MINUTES = 1200;
    private static final Integer TICKS_TO_HOURS = TICKS_TO_MINUTES * 60;
    private static final Integer CM_TO_M = 100;
    private static final Integer CM_TO_KM = CM_TO_M * 1000;
    private static final String CONFIG_PATH_IGNORE = "ignore.players";
    private static final String CONFIG_PATH_AMOUNT_OF_PLAYERS = "amountPlayers";
    private static final String CONFIG_PATH_REFRESH_TIME = "refreshtime";
    private static Integer playerAmount = 10;
    private static Integer refreshTime = 100;
    private int taskId;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.checkConfig();
        this.addStatistic();
        this.addKilled();
        this.addMine();
        this.addUse();
    }

    private void checkConfig() {
        FileConfiguration config = this.getConfig();
        if (config.getKeys(false).isEmpty()) {
            config.set(CONFIG_PATH_IGNORE, List.of("Ignore1"));
            config.set(CONFIG_PATH_AMOUNT_OF_PLAYERS, (Object)10);
            config.set(CONFIG_PATH_REFRESH_TIME, (Object)100);
            this.saveConfig();
        } else {
            IGNORE_PLAYER_NAMES.addAll((ArrayList)config.get(CONFIG_PATH_IGNORE));
            playerAmount = (Integer)config.get(CONFIG_PATH_AMOUNT_OF_PLAYERS);
            refreshTime = (Integer)config.get(CONFIG_PATH_REFRESH_TIME);
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ScoreboardInfo scoreboardInfo;
        if (args.length == 1) {
            return SCOREBOARD_INFO_MAP.keySet().stream().filter(s -> s.contains(args[0])).sorted(Comparator.naturalOrder()).toList();
        }
        if (args.length == 2 && (scoreboardInfo = SCOREBOARD_INFO_MAP.get(args[0])) != null && scoreboardInfo.getSubEntitys() != null && !scoreboardInfo.getSubEntitys().isEmpty()) {
            return scoreboardInfo.getSubEntitys().keySet().stream().filter(s -> s.contains(args[1])).sorted(Comparator.naturalOrder()).toList();
        }
        return Collections.emptyList();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (label.equalsIgnoreCase(COMMAND_STRING)) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.length > 0) {
                    playerSubCommand.put(player, args);
                    this.stop(player);
                    this.start(player);
                }
            } else {
                sender.sendMessage((Component)Component.text((String)"Sorry only player stats"));
            }
            return true;
        }
        return false;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        this.stop(playerQuitEvent.getPlayer());
    }

    private void addMine() {
        HashMap<String, ScoreboardEntityTypeInfo> mined = new HashMap<String, ScoreboardEntityTypeInfo>();
        Arrays.stream(Material.values()).filter(Material::isBlock).forEach(material -> {
            String name = material.getKey().getKey();
            mined.put(name, new ScoreboardEntityTypeInfo(name, (Material)material));
        });
        mined.put("ore_total", new ScoreboardEntityTypeInfo("Total ores", true, Arrays.asList(Material.COAL_ORE, Material.DIAMOND_ORE, Material.EMERALD_ORE, Material.GOLD_ORE, Material.IRON_ORE, Material.LAPIS_ORE, Material.REDSTONE_ORE, Material.COPPER_ORE, Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.DEEPSLATE_COPPER_ORE, Material.NETHER_GOLD_ORE, Material.NETHER_QUARTZ_ORE)));
        mined.put("log_total", new ScoreboardEntityTypeInfo("Total logs", true, Arrays.asList(Material.OAK_LOG, Material.DARK_OAK_LOG, Material.BIRCH_LOG, Material.ACACIA_LOG, Material.JUNGLE_LOG, Material.SPRUCE_LOG, Material.CRIMSON_STEM, Material.WARPED_STEM)));
        mined.put("planks_total", new ScoreboardEntityTypeInfo("Total planks", true, Arrays.asList(Material.OAK_PLANKS, Material.DARK_OAK_PLANKS, Material.BIRCH_PLANKS, Material.ACACIA_PLANKS, Material.JUNGLE_PLANKS, Material.SPRUCE_PLANKS, Material.CRIMSON_PLANKS, Material.WARPED_PLANKS)));
        mined.put("terracotta_total", new ScoreboardEntityTypeInfo("Total concrete", true, Arrays.asList(Material.TERRACOTTA, Material.WHITE_TERRACOTTA, Material.ORANGE_TERRACOTTA, Material.MAGENTA_TERRACOTTA, Material.LIGHT_BLUE_TERRACOTTA, Material.YELLOW_TERRACOTTA, Material.LIME_TERRACOTTA, Material.PINK_TERRACOTTA, Material.GRAY_TERRACOTTA, Material.LIGHT_GRAY_TERRACOTTA, Material.CYAN_TERRACOTTA, Material.PURPLE_TERRACOTTA, Material.BLUE_TERRACOTTA, Material.BROWN_TERRACOTTA, Material.GREEN_TERRACOTTA, Material.RED_TERRACOTTA, Material.BLACK_TERRACOTTA)));
        mined.put("concrete_total", new ScoreboardEntityTypeInfo("Total concrete", true, Arrays.asList(Material.WHITE_CONCRETE, Material.ORANGE_CONCRETE, Material.MAGENTA_CONCRETE, Material.LIGHT_BLUE_CONCRETE, Material.YELLOW_CONCRETE, Material.LIME_CONCRETE, Material.PINK_CONCRETE, Material.GRAY_CONCRETE, Material.LIGHT_GRAY_CONCRETE, Material.CYAN_CONCRETE, Material.PURPLE_CONCRETE, Material.BLUE_CONCRETE, Material.BROWN_CONCRETE, Material.GREEN_CONCRETE, Material.RED_CONCRETE, Material.BLACK_CONCRETE)));
        mined.put("glass_total", new ScoreboardEntityTypeInfo("Total glass", true, Arrays.asList(Material.GLASS, Material.WHITE_STAINED_GLASS, Material.ORANGE_STAINED_GLASS, Material.MAGENTA_STAINED_GLASS, Material.LIGHT_BLUE_STAINED_GLASS, Material.YELLOW_STAINED_GLASS, Material.LIME_STAINED_GLASS, Material.PINK_STAINED_GLASS, Material.GRAY_STAINED_GLASS, Material.LIGHT_GRAY_STAINED_GLASS, Material.CYAN_STAINED_GLASS, Material.PURPLE_STAINED_GLASS, Material.BLUE_STAINED_GLASS, Material.BROWN_STAINED_GLASS, Material.GREEN_STAINED_GLASS, Material.RED_STAINED_GLASS, Material.BLACK_STAINED_GLASS, Material.TINTED_GLASS)));
        SCOREBOARD_INFO_MAP.put("mined", new ScoreboardInfo("Mined ", Statistic.MINE_BLOCK, mined));
    }

    private void addUse() {
        HashMap<String, ScoreboardEntityTypeInfo> used = new HashMap<String, ScoreboardEntityTypeInfo>();
        Arrays.stream(Material.values()).filter(Material::isItem).forEach(material -> {
            String name = material.getKey().getKey();
            used.put(name, new ScoreboardEntityTypeInfo(name, (Material)material));
        });
        SCOREBOARD_INFO_MAP.put("used", new ScoreboardInfo("Used ", Statistic.USE_ITEM, used));
    }

    private void addKilled() {
        HashMap<String, ScoreboardEntityTypeInfo> entitys = new HashMap<String, ScoreboardEntityTypeInfo>();
        Arrays.stream(EntityType.values()).filter(entityType -> entityType != EntityType.UNKNOWN).filter(entityType -> ClassUtils.getAllInterfaces((Class)entityType.getEntityClass()).contains(Mob.class)).forEach(entityType -> {
            String name = entityType.getKey().getKey();
            entitys.put(name, new ScoreboardEntityTypeInfo(name, (EntityType)entityType));
        });
        SCOREBOARD_INFO_MAP.put("killed", new ScoreboardInfo("Killed ", Statistic.KILL_ENTITY, entitys));
        SCOREBOARD_INFO_MAP.put("killed_by", new ScoreboardInfo("Killed_by ", Statistic.ENTITY_KILLED_BY, entitys));
    }

    private void addStatistic() {
        SCOREBOARD_INFO_MAP.put(COMMAND_SUB_CLEAR, null);
        Arrays.stream(Statistic.values()).filter(statistic -> statistic.getType() == Statistic.Type.UNTYPED).filter(statistic -> !statistic.getKey().getKey().contains("_one_cm")).filter(statistic -> !statistic.getKey().getKey().contains("time")).filter(statistic -> !statistic.getKey().getKey().contains("play_one_minute")).forEach(statistic -> {
            String name = statistic.getKey().getKey();
            SCOREBOARD_INFO_MAP.put(name, new ScoreboardInfo(name, (Statistic)statistic));
        });
        this.fixTheDistanceAndTime();
        this.fixPlayIn();
    }

    private void fixPlayIn() {
        SCOREBOARD_INFO_MAP.put("played_in_ticks", new ScoreboardInfo("played_in_ticks", Statistic.PLAY_ONE_MINUTE));
        SCOREBOARD_INFO_MAP.put("played_in_minutes", new ScoreboardInfo("played_in_minutes", Statistic.PLAY_ONE_MINUTE, TICKS_TO_MINUTES));
        SCOREBOARD_INFO_MAP.put("played_in_hours", new ScoreboardInfo("played_in_hours", Statistic.PLAY_ONE_MINUTE, TICKS_TO_HOURS));
    }

    private void fixTime(Statistic statistic) {
        String key = statistic.getKey().getKey();
        SCOREBOARD_INFO_MAP.put(key + "_in_ticks", new ScoreboardInfo(key + "_in_ticks", statistic));
        SCOREBOARD_INFO_MAP.put(key + "_in_minutes", new ScoreboardInfo(key + "_in_minutes", statistic, TICKS_TO_MINUTES));
        SCOREBOARD_INFO_MAP.put(key + "_in_hours", new ScoreboardInfo(key + "_in_hours", statistic, TICKS_TO_HOURS));
    }

    private void fixDistance(Statistic statistic) {
        String key = statistic.getKey().getKey().replace("_one_cm", "");
        SCOREBOARD_INFO_MAP.put(key + "_in_cm", new ScoreboardInfo(key + "_in_cm", statistic));
        SCOREBOARD_INFO_MAP.put(key + "_in_meter", new ScoreboardInfo(key + "_in_meter", statistic, CM_TO_M));
        SCOREBOARD_INFO_MAP.put(key + "_in_km", new ScoreboardInfo(key + "_in_km", statistic, CM_TO_KM));
    }

    private void fixTheDistanceAndTime() {
        Arrays.stream(Statistic.values()).filter(statistic -> statistic.getType() == Statistic.Type.UNTYPED).filter(statistic -> statistic.getKey().getKey().contains("time")).forEach(this::fixTime);
        Arrays.stream(Statistic.values()).filter(statistic -> statistic.getType() == Statistic.Type.UNTYPED).filter(statistic -> statistic.getKey().getKey().contains("_one_cm")).forEach(this::fixDistance);
    }

    private void stop(Player player) {
        LobbyBoard lobbyBoard = new LobbyBoard(player.getUniqueId());
        if (lobbyBoard.hasID()) {
            lobbyBoard.stop();
        }
    }

    private void start(final Player player) {
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){
            final LobbyBoard board;
            {
                this.board = new LobbyBoard(player.getUniqueId());
            }

            @Override
            public void run() {
                if (!this.board.hasID()) {
                    this.board.setID(SimpleScoreboard.this.taskId);
                }
                SimpleScoreboard.this.setScoreBoard(player, playerSubCommand.get(player));
            }
        }, 0L, (long)refreshTime.intValue());
    }

    private void setScoreBoard(Player player, String ... name) {
        ScoreboardInfo scoreboardInfo = SCOREBOARD_INFO_MAP.get(name[0]);
        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
        Scoreboard playerScoreboard = scoreboardManager.getNewScoreboard();
        if (scoreboardInfo != null) {
            Statistic statistic;
            ScoreboardEntityTypeInfo scoreboardEntityTypeInfo = null;
            Object dislayname = scoreboardInfo.getDisplayname();
            if (name.length == 2) {
                scoreboardEntityTypeInfo = scoreboardInfo.getSubEntitys().get(name[1]);
                if (scoreboardEntityTypeInfo == null) {
                    player.setScoreboard(scoreboardManager.getMainScoreboard());
                    this.stop(player);
                    return;
                }
                dislayname = (String)dislayname + scoreboardEntityTypeInfo.getDisplayname();
            }
            if ((statistic = scoreboardInfo.getStatistic()).getType().equals((Object)Statistic.Type.UNTYPED) || name.length == 2) {
                Objective objective = playerScoreboard.registerNewObjective("Scoreboard", Criteria.DUMMY, Component.text((String)("<< " + (String)dislayname + " >>"), (TextColor)NamedTextColor.GREEN).decorate(TextDecoration.BOLD));
                AtomicInteger scoreCount = new AtomicInteger(playerAmount + 3);
                Score s1 = objective.getScore("Your score: " + ChatColor.YELLOW + this.calculateScore(this.getStatistic((OfflinePlayer)player, statistic, scoreboardEntityTypeInfo), scoreboardInfo));
                Score s2 = objective.getScore("");
                Score s3 = objective.getScore("Top " + playerAmount + " players");
                s1.setScore(scoreCount.getAndDecrement());
                s2.setScore(scoreCount.getAndDecrement());
                s3.setScore(scoreCount.getAndDecrement());
                this.getPlayerScore(statistic, scoreboardEntityTypeInfo).forEach(stringIntegerEntry -> {
                    Score sx = objective.getScore((String)stringIntegerEntry.getKey() + ": " + ChatColor.YELLOW + this.calculateScore(((Integer)stringIntegerEntry.getValue()).intValue(), scoreboardInfo));
                    sx.setScore(scoreCount.getAndDecrement());
                });
                objective.setDisplaySlot(DisplaySlot.SIDEBAR);
                player.setScoreboard(playerScoreboard);
            } else {
                this.stop(player);
            }
        } else {
            if (name[0].equalsIgnoreCase(COMMAND_SUB_CLEAR)) {
                player.setScoreboard(scoreboardManager.getMainScoreboard());
            }
            this.stop(player);
        }
    }

    private int getStatistic(OfflinePlayer player, Statistic statistic, ScoreboardEntityTypeInfo entityType) {
        if (entityType != null && entityType.getEntityType() != null) {
            return player.getStatistic(statistic, entityType.getEntityType());
        }
        if (entityType != null && entityType.getMaterial() != null) {
            return player.getStatistic(statistic, entityType.getMaterial());
        }
        if (entityType != null && entityType.isMerge()) {
            return entityType.getMaterials().stream().mapToInt(material -> player.getStatistic(statistic, material)).sum();
        }
        return player.getStatistic(statistic);
    }

    private long calculateScore(long begin, ScoreboardInfo scoreboardInfo) {
        int calculateFactor = scoreboardInfo.getCalculateFactor();
        if (calculateFactor > 0) {
            return begin / (long)scoreboardInfo.getCalculateFactor();
        }
        return begin;
    }

    private List<Map.Entry<String, Integer>> getPlayerScore(Statistic statistic, ScoreboardEntityTypeInfo entityType) {
        return Arrays.stream(Bukkit.getOfflinePlayers()).collect(Collectors.toMap(OfflinePlayer::getName, player -> this.getStatistic((OfflinePlayer)player, statistic, entityType))).entrySet().stream().filter(stringIntegerEntry -> !IGNORE_PLAYER_NAMES.contains(stringIntegerEntry.getKey())).sorted(Map.Entry.comparingByValue(Collections.reverseOrder())).limit(playerAmount.intValue()).collect(Collectors.toList());
    }
}

