/*
 * Decompiled with CFR 0.152.
 */
package nl.robertvankammen.scoreboard;

import java.util.HashMap;
import nl.robertvankammen.scoreboard.ScoreboardEntityTypeInfo;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Statistic;

public class ScoreboardInfo {
    private final String displayname;
    private final Statistic statistic;
    private int calculateFactor;
    private HashMap<String, ScoreboardEntityTypeInfo> subEntitys;

    public ScoreboardInfo(String displayname, Statistic statistic) {
        this.displayname = displayname;
        this.statistic = statistic;
    }

    public ScoreboardInfo(String displayname, Statistic statistic, int calculateFactor) {
        this(displayname, statistic);
        this.calculateFactor = calculateFactor;
    }

    public ScoreboardInfo(String displayname, Statistic statistic, HashMap<String, ScoreboardEntityTypeInfo> subEntitys) {
        this(displayname, statistic);
        this.subEntitys = subEntitys;
    }

    public String getDisplayname() {
        return StringUtils.capitalize((String)this.displayname.replace("_", " "));
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    public int getCalculateFactor() {
        return this.calculateFactor;
    }

    public HashMap<String, ScoreboardEntityTypeInfo> getSubEntitys() {
        if (this.subEntitys == null) {
            this.subEntitys = new HashMap();
        }
        return this.subEntitys;
    }
}

