/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.lib.semver;

import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.Nullable;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.jvm.JvmStatic;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.DefaultConstructorMarker;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.SourceDebugExtension;
import com.r4g3baby.simplescore.lib.kotlin.text.MatchResult;
import com.r4g3baby.simplescore.lib.kotlin.text.Regex;
import com.r4g3baby.simplescore.lib.kotlin.text.StringsKt;
import com.r4g3baby.simplescore.lib.kotlinx.serialization.KSerializer;
import com.r4g3baby.simplescore.lib.kotlinx.serialization.Serializable;
import com.r4g3baby.simplescore.lib.semver.SemVerSerializer;
import java.util.List;

@Serializable(with=SemVerSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001$B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0000J\u0006\u0010\u0014\u001a\u00020\u0000J\u0011\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\f\u0010\u001a\u001a\u00020\u0018*\u00020\u0007H\u0002J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J?\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010!\u001a\u00020\u00182\b\u0010\u0016\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006%"}, d2={"Lcom/r4g3baby/simplescore/lib/semver/SemVer;", "", "major", "", "minor", "patch", "preRelease", "", "buildMetadata", "<init>", "(IIILjava/lang/String;Ljava/lang/String;)V", "getMajor", "()I", "getMinor", "getPatch", "getPreRelease", "()Ljava/lang/String;", "getBuildMetadata", "nextMajor", "nextMinor", "nextPatch", "compareTo", "other", "isInitialDevelopmentPhase", "", "toString", "isNumeric", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "hashCode", "Companion", "semver"})
@SourceDebugExtension(value={"SMAP\nSemVer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemVer.kt\nnet/swiftzer/semver/SemVer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n1#2:205\n*E\n"})
public final class SemVer
implements Comparable<SemVer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;
    @Nullable
    private final String preRelease;
    @Nullable
    private final String buildMetadata;
    @NotNull
    private static final Regex NumericPattern = new Regex("^\\d+$");
    @NotNull
    private static final Regex PreReleasePattern = new Regex("^(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*$");
    @NotNull
    private static final Regex BuildMetadataPattern = new Regex("^[0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*$");
    @NotNull
    private static final Regex FullPattern = new Regex("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");

    public SemVer(int major, int minor, int patch, @Nullable String preRelease, @Nullable String buildMetadata) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.buildMetadata = buildMetadata;
        if (!(this.major >= 0)) {
            boolean $i$a$-require-SemVer$62 = false;
            String $i$a$-require-SemVer$62 = "Major version must be a positive number";
            throw new IllegalArgumentException($i$a$-require-SemVer$62.toString());
        }
        if (!(this.minor >= 0)) {
            boolean $i$a$-require-SemVer$72 = false;
            String $i$a$-require-SemVer$72 = "Minor version must be a positive number";
            throw new IllegalArgumentException($i$a$-require-SemVer$72.toString());
        }
        if (!(this.patch >= 0)) {
            boolean $i$a$-require-SemVer$82 = false;
            String $i$a$-require-SemVer$82 = "Patch version must be a positive number";
            throw new IllegalArgumentException($i$a$-require-SemVer$82.toString());
        }
        if (this.preRelease != null && !PreReleasePattern.matches(this.preRelease)) {
            boolean $i$a$-require-SemVer$92 = false;
            String $i$a$-require-SemVer$92 = "Pre-release version is not valid";
            throw new IllegalArgumentException($i$a$-require-SemVer$92.toString());
        }
        if (this.buildMetadata != null && !BuildMetadataPattern.matches(this.buildMetadata)) {
            boolean bl = false;
            String string = "Build metadata is not valid";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ SemVer(int n, int n2, int n3, String string, String string2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        if ((n4 & 8) != 0) {
            string = null;
        }
        if ((n4 & 0x10) != 0) {
            string2 = null;
        }
        this(n, n2, n3, string, string2);
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @Nullable
    public final String getPreRelease() {
        return this.preRelease;
    }

    @Nullable
    public final String getBuildMetadata() {
        return this.buildMetadata;
    }

    @NotNull
    public final SemVer nextMajor() {
        return new SemVer(this.major + 1, 0, 0, null, null, 30, null);
    }

    @NotNull
    public final SemVer nextMinor() {
        return new SemVer(this.major, this.minor + 1, 0, null, null, 28, null);
    }

    @NotNull
    public final SemVer nextPatch() {
        return new SemVer(this.major, this.minor, this.patch + 1, null, null, 24, null);
    }

    @Override
    public int compareTo(@NotNull SemVer other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (this.major > other.major) {
            return 1;
        }
        if (this.major < other.major) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        if (this.preRelease != null && other.preRelease == null) {
            return -1;
        }
        if (this.preRelease == null && other.preRelease != null) {
            return 1;
        }
        if (this.preRelease == null && other.preRelease == null) {
            return 0;
        }
        String string = this.preRelease;
        Intrinsics.checkNotNull(string);
        String[] stringArray = new String[]{"."};
        List parts = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
        String string2 = other.preRelease;
        Intrinsics.checkNotNull(string2);
        String[] stringArray2 = new String[]{"."};
        List otherParts = StringsKt.split$default((CharSequence)string2, stringArray2, false, 0, 6, null);
        int smallerSize = Math.min(parts.size(), otherParts.size());
        for (int i = 0; i < smallerSize; ++i) {
            int n;
            String otherPart;
            String part = (String)parts.get(i);
            if (Intrinsics.areEqual(part, otherPart = (String)otherParts.get(i))) continue;
            boolean partIsNumeric = this.isNumeric(part);
            boolean otherPartIsNumeric = this.isNumeric(otherPart);
            if (partIsNumeric && !otherPartIsNumeric) {
                n = -1;
            } else if (!partIsNumeric && otherPartIsNumeric) {
                n = 1;
            } else if (!partIsNumeric && !otherPartIsNumeric) {
                n = part.compareTo(otherPart);
            } else {
                int n2;
                try {
                    long partLong = Long.parseLong(part);
                    long otherPartLong = Long.parseLong(otherPart);
                    n2 = Intrinsics.compare(partLong, otherPartLong);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = part.compareTo(otherPart);
                }
                n = n2;
            }
            return n;
        }
        return parts.size() == smallerSize && otherParts.size() > smallerSize ? -1 : (parts.size() > smallerSize && otherParts.size() == smallerSize ? 1 : 0);
    }

    public final boolean isInitialDevelopmentPhase() {
        return this.major == 0;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u245.append(this.major);
        $this$toString_u24lambda_u245.append('.');
        $this$toString_u24lambda_u245.append(this.minor);
        $this$toString_u24lambda_u245.append('.');
        $this$toString_u24lambda_u245.append(this.patch);
        if (this.preRelease != null) {
            $this$toString_u24lambda_u245.append('-');
            $this$toString_u24lambda_u245.append(this.preRelease);
        }
        if (this.buildMetadata != null) {
            $this$toString_u24lambda_u245.append('+');
            $this$toString_u24lambda_u245.append(this.buildMetadata);
        }
        return stringBuilder.toString();
    }

    private final boolean isNumeric(String $this$isNumeric) {
        return NumericPattern.matches($this$isNumeric);
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @Nullable
    public final String component4() {
        return this.preRelease;
    }

    @Nullable
    public final String component5() {
        return this.buildMetadata;
    }

    @NotNull
    public final SemVer copy(int major, int minor, int patch, @Nullable String preRelease, @Nullable String buildMetadata) {
        return new SemVer(major, minor, patch, preRelease, buildMetadata);
    }

    public static /* synthetic */ SemVer copy$default(SemVer semVer, int n, int n2, int n3, String string, String string2, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = semVer.major;
        }
        if ((n4 & 2) != 0) {
            n2 = semVer.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = semVer.patch;
        }
        if ((n4 & 8) != 0) {
            string = semVer.preRelease;
        }
        if ((n4 & 0x10) != 0) {
            string2 = semVer.buildMetadata;
        }
        return semVer.copy(n, n2, n3, string, string2);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.major);
        result = result * 31 + Integer.hashCode(this.minor);
        result = result * 31 + Integer.hashCode(this.patch);
        result = result * 31 + (this.preRelease == null ? 0 : this.preRelease.hashCode());
        result = result * 31 + (this.buildMetadata == null ? 0 : this.buildMetadata.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SemVer)) {
            return false;
        }
        SemVer semVer = (SemVer)other;
        if (this.major != semVer.major) {
            return false;
        }
        if (this.minor != semVer.minor) {
            return false;
        }
        if (this.patch != semVer.patch) {
            return false;
        }
        if (!Intrinsics.areEqual(this.preRelease, semVer.preRelease)) {
            return false;
        }
        return Intrinsics.areEqual(this.buildMetadata, semVer.buildMetadata);
    }

    @JvmStatic
    @NotNull
    public static final SemVer parse(@NotNull String version) {
        return Companion.parse(version);
    }

    @JvmStatic
    @Nullable
    public static final SemVer parseOrNull(@NotNull String version) {
        return Companion.parseOrNull(version);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003\u00a8\u0006\u0011"}, d2={"Lcom/r4g3baby/simplescore/lib/semver/SemVer$Companion;", "", "<init>", "()V", "NumericPattern", "Lcom/r4g3baby/simplescore/lib/kotlin/text/Regex;", "PreReleasePattern", "BuildMetadataPattern", "FullPattern", "getFullPattern$annotations", "parse", "Lcom/r4g3baby/simplescore/lib/semver/SemVer;", "version", "", "parseOrNull", "serializer", "Lcom/r4g3baby/simplescore/lib/kotlinx/serialization/KSerializer;", "semver"})
    @SourceDebugExtension(value={"SMAP\nSemVer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemVer.kt\nnet/swiftzer/semver/SemVer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n1#2:205\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getFullPattern$annotations() {
        }

        @JvmStatic
        @NotNull
        public final SemVer parse(@NotNull String version) {
            CharSequence charSequence;
            CharSequence charSequence2;
            String string;
            int n;
            int n2;
            int n3;
            Intrinsics.checkNotNullParameter(version, "version");
            MatchResult matchResult = FullPattern.matchEntire(version);
            if (matchResult == null) {
                throw new IllegalArgumentException("Invalid version string [" + version + ']');
            }
            MatchResult.Destructured destructured = matchResult.getDestructured();
            String major = destructured.getMatch().getGroupValues().get(1);
            String minor = destructured.getMatch().getGroupValues().get(2);
            String patch = destructured.getMatch().getGroupValues().get(3);
            String preRelease = destructured.getMatch().getGroupValues().get(4);
            String buildMetadata = destructured.getMatch().getGroupValues().get(5);
            int n4 = Integer.parseInt(major);
            int n5 = Integer.parseInt(minor);
            int n6 = Integer.parseInt(patch);
            CharSequence charSequence3 = preRelease;
            if (charSequence3.length() == 0) {
                n3 = n6;
                n2 = n5;
                n = n4;
                boolean bl = false;
                string = null;
                n4 = n;
                n5 = n2;
                n6 = n3;
                charSequence2 = string;
            } else {
                charSequence2 = charSequence3;
            }
            String string2 = (String)charSequence2;
            charSequence3 = buildMetadata;
            if (charSequence3.length() == 0) {
                string = string2;
                n3 = n6;
                n2 = n5;
                n = n4;
                boolean bl = false;
                Object var14_14 = null;
                n4 = n;
                n5 = n2;
                n6 = n3;
                string2 = string;
                charSequence = var14_14;
            } else {
                charSequence = charSequence3;
            }
            String string3 = (String)charSequence;
            String string4 = string2;
            int n7 = n6;
            int n8 = n5;
            int n9 = n4;
            return new SemVer(n9, n8, n7, string4, string3);
        }

        @JvmStatic
        @Nullable
        public final SemVer parseOrNull(@NotNull String version) {
            SemVer semVer;
            Intrinsics.checkNotNullParameter(version, "version");
            try {
                semVer = this.parse(version);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                semVer = null;
            }
            return semVer;
        }

        @NotNull
        public final KSerializer<SemVer> serializer() {
            return SemVerSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

