/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.lib.kotlin.uuid;

import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import com.r4g3baby.simplescore.lib.kotlin.time.Clock;
import com.r4g3baby.simplescore.lib.kotlin.uuid.ExperimentalUuidApi;
import com.r4g3baby.simplescore.lib.kotlin.uuid.Uuid;
import com.r4g3baby.simplescore.lib.kotlin.uuid.UuidKt;
import java.util.concurrent.atomic.AtomicLong;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\bB\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0087\u0080\u0004R\u000f\u0010\u0004\u001a\u00020\u0005X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0006\u001a\u00020\u0005X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0007\u001a\u00020\bX\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\nX\u0082\u0084\b\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/r4g3baby/simplescore/lib/kotlin/uuid/UuidV7Generator;", "", "<init>", "()V", "TIMESTAMP_BIAS_BITS", "", "VERSION_MASK", "OVERFLOW_MASK", "", "timestampAndCounter", "Lcom/r4g3baby/simplescore/lib/kotlin/concurrent/atomics/AtomicLong;", "Ljava/util/concurrent/atomic/AtomicLong;", "generate", "Lcom/r4g3baby/simplescore/lib/kotlin/uuid/Uuid;", "clock", "Lcom/r4g3baby/simplescore/lib/kotlin/time/Clock;", "com.r4g3baby.simplescore.lib.kotlin-stdlib"})
final class UuidV7Generator {
    @NotNull
    public static final UuidV7Generator INSTANCE = new UuidV7Generator();
    private static final int TIMESTAMP_BIAS_BITS = 16;
    private static final int VERSION_MASK = 28672;
    private static final long OVERFLOW_MASK = 32768L;
    @NotNull
    private static final AtomicLong timestampAndCounter = new AtomicLong(0L);

    private UuidV7Generator() {
    }

    @ExperimentalUuidApi
    @NotNull
    public final Uuid generate(@NotNull Clock clock) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(clock, "clock");
        byte[] it = byArray = new byte[10];
        boolean bl = false;
        UuidKt.secureRandomBytes(it);
        byte[] randomBytes = byArray;
        int newCounter = (randomBytes[8] & 7) << 8 | randomBytes[9] & 0xFF | 0x7000;
        long newTimeStampAndCounter = 0L;
        while (true) {
            long currentTimeMillis;
            long previousTimeStampAndCounter;
            long previousTimeMillis;
            if ((previousTimeMillis = (previousTimeStampAndCounter = timestampAndCounter.get()) >>> 16) < (currentTimeMillis = clock.now().toEpochMilliseconds())) {
                newTimeStampAndCounter = currentTimeMillis << 16 | (long)newCounter;
                if (!timestampAndCounter.compareAndSet(previousTimeStampAndCounter, newTimeStampAndCounter)) continue;
                break;
            }
            newTimeStampAndCounter = previousTimeStampAndCounter + 1L;
            if ((newTimeStampAndCounter & 0x8000L) != 0L) {
                newTimeStampAndCounter = previousTimeMillis + 1L << 16 | (long)newCounter;
            }
            if (timestampAndCounter.compareAndSet(previousTimeStampAndCounter, newTimeStampAndCounter)) break;
        }
        randomBytes[0] = (byte)((byte)(randomBytes[0] & 0x3F) | 0xFFFFFF80);
        long variantAndRandB = UuidKt.getLongAt(randomBytes, 0);
        return Uuid.Companion.fromLongs(newTimeStampAndCounter, variantAndRandB);
    }
}

