/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.lib.kotlin.uuid;

import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.Nullable;
import com.r4g3baby.simplescore.lib.kotlin.Deprecated;
import com.r4g3baby.simplescore.lib.kotlin.DeprecatedSinceKotlin;
import com.r4g3baby.simplescore.lib.kotlin.ExperimentalUnsignedTypes;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.PublishedApi;
import com.r4g3baby.simplescore.lib.kotlin.ReplaceWith;
import com.r4g3baby.simplescore.lib.kotlin.SinceKotlin;
import com.r4g3baby.simplescore.lib.kotlin.UByteArray;
import com.r4g3baby.simplescore.lib.kotlin.ULong;
import com.r4g3baby.simplescore.lib.kotlin.comparisons.ComparisonsKt;
import com.r4g3baby.simplescore.lib.kotlin.internal.InlineOnly;
import com.r4g3baby.simplescore.lib.kotlin.jvm.functions.Function2;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.DefaultConstructorMarker;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import com.r4g3baby.simplescore.lib.kotlin.text.StringsKt;
import com.r4g3baby.simplescore.lib.kotlin.time.Clock;
import com.r4g3baby.simplescore.lib.kotlin.time.ExperimentalTime;
import com.r4g3baby.simplescore.lib.kotlin.time.Instant;
import com.r4g3baby.simplescore.lib.kotlin.uuid.ExperimentalUuidApi;
import com.r4g3baby.simplescore.lib.kotlin.uuid.UuidKt;
import com.r4g3baby.simplescore.lib.kotlin.uuid.UuidKt__UuidKt;
import com.r4g3baby.simplescore.lib.kotlin.uuid.UuidV7Generator;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Comparator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00000\u00012\u00060\u0002j\u0002`\u0003:\u00010B\u0019\bB\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ]\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u001026\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u0002H\u00100\u0012H\u0087\u0088\u0004\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u0015J]\u0010\u0016\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u001026\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u0002H\u00100\u0012H\u0087\u0088\u0004\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u0015J\n\u0010\u0018\u001a\u00020\u0019H\u0096\u0080\u0004J\n\u0010\u001a\u001a\u00020\u0019H\u0087\u0080\u0004J\n\u0010\u001b\u001a\u00020\u0019H\u0086\u0080\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u0086\u0080\u0004J\u0011\u0010\u001e\u001a\u00020\u001fH\u0087\u0080\u0004\u00a2\u0006\u0004\b \u0010!J\u0014\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0096\u0082\u0004J\u0012\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0000H\u0097\u0082\u0004J\n\u0010(\u001a\u00020'H\u0096\u0080\u0004J\n\u0010)\u001a\u00020%H\u0082\u0080\u0004J\u001b\u0010*\u001a\u00020+2\n\u0010,\u001a\u00060-j\u0002`.H\u0082\u0080\u0004\u00a2\u0006\u0002\u0010/R\u001d\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0084\b\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u00020\u00058\u0000X\u0081\u0084\b\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00061"}, d2={"Lcom/r4g3baby/simplescore/lib/kotlin/uuid/Uuid;", "", "Ljava/io/Serializable;", "Lcom/r4g3baby/simplescore/lib/kotlin/io/Serializable;", "mostSignificantBits", "", "leastSignificantBits", "<init>", "(JJ)V", "getMostSignificantBits$annotations", "()V", "getMostSignificantBits", "()J", "getLeastSignificantBits$annotations", "getLeastSignificantBits", "toLongs", "T", "action", "Lcom/r4g3baby/simplescore/lib/kotlin/Function2;", "Lcom/r4g3baby/simplescore/lib/kotlin/ParameterName;", "name", "(Lcom/r4g3baby/simplescore/lib/kotlin/jvm/functions/Function2;)Ljava/lang/Object;", "toULongs", "Lcom/r4g3baby/simplescore/lib/kotlin/ULong;", "toString", "", "toHexDashString", "toHexString", "toByteArray", "", "toUByteArray", "Lcom/r4g3baby/simplescore/lib/kotlin/UByteArray;", "toUByteArray-TcUX1vc", "()[B", "equals", "", "other", "", "compareTo", "", "hashCode", "writeReplace", "readObject", "", "input", "Ljava/io/ObjectInputStream;", "Lcom/r4g3baby/simplescore/lib/kotlin/internal/ReadObjectParameterType;", "(Ljava/io/ObjectInputStream;)V", "Companion", "com.r4g3baby.simplescore.lib.kotlin-stdlib"})
@SinceKotlin(version="2.0")
@ExperimentalUuidApi
public final class Uuid
implements Comparable<Uuid>,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long mostSignificantBits;
    private final long leastSignificantBits;
    @NotNull
    private static final Uuid NIL = new Uuid(0L, 0L);
    public static final int SIZE_BYTES = 16;
    public static final int SIZE_BITS = 128;

    private Uuid(long mostSignificantBits, long leastSignificantBits) {
        this.mostSignificantBits = mostSignificantBits;
        this.leastSignificantBits = leastSignificantBits;
    }

    public final long getMostSignificantBits() {
        return this.mostSignificantBits;
    }

    @PublishedApi
    public static /* synthetic */ void getMostSignificantBits$annotations() {
    }

    public final long getLeastSignificantBits() {
        return this.leastSignificantBits;
    }

    @PublishedApi
    public static /* synthetic */ void getLeastSignificantBits$annotations() {
    }

    @InlineOnly
    private final <T> T toLongs(Function2<? super Long, ? super Long, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        return action.invoke(this.getMostSignificantBits(), this.getLeastSignificantBits());
    }

    @InlineOnly
    private final <T> T toULongs(Function2<? super ULong, ? super ULong, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        return action.invoke(ULong.box-impl(ULong.constructor-impl(this.getMostSignificantBits())), ULong.box-impl(ULong.constructor-impl(this.getLeastSignificantBits())));
    }

    @NotNull
    public String toString() {
        return this.toHexDashString();
    }

    @SinceKotlin(version="2.1")
    @NotNull
    public final String toHexDashString() {
        byte[] bytes = new byte[36];
        UuidKt.formatBytesInto(this.mostSignificantBits, bytes, 0, 0, 4);
        bytes[8] = 45;
        UuidKt.formatBytesInto(this.mostSignificantBits, bytes, 9, 4, 6);
        bytes[13] = 45;
        UuidKt.formatBytesInto(this.mostSignificantBits, bytes, 14, 6, 8);
        bytes[18] = 45;
        UuidKt.formatBytesInto(this.leastSignificantBits, bytes, 19, 0, 2);
        bytes[23] = 45;
        UuidKt.formatBytesInto(this.leastSignificantBits, bytes, 24, 2, 8);
        return StringsKt.decodeToString(bytes);
    }

    @NotNull
    public final String toHexString() {
        byte[] bytes = new byte[32];
        UuidKt.formatBytesInto(this.mostSignificantBits, bytes, 0, 0, 8);
        UuidKt.formatBytesInto(this.leastSignificantBits, bytes, 16, 0, 8);
        return StringsKt.decodeToString(bytes);
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] bytes = new byte[16];
        UuidKt.setLongAt(bytes, 0, this.mostSignificantBits);
        UuidKt.setLongAt(bytes, 8, this.leastSignificantBits);
        return bytes;
    }

    @SinceKotlin(version="2.1")
    @ExperimentalUnsignedTypes
    @NotNull
    public final byte[] toUByteArray-TcUX1vc() {
        return UByteArray.constructor-impl(this.toByteArray());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Uuid)) {
            return false;
        }
        return this.mostSignificantBits == ((Uuid)other).mostSignificantBits && this.leastSignificantBits == ((Uuid)other).leastSignificantBits;
    }

    @Override
    @SinceKotlin(version="2.1")
    public int compareTo(@NotNull Uuid other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.mostSignificantBits != other.mostSignificantBits ? Long.compareUnsigned(ULong.constructor-impl(this.mostSignificantBits), ULong.constructor-impl(other.mostSignificantBits)) : Long.compareUnsigned(ULong.constructor-impl(this.leastSignificantBits), ULong.constructor-impl(other.leastSignificantBits));
    }

    public int hashCode() {
        return Long.hashCode(this.mostSignificantBits ^ this.leastSignificantBits);
    }

    private final Object writeReplace() {
        return UuidKt.serializedUuid(this);
    }

    private final void readObject(ObjectInputStream input) {
        throw new InvalidObjectException("Deserialization is supported via proxy only");
    }

    public /* synthetic */ Uuid(long mostSignificantBits, long leastSignificantBits, DefaultConstructorMarker $constructor_marker) {
        this(mostSignificantBits, leastSignificantBits);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\bB\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0086\u0080\u0004J!\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0010H\u0086\u0080\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0012\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\u0080\u0004J\u0019\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0087\u0080\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0012\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0086\u0080\u0004J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0087\u0080\u0004J\u0012\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u001dH\u0087\u0080\u0004J\u0014\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u001dH\u0087\u0080\u0004J\u0012\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u001dH\u0086\u0080\u0004J\u0014\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020\u001dH\u0087\u0080\u0004J\n\u0010%\u001a\u00020\u0005H\u0086\u0080\u0004J\n\u0010&\u001a\u00020\u0005H\u0087\u0080\u0004J\n\u0010'\u001a\u00020\u0005H\u0087\u0080\u0004J\u0012\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0087\u0080\u0004J\u0017\u0010'\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,H\u0080\u0080\u0004\u00a2\u0006\u0002\b-R\u0015\u0010\u0004\u001a\u00020\u0005X\u0086\u0084\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000f\u0010\b\u001a\u00020\tX\u0086\u00d4\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\n\u001a\u00020\tX\u0086\u00d4\b\u00a2\u0006\u0002\n\u0000R+\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\u00050/j\b\u0012\u0004\u0012\u00020\u0005`08FX\u0087\u0084\b\u00a2\u0006\f\u0012\u0004\b1\u0010\u0003\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Lcom/r4g3baby/simplescore/lib/kotlin/uuid/Uuid$Companion;", "", "<init>", "()V", "NIL", "Lcom/r4g3baby/simplescore/lib/kotlin/uuid/Uuid;", "getNIL", "()Lcom/r4g3baby/simplescore/lib/kotlin/uuid/Uuid;", "SIZE_BYTES", "", "SIZE_BITS", "fromLongs", "mostSignificantBits", "", "leastSignificantBits", "fromULongs", "Lcom/r4g3baby/simplescore/lib/kotlin/ULong;", "fromULongs-eb3DHEI", "(JJ)Lcom/r4g3baby/simplescore/lib/kotlin/uuid/Uuid;", "fromByteArray", "byteArray", "", "fromUByteArray", "ubyteArray", "Lcom/r4g3baby/simplescore/lib/kotlin/UByteArray;", "fromUByteArray-GBYM_sE", "([B)Lcom/r4g3baby/simplescore/lib/kotlin/uuid/Uuid;", "parse", "uuidString", "", "parseOrNull", "parseHexDash", "hexDashString", "parseHexDashOrNull", "parseHex", "hexString", "parseHexOrNull", "random", "generateV4", "generateV7", "generateV7NonMonotonicAt", "timestamp", "Lcom/r4g3baby/simplescore/lib/kotlin/time/Instant;", "clock", "Lcom/r4g3baby/simplescore/lib/kotlin/time/Clock;", "generateV7$kotlin_stdlib", "LEXICAL_ORDER", "Ljava/util/Comparator;", "Lcom/r4g3baby/simplescore/lib/kotlin/Comparator;", "getLEXICAL_ORDER$annotations", "getLEXICAL_ORDER", "()Ljava/util/Comparator;", "com.r4g3baby.simplescore.lib.kotlin-stdlib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Uuid getNIL() {
            return NIL;
        }

        @NotNull
        public final Uuid fromLongs(long mostSignificantBits, long leastSignificantBits) {
            return mostSignificantBits == 0L && leastSignificantBits == 0L ? this.getNIL() : new Uuid(mostSignificantBits, leastSignificantBits, null);
        }

        @NotNull
        public final Uuid fromULongs-eb3DHEI(long l, long l2) {
            return this.fromLongs(l, l2);
        }

        @NotNull
        public final Uuid fromByteArray(@NotNull byte[] byteArray) {
            Intrinsics.checkNotNullParameter(byteArray, "byteArray");
            if (!(byteArray.length == 16)) {
                boolean bl = false;
                String string = "Expected exactly 16 bytes, but was " + UuidKt__UuidKt.access$truncateForErrorMessage(byteArray, 32) + " of size " + byteArray.length;
                throw new IllegalArgumentException(string.toString());
            }
            return this.fromLongs(UuidKt.getLongAt(byteArray, 0), UuidKt.getLongAt(byteArray, 8));
        }

        @SinceKotlin(version="2.1")
        @ExperimentalUnsignedTypes
        @NotNull
        public final Uuid fromUByteArray-GBYM_sE(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter(byArray, "$v$c$kotlin-UByteArray$-ubyteArray$0");
            return this.fromByteArray(byArray);
        }

        @NotNull
        public final Uuid parse(@NotNull String uuidString) {
            Uuid uuid;
            Intrinsics.checkNotNullParameter(uuidString, "uuidString");
            switch (uuidString.length()) {
                case 36: {
                    uuid = UuidKt.uuidParseHexDash(uuidString);
                    break;
                }
                case 32: {
                    uuid = UuidKt.uuidParseHex(uuidString);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Expected either a 36-char string in the standard hex-and-dash UUID format or a 32-char hexadecimal string, but was \"" + UuidKt__UuidKt.access$truncateForErrorMessage(uuidString, 64) + "\" of length " + uuidString.length());
                }
            }
            return uuid;
        }

        @SinceKotlin(version="2.3")
        @Nullable
        public final Uuid parseOrNull(@NotNull String uuidString) {
            Uuid uuid;
            Intrinsics.checkNotNullParameter(uuidString, "uuidString");
            switch (uuidString.length()) {
                case 36: {
                    uuid = this.parseHexDashOrNull(uuidString);
                    break;
                }
                case 32: {
                    uuid = this.parseHexOrNull(uuidString);
                    break;
                }
                default: {
                    uuid = null;
                }
            }
            return uuid;
        }

        @SinceKotlin(version="2.1")
        @NotNull
        public final Uuid parseHexDash(@NotNull String hexDashString) {
            Intrinsics.checkNotNullParameter(hexDashString, "hexDashString");
            if (!(hexDashString.length() == 36)) {
                boolean bl = false;
                String string = "Expected a 36-char string in the standard hex-and-dash UUID format, but was \"" + UuidKt__UuidKt.access$truncateForErrorMessage(hexDashString, 64) + "\" of length " + hexDashString.length();
                throw new IllegalArgumentException(string.toString());
            }
            return UuidKt.uuidParseHexDash(hexDashString);
        }

        @SinceKotlin(version="2.3")
        @Nullable
        public final Uuid parseHexDashOrNull(@NotNull String hexDashString) {
            Intrinsics.checkNotNullParameter(hexDashString, "hexDashString");
            if (hexDashString.length() != 36) {
                return null;
            }
            return UuidKt.uuidParseHexDashOrNull(hexDashString);
        }

        @NotNull
        public final Uuid parseHex(@NotNull String hexString) {
            Intrinsics.checkNotNullParameter(hexString, "hexString");
            if (!(hexString.length() == 32)) {
                boolean bl = false;
                String string = "Expected a 32-char hexadecimal string, but was \"" + UuidKt__UuidKt.access$truncateForErrorMessage(hexString, 64) + "\" of length " + hexString.length();
                throw new IllegalArgumentException(string.toString());
            }
            return UuidKt.uuidParseHex(hexString);
        }

        @SinceKotlin(version="2.3")
        @Nullable
        public final Uuid parseHexOrNull(@NotNull String hexString) {
            Intrinsics.checkNotNullParameter(hexString, "hexString");
            if (hexString.length() != 32) {
                return null;
            }
            return UuidKt.uuidParseHexOrNull(hexString);
        }

        @NotNull
        public final Uuid random() {
            return this.generateV4();
        }

        @SinceKotlin(version="2.3")
        @NotNull
        public final Uuid generateV4() {
            return UuidKt.secureRandomUuid();
        }

        @SinceKotlin(version="2.3")
        @NotNull
        public final Uuid generateV7() {
            return this.generateV7$kotlin_stdlib(Clock.System.INSTANCE);
        }

        @SinceKotlin(version="2.3")
        @ExperimentalTime
        @NotNull
        public final Uuid generateV7NonMonotonicAt(@NotNull Instant timestamp) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter(timestamp, "timestamp");
            byte[] it = byArray = new byte[10];
            boolean bl = false;
            UuidKt.secureRandomBytes(it);
            byte[] randomBytes = byArray;
            int verAndRandA = (randomBytes[8] & 0xF | 0x70) << 8 | randomBytes[9] & 0xFF;
            long tsVerAndRandA = timestamp.toEpochMilliseconds() << 16 | (long)verAndRandA;
            randomBytes[0] = (byte)((byte)(randomBytes[0] & 0x3F) | 0xFFFFFF80);
            long varAndRandB = UuidKt.getLongAt(randomBytes, 0);
            return this.fromLongs(tsVerAndRandA, varAndRandB);
        }

        @NotNull
        public final Uuid generateV7$kotlin_stdlib(@NotNull Clock clock) {
            Intrinsics.checkNotNullParameter(clock, "clock");
            return UuidV7Generator.INSTANCE.generate(clock);
        }

        @NotNull
        public final Comparator<Uuid> getLEXICAL_ORDER() {
            return ComparisonsKt.naturalOrder();
        }

        @Deprecated(message="Use naturalOrder<Uuid>() instead", replaceWith=@ReplaceWith(expression="naturalOrder<Uuid>()", imports={"com.r4g3baby.simplescore.lib.kotlin.comparisons.naturalOrder"}))
        @DeprecatedSinceKotlin(warningSince="2.1")
        public static /* synthetic */ void getLEXICAL_ORDER$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

