/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.bukkit.scoreboard;

import com.r4g3baby.simplescore.api.scoreboard.Scoreboard;
import com.r4g3baby.simplescore.api.scoreboard.ScoreboardLine;
import com.r4g3baby.simplescore.api.scoreboard.ScoreboardScore;
import com.r4g3baby.simplescore.bukkit.BukkitManager;
import com.r4g3baby.simplescore.bukkit.protocol.ProtocolHandler;
import com.r4g3baby.simplescore.bukkit.protocol.model.ObjectiveScore;
import com.r4g3baby.simplescore.bukkit.protocol.model.ObjectiveTitle;
import com.r4g3baby.simplescore.bukkit.protocol.model.PlayerObjective;
import com.r4g3baby.simplescore.bukkit.scoreboard.data.Viewer;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.SourceDebugExtension;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.entity.Player;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/r4g3baby/simplescore/bukkit/scoreboard/ScoreboardTask;", "Ljava/lang/Runnable;", "manager", "Lcom/r4g3baby/simplescore/bukkit/BukkitManager;", "protocolHandler", "Lcom/r4g3baby/simplescore/bukkit/protocol/ProtocolHandler;", "<init>", "(Lcom/r4g3baby/simplescore/bukkit/BukkitManager;Lcom/r4g3baby/simplescore/bukkit/protocol/ProtocolHandler;)V", "emptyTitle", "Lcom/r4g3baby/simplescore/bukkit/protocol/model/ObjectiveTitle;", "run", "", "bukkit"})
@SourceDebugExtension(value={"SMAP\nScoreboardTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScoreboardTask.kt\ncom/r4g3baby/simplescore/bukkit/scoreboard/ScoreboardTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1915#2,2:58\n1915#2:60\n1915#2,2:61\n1916#2:63\n*S KotlinDebug\n*F\n+ 1 ScoreboardTask.kt\ncom/r4g3baby/simplescore/bukkit/scoreboard/ScoreboardTask\n*L\n15#1:58,2\n19#1:60\n42#1:61,2\n19#1:63\n*E\n"})
public final class ScoreboardTask
implements Runnable {
    @NotNull
    private final BukkitManager manager;
    @NotNull
    private final ProtocolHandler protocolHandler;
    @NotNull
    private final ObjectiveTitle emptyTitle;

    public ScoreboardTask(@NotNull BukkitManager manager, @NotNull ProtocolHandler protocolHandler) {
        Intrinsics.checkNotNullParameter(manager, "manager");
        Intrinsics.checkNotNullParameter(protocolHandler, "protocolHandler");
        this.manager = manager;
        this.protocolHandler = protocolHandler;
        this.emptyTitle = new ObjectiveTitle("-1", "");
    }

    @Override
    public void run() {
        Iterable $this$forEach$iv = this.manager.getScoreboards();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scoreboard scoreboard = (Scoreboard)element$iv;
            boolean bl = false;
            scoreboard.tick();
        }
        $this$forEach$iv = this.manager.getViewers();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObjectiveTitle objectiveTitle;
            Viewer viewer = (Viewer)element$iv;
            boolean bl = false;
            Player player = (Player)viewer.getReference().get();
            if (player == null || !player.isOnline()) continue;
            Scoreboard<Player> scoreboard = !viewer.isScoreboardHidden() ? viewer.getScoreboard() : null;
            PlayerObjective playerObjective = null;
            playerObjective = this.protocolHandler.getObjective(player);
            if (scoreboard == null || !scoreboard.canSee(player, this.manager.getVarReplacer())) {
                if (playerObjective == null) continue;
                this.protocolHandler.removeObjective(player);
                continue;
            }
            ScoreboardLine<Player> line = scoreboard.getTitle(player, this.manager.getVarReplacer());
            boolean bl2 = false;
            if (line == null) {
                objectiveTitle = this.emptyTitle;
            } else {
                ObjectiveTitle currentTitle;
                PlayerObjective playerObjective2 = playerObjective;
                ObjectiveTitle objectiveTitle2 = currentTitle = playerObjective2 != null ? playerObjective2.getTitle() : null;
                objectiveTitle = currentTitle == null || !Intrinsics.areEqual(currentTitle.getLineUID(), line.getUid()) || line.shouldRender() ? new ObjectiveTitle(line.getUid(), line.currentText(player, this.manager.getVarReplacer())) : currentTitle;
            }
            ObjectiveTitle title = objectiveTitle;
            if (playerObjective == null) {
                playerObjective = this.protocolHandler.createObjective(player, title);
            }
            Map scores = new LinkedHashMap();
            Iterable $this$forEach$iv2 = scoreboard.getScores(player, this.manager.getVarReplacer());
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ScoreboardLine<Player> line2;
                ScoreboardScore scoreboardScore = (ScoreboardScore)element$iv2;
                boolean bl3 = false;
                Integer n = scoreboardScore.getValueAsInteger(player, this.manager.getVarReplacer());
                if (n == null) {
                    continue;
                }
                int value = n;
                if (scoreboardScore.getLine(player, this.manager.getVarReplacer()) == null) continue;
                ObjectiveScore currentScore = playerObjective.getScores().get(scoreboardScore.getUid());
                String text = currentScore == null || !Intrinsics.areEqual(currentScore.getLineUID(), line2.getUid()) || line2.shouldRender() ? line2.currentText(player, this.manager.getVarReplacer()) : currentScore.getText();
                scores.put(scoreboardScore.getUid(), new ObjectiveScore(line2.getUid(), text, value, scoreboardScore.getHideNumber()));
            }
            this.protocolHandler.updateScoreboard(player, title, scores);
        }
    }
}

