/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.bukkit.protocol.util;

import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.Nullable;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.DefaultConstructorMarker;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.SourceDebugExtension;
import com.r4g3baby.simplescore.lib.kotlin.ranges.RangesKt;
import com.r4g3baby.simplescore.lib.kotlin.text.StringsKt;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000J\u0012\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0082\u0004J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0018\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0019H\u00d6\u0083\u0004J\n\u0010\u001a\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/r4g3baby/simplescore/bukkit/protocol/util/ServerVersion;", "", "major", "", "minor", "build", "<init>", "(III)V", "getMajor", "()I", "getMinor", "getBuild", "isBellow", "", "version", "atOrBellow", "isAbove", "atOrAbove", "compareTo", "other", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "toString", "", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nServerVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerVersion.kt\ncom/r4g3baby/simplescore/bukkit/protocol/util/ServerVersion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public final class ServerVersion
implements Comparable<ServerVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int build;
    @NotNull
    private static final ServerVersion currentVersion;
    @NotNull
    private static final ServerVersion bountifulUpdate;
    @NotNull
    private static final ServerVersion combatUpdate;
    @NotNull
    private static final ServerVersion frostburnUpdate;
    @NotNull
    private static final ServerVersion explorationUpdate;
    @NotNull
    private static final ServerVersion worldOfColorUpdate;
    @NotNull
    private static final ServerVersion aquaticUpdate;
    @NotNull
    private static final ServerVersion villageAndPillageUpdate;
    @NotNull
    private static final ServerVersion buzzyBeesUpdate;
    @NotNull
    private static final ServerVersion netherUpdate;
    @NotNull
    private static final ServerVersion cavesAndCliffsPartIUpdate;
    @NotNull
    private static final ServerVersion cavesAndCliffsPartIIUpdate;
    @NotNull
    private static final ServerVersion theWildUpdate;
    @NotNull
    private static final ServerVersion trailsAndTailsUpdate;
    @NotNull
    private static final ServerVersion trickyTrialsUpdate;
    private static final Pattern versionPattern;

    public ServerVersion(int major, int minor, int build) {
        this.major = major;
        this.minor = minor;
        this.build = build;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getBuild() {
        return this.build;
    }

    public final boolean isBellow(@NotNull ServerVersion version) {
        Intrinsics.checkNotNullParameter(version, "version");
        return this.compareTo(version) < 0;
    }

    public final boolean atOrBellow(@NotNull ServerVersion version) {
        Intrinsics.checkNotNullParameter(version, "version");
        return this.compareTo(version) <= 0;
    }

    public final boolean isAbove(@NotNull ServerVersion version) {
        Intrinsics.checkNotNullParameter(version, "version");
        return this.compareTo(version) > 0;
    }

    public final boolean atOrAbove(@NotNull ServerVersion version) {
        Intrinsics.checkNotNullParameter(version, "version");
        return this.compareTo(version) >= 0;
    }

    @Override
    public int compareTo(@NotNull ServerVersion other) {
        Integer n;
        Intrinsics.checkNotNullParameter(other, "other");
        Integer n2 = Intrinsics.compare(this.major, other.major);
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = n = it != 0 ? n2 : null;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl2 = false;
            return it;
        }
        n2 = Intrinsics.compare(this.minor, other.minor);
        it = ((Number)n2).intValue();
        boolean bl3 = false;
        Integer n4 = n = it != 0 ? n2 : null;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl4 = false;
            return it;
        }
        n2 = Intrinsics.compare(this.build, other.build);
        it = ((Number)n2).intValue();
        boolean bl5 = false;
        Integer n5 = n = it != 0 ? n2 : null;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl6 = false;
            return it;
        }
        return 0;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.build;
    }

    @NotNull
    public final ServerVersion copy(int major, int minor, int build) {
        return new ServerVersion(major, minor, build);
    }

    public static /* synthetic */ ServerVersion copy$default(ServerVersion serverVersion, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = serverVersion.major;
        }
        if ((n4 & 2) != 0) {
            n2 = serverVersion.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = serverVersion.build;
        }
        return serverVersion.copy(n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "ServerVersion(major=" + this.major + ", minor=" + this.minor + ", build=" + this.build + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.major);
        result = result * 31 + Integer.hashCode(this.minor);
        result = result * 31 + Integer.hashCode(this.build);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ServerVersion)) {
            return false;
        }
        ServerVersion serverVersion = (ServerVersion)other;
        if (this.major != serverVersion.major) {
            return false;
        }
        if (this.minor != serverVersion.minor) {
            return false;
        }
        return this.build == serverVersion.build;
    }

    static {
        bountifulUpdate = Companion.invoke("1.8");
        combatUpdate = Companion.invoke("1.9");
        frostburnUpdate = Companion.invoke("1.10");
        explorationUpdate = Companion.invoke("1.11");
        worldOfColorUpdate = Companion.invoke("1.12");
        aquaticUpdate = Companion.invoke("1.13");
        villageAndPillageUpdate = Companion.invoke("1.14");
        buzzyBeesUpdate = Companion.invoke("1.15");
        netherUpdate = Companion.invoke("1.16");
        cavesAndCliffsPartIUpdate = Companion.invoke("1.17");
        cavesAndCliffsPartIIUpdate = Companion.invoke("1.18");
        theWildUpdate = Companion.invoke("1.19");
        trailsAndTailsUpdate = Companion.invoke("1.20");
        trickyTrialsUpdate = Companion.invoke("1.21");
        versionPattern = Pattern.compile(".*\\(.*MC.\\s*([a-zA-Z0-9\\-.]+).*");
        String serverVersion = Bukkit.getVersion();
        Matcher version = versionPattern.matcher(serverVersion);
        if (!version.matches() || version.group(1) == null) {
            throw new IllegalStateException("Cannot parse version '" + serverVersion + '\'');
        }
        String string = version.group(1);
        Intrinsics.checkNotNullExpressionValue(string, "group(...)");
        currentVersion = Companion.invoke(string);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0086\u0002J\u000e\u0010*\u001a\u00020+2\u0006\u0010(\u001a\u00020\u0005J\u000e\u0010,\u001a\u00020+2\u0006\u0010(\u001a\u00020\u0005J\u000e\u0010-\u001a\u00020+2\u0006\u0010(\u001a\u00020\u0005J\u000e\u0010.\u001a\u00020+2\u0006\u0010(\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007R\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0007R\u0016\u0010$\u001a\n &*\u0004\u0018\u00010%0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/r4g3baby/simplescore/bukkit/protocol/util/ServerVersion$Companion;", "", "<init>", "()V", "currentVersion", "Lcom/r4g3baby/simplescore/bukkit/protocol/util/ServerVersion;", "getCurrentVersion", "()Lcom/r4g3baby/simplescore/bukkit/protocol/util/ServerVersion;", "bountifulUpdate", "getBountifulUpdate", "combatUpdate", "getCombatUpdate", "frostburnUpdate", "getFrostburnUpdate", "explorationUpdate", "getExplorationUpdate", "worldOfColorUpdate", "getWorldOfColorUpdate", "aquaticUpdate", "getAquaticUpdate", "villageAndPillageUpdate", "getVillageAndPillageUpdate", "buzzyBeesUpdate", "getBuzzyBeesUpdate", "netherUpdate", "getNetherUpdate", "cavesAndCliffsPartIUpdate", "getCavesAndCliffsPartIUpdate", "cavesAndCliffsPartIIUpdate", "getCavesAndCliffsPartIIUpdate", "theWildUpdate", "getTheWildUpdate", "trailsAndTailsUpdate", "getTrailsAndTailsUpdate", "trickyTrialsUpdate", "getTrickyTrialsUpdate", "versionPattern", "Ljava/util/regex/Pattern;", "com.r4g3baby.simplescore.lib.kotlin.jvm.PlatformType", "invoke", "version", "", "isBellow", "", "atOrBellow", "isAbove", "atOrAbove", "common"})
    @SourceDebugExtension(value={"SMAP\nServerVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerVersion.kt\ncom/r4g3baby/simplescore/bukkit/protocol/util/ServerVersion$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ServerVersion getCurrentVersion() {
            return currentVersion;
        }

        @NotNull
        public final ServerVersion getBountifulUpdate() {
            return bountifulUpdate;
        }

        @NotNull
        public final ServerVersion getCombatUpdate() {
            return combatUpdate;
        }

        @NotNull
        public final ServerVersion getFrostburnUpdate() {
            return frostburnUpdate;
        }

        @NotNull
        public final ServerVersion getExplorationUpdate() {
            return explorationUpdate;
        }

        @NotNull
        public final ServerVersion getWorldOfColorUpdate() {
            return worldOfColorUpdate;
        }

        @NotNull
        public final ServerVersion getAquaticUpdate() {
            return aquaticUpdate;
        }

        @NotNull
        public final ServerVersion getVillageAndPillageUpdate() {
            return villageAndPillageUpdate;
        }

        @NotNull
        public final ServerVersion getBuzzyBeesUpdate() {
            return buzzyBeesUpdate;
        }

        @NotNull
        public final ServerVersion getNetherUpdate() {
            return netherUpdate;
        }

        @NotNull
        public final ServerVersion getCavesAndCliffsPartIUpdate() {
            return cavesAndCliffsPartIUpdate;
        }

        @NotNull
        public final ServerVersion getCavesAndCliffsPartIIUpdate() {
            return cavesAndCliffsPartIIUpdate;
        }

        @NotNull
        public final ServerVersion getTheWildUpdate() {
            return theWildUpdate;
        }

        @NotNull
        public final ServerVersion getTrailsAndTailsUpdate() {
            return trailsAndTailsUpdate;
        }

        @NotNull
        public final ServerVersion getTrickyTrialsUpdate() {
            return trickyTrialsUpdate;
        }

        @NotNull
        public final ServerVersion invoke(@NotNull String version) {
            Intrinsics.checkNotNullParameter(version, "version");
            String[] stringArray = new String[]{"."};
            List elements = StringsKt.split$default((CharSequence)version, stringArray, false, 0, 6, null);
            if (!(!((Collection)elements).isEmpty())) {
                boolean $i$a$-check-ServerVersion$Companion$invoke$22 = false;
                String $i$a$-check-ServerVersion$Companion$invoke$22 = "Cannot parse version '" + version + '\'';
                throw new IllegalStateException($i$a$-check-ServerVersion$Companion$invoke$22.toString());
            }
            int[] numbers = new int[3];
            int n = RangesKt.coerceAtMost(numbers.length, elements.size());
            for (int i = 0; i < n; ++i) {
                numbers[i] = Integer.parseInt(((Object)StringsKt.trim((CharSequence)((String)elements.get(i)))).toString());
            }
            return new ServerVersion(numbers[0], numbers[1], numbers[2]);
        }

        public final boolean isBellow(@NotNull ServerVersion version) {
            Intrinsics.checkNotNullParameter(version, "version");
            return this.getCurrentVersion().isBellow(version);
        }

        public final boolean atOrBellow(@NotNull ServerVersion version) {
            Intrinsics.checkNotNullParameter(version, "version");
            return this.getCurrentVersion().atOrBellow(version);
        }

        public final boolean isAbove(@NotNull ServerVersion version) {
            Intrinsics.checkNotNullParameter(version, "version");
            return this.getCurrentVersion().isAbove(version);
        }

        public final boolean atOrAbove(@NotNull ServerVersion version) {
            Intrinsics.checkNotNullParameter(version, "version");
            return this.getCurrentVersion().atOrAbove(version);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

