/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.bukkit.protocol.modern;

import com.r4g3baby.simplescore.bukkit.protocol.ChannelInjector;
import com.r4g3baby.simplescore.bukkit.protocol.ProtocolHandler;
import com.r4g3baby.simplescore.bukkit.protocol.WrappedPacket;
import com.r4g3baby.simplescore.bukkit.protocol.model.ObjectiveScore;
import com.r4g3baby.simplescore.bukkit.protocol.model.ObjectiveTitle;
import com.r4g3baby.simplescore.bukkit.protocol.model.PlayerObjective;
import com.r4g3baby.simplescore.bukkit.protocol.modern.chat.WrappedChatComponent;
import com.r4g3baby.simplescore.bukkit.protocol.modern.chat.numbers.WrappedNumberFormat;
import com.r4g3baby.simplescore.bukkit.protocol.modern.packet.WrappedDisplayObjective;
import com.r4g3baby.simplescore.bukkit.protocol.modern.packet.WrappedResetScore;
import com.r4g3baby.simplescore.bukkit.protocol.modern.packet.WrappedUpdateObjective;
import com.r4g3baby.simplescore.bukkit.protocol.modern.packet.WrappedUpdateScore;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.Nullable;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.collections.MapsKt;
import com.r4g3baby.simplescore.lib.kotlin.jvm.functions.Function1;
import com.r4g3baby.simplescore.lib.kotlin.jvm.functions.Function2;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.SourceDebugExtension;
import io.netty.channel.Channel;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/r4g3baby/simplescore/bukkit/protocol/modern/ModernProtocolHandler;", "Lcom/r4g3baby/simplescore/bukkit/protocol/ProtocolHandler;", "<init>", "()V", "createObjective", "Lcom/r4g3baby/simplescore/bukkit/protocol/model/PlayerObjective;", "player", "Lorg/bukkit/entity/Player;", "title", "Lcom/r4g3baby/simplescore/bukkit/protocol/model/ObjectiveTitle;", "removeObjective", "updateScoreboard", "", "scores", "", "", "Lcom/r4g3baby/simplescore/bukkit/protocol/model/ObjectiveScore;", "modern"})
@SourceDebugExtension(value={"SMAP\nModernProtocolHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModernProtocolHandler.kt\ncom/r4g3baby/simplescore/bukkit/protocol/modern/ModernProtocolHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,83:1\n221#2,2:84\n221#2,2:86\n*S KotlinDebug\n*F\n+ 1 ModernProtocolHandler.kt\ncom/r4g3baby/simplescore/bukkit/protocol/modern/ModernProtocolHandler\n*L\n55#1:84,2\n73#1:86,2\n*E\n"})
public final class ModernProtocolHandler
extends ProtocolHandler {
    @Override
    @NotNull
    public PlayerObjective createObjective(@NotNull Player player, @NotNull ObjectiveTitle title) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(title, "title");
        PlayerObjective playerObjective = this.getPlayerObjectives().computeIfAbsent(player.getUniqueId(), arg_0 -> ModernProtocolHandler.createObjective$lambda$1(arg_0 -> ModernProtocolHandler.createObjective$lambda$0(player, title, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(playerObjective, "computeIfAbsent(...)");
        return playerObjective;
    }

    @Override
    @Nullable
    public PlayerObjective removeObjective(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        PlayerObjective playerObjective = this.getPlayerObjectives().remove(player.getUniqueId());
        if (playerObjective == null) {
            return null;
        }
        PlayerObjective playerObjective2 = playerObjective;
        Channel $this$removeObjective_u24lambda_u240 = ChannelInjector.Companion.getChannel(player);
        boolean bl = false;
        ChannelInjector.Companion.writePacket($this$removeObjective_u24lambda_u240, new WrappedUpdateObjective(this.getObjectiveName(player), WrappedUpdateObjective.Mode.REMOVE, null, null, null, 28, null));
        return playerObjective2;
    }

    @Override
    public void updateScoreboard(@NotNull Player player, @NotNull ObjectiveTitle title, @NotNull Map<String, ObjectiveScore> scores) {
        String identifier;
        Map.Entry<String, ObjectiveScore> entry;
        Map.Entry<String, ObjectiveScore> element$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(scores, "scores");
        PlayerObjective playerObjective = this.getPlayerObjectives().get(player.getUniqueId());
        if (playerObjective == null) {
            return;
        }
        PlayerObjective playerObjective2 = playerObjective;
        Channel $this$updateScoreboard_u24lambda_u240 = ChannelInjector.Companion.getChannel(player);
        boolean bl = false;
        String objectiveName = this.getObjectiveName(player);
        if (!Intrinsics.areEqual(playerObjective2.getTitle(), title)) {
            ChannelInjector.Companion.writePacket($this$updateScoreboard_u24lambda_u240, new WrappedUpdateObjective(objectiveName, WrappedUpdateObjective.Mode.UPDATE, WrappedUpdateObjective.Type.INTEGER, WrappedChatComponent.Companion.fromString(title.getText()), null, 16, null));
        }
        Map objectiveScores = new LinkedHashMap();
        Map<String, ObjectiveScore> $this$forEach$iv = scores;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ObjectiveScore>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl2 = false;
            identifier = entry.getKey();
            ObjectiveScore newScore = entry.getValue();
            String text = newScore.component2();
            int value = newScore.component3();
            boolean hideNumber = newScore.component4();
            ObjectiveScore currentScore = playerObjective2.getScores().get(identifier);
            if (Intrinsics.areEqual(currentScore, newScore)) {
                objectiveScores.put(identifier, currentScore);
                continue;
            }
            WrappedChatComponent displayName = WrappedChatComponent.Companion.fromString(text);
            WrappedNumberFormat numberFormat = hideNumber ? WrappedNumberFormat.Companion.getBlankFormat() : null;
            ChannelInjector.Companion.writePacket($this$updateScoreboard_u24lambda_u240, new WrappedUpdateScore(identifier, objectiveName, WrappedUpdateScore.Action.UPDATE, value, displayName, numberFormat));
            objectiveScores.put(identifier, newScore);
        }
        $this$forEach$iv = playerObjective2.getScores();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl3 = false;
            identifier = entry.getKey();
            if (scores.containsKey(identifier)) continue;
            ChannelInjector.Companion.writePacket($this$updateScoreboard_u24lambda_u240, new WrappedResetScore(identifier, objectiveName));
        }
        this.getPlayerObjectives().computeIfPresent(player.getUniqueId(), (arg_0, arg_1) -> ModernProtocolHandler.updateScoreboard$lambda$0$3((arg_0, arg_1) -> ModernProtocolHandler.updateScoreboard$lambda$0$2(title, objectiveScores, arg_0, arg_1), arg_0, arg_1));
    }

    private static final PlayerObjective createObjective$lambda$0(Player $player, ObjectiveTitle $title, ModernProtocolHandler this$0, UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Channel $this$createObjective_u24lambda_u240_u240 = ChannelInjector.Companion.getChannel($player);
        boolean bl = false;
        String objectiveName = this$0.getObjectiveName($player);
        WrappedPacket[] wrappedPacketArray = new WrappedPacket[]{new WrappedUpdateObjective(objectiveName, WrappedUpdateObjective.Mode.CREATE, WrappedUpdateObjective.Type.INTEGER, WrappedChatComponent.Companion.fromString($title.getText()), null, 16, null), new WrappedDisplayObjective(objectiveName, WrappedDisplayObjective.Position.SIDEBAR)};
        ChannelInjector.Companion.writePackets($this$createObjective_u24lambda_u240_u240, wrappedPacketArray);
        return new PlayerObjective($title, MapsKt.emptyMap());
    }

    private static final PlayerObjective createObjective$lambda$1(Function1 $tmp0, Object p0) {
        return (PlayerObjective)$tmp0.invoke(p0);
    }

    private static final PlayerObjective updateScoreboard$lambda$0$2(ObjectiveTitle $title, Map $objectiveScores, UUID uUID, PlayerObjective playerObjective) {
        Intrinsics.checkNotNullParameter(uUID, "<unused var>");
        Intrinsics.checkNotNullParameter(playerObjective, "<unused var>");
        return new PlayerObjective($title, $objectiveScores);
    }

    private static final PlayerObjective updateScoreboard$lambda$0$3(Function2 $tmp0, Object p0, Object p1) {
        return (PlayerObjective)$tmp0.invoke(p0, p1);
    }
}

