/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.bukkit.protocol;

import com.r4g3baby.simplescore.bukkit.protocol.model.ObjectiveScore;
import com.r4g3baby.simplescore.bukkit.protocol.model.ObjectiveTitle;
import com.r4g3baby.simplescore.bukkit.protocol.model.PlayerObjective;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.Nullable;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.Pair;
import com.r4g3baby.simplescore.lib.kotlin.TuplesKt;
import com.r4g3baby.simplescore.lib.kotlin.collections.ArraysKt;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import com.r4g3baby.simplescore.lib.kotlin.ranges.IntRange;
import com.r4g3baby.simplescore.lib.kotlin.text.StringsKt;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH&J,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H&J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0004J&\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0004R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/r4g3baby/simplescore/bukkit/protocol/ProtocolHandler;", "", "<init>", "()V", "playerObjectives", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcom/r4g3baby/simplescore/bukkit/protocol/model/PlayerObjective;", "getPlayerObjectives", "()Ljava/util/concurrent/ConcurrentHashMap;", "getObjective", "player", "Lorg/bukkit/entity/Player;", "createObjective", "title", "Lcom/r4g3baby/simplescore/bukkit/protocol/model/ObjectiveTitle;", "removeObjective", "updateScoreboard", "", "scores", "", "", "Lcom/r4g3baby/simplescore/bukkit/protocol/model/ObjectiveScore;", "getObjectiveName", "identifierToName", "identifier", "splitScoreLine", "Lcom/r4g3baby/simplescore/lib/kotlin/Pair;", "text", "cutSuffix", "", "common"})
public abstract class ProtocolHandler {
    @NotNull
    private final ConcurrentHashMap<UUID, PlayerObjective> playerObjectives = new ConcurrentHashMap();

    @NotNull
    protected final ConcurrentHashMap<UUID, PlayerObjective> getPlayerObjectives() {
        return this.playerObjectives;
    }

    @Nullable
    public final PlayerObjective getObjective(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return this.playerObjectives.get(player.getUniqueId());
    }

    @NotNull
    public abstract PlayerObjective createObjective(@NotNull Player var1, @NotNull ObjectiveTitle var2);

    @Nullable
    public abstract PlayerObjective removeObjective(@NotNull Player var1);

    public abstract void updateScoreboard(@NotNull Player var1, @NotNull ObjectiveTitle var2, @NotNull Map<String, ObjectiveScore> var3);

    @NotNull
    protected final String getObjectiveName(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        StringBuilder stringBuilder = new StringBuilder().append("sb");
        String string = player.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return StringsKt.substring(stringBuilder.append(StringsKt.replace$default(string, "-", "", false, 4, null)).toString(), new IntRange(0, 15));
    }

    @NotNull
    protected final String identifierToName(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        char[] cArray = identifier.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        return ArraysKt.joinToString$default(cArray, (CharSequence)"\u00a7", (CharSequence)"\u00a7", (CharSequence)"\u00a7r", 0, null, null, 56, null);
    }

    @NotNull
    protected final Pair<String, String> splitScoreLine(@NotNull String text, boolean cutSuffix) {
        Intrinsics.checkNotNullParameter(text, "text");
        int index = 16;
        if (text.length() > index) {
            int newIndex;
            if (((CharSequence)text).charAt(index - 1) == '\u00a7') {
                --index;
            }
            for (int i = 1; i < 7 && ((CharSequence)text).charAt(newIndex = index - i * 2) == '\u00a7'; ++i) {
                if (((CharSequence)text).charAt(newIndex + 1) != 'x') continue;
                index = newIndex;
                break;
            }
            String prefix = StringsKt.take(text, index);
            String lastColors = ChatColor.getLastColors((String)prefix);
            StringBuilder stringBuilder = new StringBuilder().append(lastColors);
            String string = text.substring(index);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String suffix = stringBuilder.append(string).toString();
            if (cutSuffix && suffix.length() > 16) {
                suffix = StringsKt.take(suffix, 16);
            }
            return TuplesKt.to(prefix, suffix);
        }
        return TuplesKt.to(text, "");
    }

    public static /* synthetic */ Pair splitScoreLine$default(ProtocolHandler protocolHandler, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: splitScoreLine");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return protocolHandler.splitScoreLine(string, bl);
    }
}

