/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.bukkit.protocol;

import com.r4g3baby.simplescore.bukkit.protocol.WrappedPacket;
import com.r4g3baby.simplescore.bukkit.protocol.util.Utils;
import com.r4g3baby.simplescore.core.util.Reflection;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.DefaultConstructorMarker;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import io.netty.channel.Channel;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.entity.Player;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/r4g3baby/simplescore/bukkit/protocol/ChannelInjector;", "", "<init>", "()V", "Companion", "common"})
public final class ChannelInjector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Reflection.MethodInvoker getPlayerHandle;
    @NotNull
    private static final Reflection.FieldAccessor connectionField;
    @NotNull
    private static final Reflection.FieldAccessor networkManagerField;
    @NotNull
    private static final Reflection.FieldAccessor channelField;
    @NotNull
    private static final Map<Player, Channel> channelLookup;

    static {
        Map map = Collections.synchronizedMap(new WeakHashMap());
        Intrinsics.checkNotNullExpressionValue(map, "synchronizedMap(...)");
        channelLookup = map;
        try {
            Class<?> craftPlayer = Reflection.INSTANCE.getClass(Utils.INSTANCE.getOBC() + ".entity.CraftPlayer");
            String[] stringArray = new String[]{"net.minecraft.server.level.ServerPlayer", "net.minecraft.server.level.EntityPlayer", Utils.INSTANCE.getNMS() + ".EntityPlayer"};
            Class<?> entityPlayer = Reflection.INSTANCE.findClass(stringArray);
            String[] stringArray2 = new String[]{"net.minecraft.server.network.ServerGamePacketListenerImpl", "net.minecraft.server.network.PlayerConnection", Utils.INSTANCE.getNMS() + ".PlayerConnection"};
            Class<?> playerConnection = Reflection.INSTANCE.findClass(stringArray2);
            String[] stringArray3 = new String[]{"net.minecraft.network.Connection", "net.minecraft.network.NetworkManager", Utils.INSTANCE.getNMS() + ".NetworkManager"};
            Class<?> networkManager = Reflection.INSTANCE.findClass(stringArray3);
            getPlayerHandle = Reflection.getMethodByName$default(Reflection.INSTANCE, craftPlayer, "getHandle", null, 4, null);
            connectionField = Reflection.getField$default(Reflection.INSTANCE, entityPlayer, playerConnection, 0, null, 12, null);
            networkManagerField = Reflection.getField$default(Reflection.INSTANCE, playerConnection, networkManager, 0, null, 12, null);
            channelField = Reflection.getField$default(Reflection.INSTANCE, networkManager, Channel.class, 0, null, 12, null);
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\fJ\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J#\u0010\u0014\u001a\u00020\u0011*\u00020\r2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0016\"\u00020\u0013\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/r4g3baby/simplescore/bukkit/protocol/ChannelInjector$Companion;", "", "<init>", "()V", "getPlayerHandle", "Lcom/r4g3baby/simplescore/core/util/Reflection$MethodInvoker;", "connectionField", "Lcom/r4g3baby/simplescore/core/util/Reflection$FieldAccessor;", "networkManagerField", "channelField", "channelLookup", "", "Lorg/bukkit/entity/Player;", "Lio/netty/channel/Channel;", "getChannel", "player", "writePacket", "", "packet", "Lcom/r4g3baby/simplescore/bukkit/protocol/WrappedPacket;", "writePackets", "packets", "", "(Lio/netty/channel/Channel;[Lcom/r4g3baby/simplescore/bukkit/protocol/WrappedPacket;)V", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Channel getChannel(@NotNull Player player) {
            Intrinsics.checkNotNullParameter(player, "player");
            Channel channel = (Channel)channelLookup.get(player);
            if (channel == null || !channel.isOpen()) {
                Object connection = connectionField.get(getPlayerHandle.invoke(player, new Object[0]));
                Object networkManager = networkManagerField.get(connection);
                Object object = channelField.get(networkManager);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.netty.channel.Channel");
                channel = (Channel)object;
                channelLookup.put(player, channel);
            }
            return channel;
        }

        public final void writePacket(@NotNull Channel $this$writePacket, @NotNull WrappedPacket packet) {
            Intrinsics.checkNotNullParameter($this$writePacket, "<this>");
            Intrinsics.checkNotNullParameter(packet, "packet");
            WrappedPacket[] wrappedPacketArray = new WrappedPacket[]{packet};
            this.writePackets($this$writePacket, wrappedPacketArray);
        }

        public final void writePackets(@NotNull Channel $this$writePackets, WrappedPacket ... packets) {
            Intrinsics.checkNotNullParameter($this$writePackets, "<this>");
            Intrinsics.checkNotNullParameter(packets, "packets");
            for (WrappedPacket packet : packets) {
                $this$writePackets.writeAndFlush(packet.getHandle());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

