/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.fahare.shadow.cloud.permission;

import dev.qixils.fahare.shadow.cloud.keys.CloudKey;
import dev.qixils.fahare.shadow.cloud.permission.PredicatePermission;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL, consumers={"dev.qixils.fahare.shadow.cloud.*"})
final class WrappingPredicatePermission<C>
implements PredicatePermission<C> {
    private final CloudKey<Void> key;
    private final Predicate<C> predicate;

    WrappingPredicatePermission(@NonNull CloudKey<Void> key, @NonNull Predicate<C> predicate) {
        this.key = key;
        this.predicate = predicate;
    }

    @Override
    public boolean hasPermission(C sender) {
        return this.predicate.test(sender);
    }

    @Override
    public @NonNull CloudKey<Void> getKey() {
        return this.key;
    }

    @Override
    public String toString() {
        return this.key.getName();
    }
}

