/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.fahare.shadow.cloud.paper.argument;

import dev.qixils.fahare.shadow.cloud.ArgumentDescription;
import dev.qixils.fahare.shadow.cloud.arguments.CommandArgument;
import dev.qixils.fahare.shadow.cloud.arguments.parser.ArgumentParseResult;
import dev.qixils.fahare.shadow.cloud.arguments.parser.ArgumentParser;
import dev.qixils.fahare.shadow.cloud.bukkit.internal.CraftBukkitReflection;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.WorldArgument;
import dev.qixils.fahare.shadow.cloud.context.CommandContext;
import dev.qixils.fahare.shadow.cloud.exceptions.parsing.NoInputProvidedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class KeyedWorldArgument<C>
extends CommandArgument<C, World> {
    KeyedWorldArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new Parser(), defaultValue, World.class, suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull KeyedWorldArgument<C> of(@NonNull String name) {
        return ((Builder)KeyedWorldArgument.builder(name).asRequired()).build();
    }

    public static <C> @NonNull KeyedWorldArgument<C> optional(@NonNull String name) {
        return ((Builder)KeyedWorldArgument.builder(name).asOptional()).build();
    }

    public static <C> @NonNull KeyedWorldArgument<C> optional(@NonNull String name, @NonNull NamespacedKey defaultValue) {
        return KeyedWorldArgument.builder(name).asOptionalWithDefault(defaultValue).build();
    }

    public static final class Parser<C>
    implements ArgumentParser<C, World> {
        private final ArgumentParser<C, World> parser;

        public Parser() {
            Class<World> keyed = CraftBukkitReflection.findClass("org.bukkit.Keyed");
            this.parser = keyed != null && keyed.isAssignableFrom(World.class) ? null : new WorldArgument.WorldParser();
        }

        @Override
        public @NonNull ArgumentParseResult<@NonNull World> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(Parser.class, commandContext));
            }
            if (this.parser != null) {
                return this.parser.parse(commandContext, inputQueue);
            }
            NamespacedKey key = NamespacedKey.fromString((String)input);
            if (key == null) {
                return ArgumentParseResult.failure(new WorldArgument.WorldParseException(input, commandContext));
            }
            World world = Bukkit.getWorld((NamespacedKey)key);
            if (world == null) {
                return ArgumentParseResult.failure(new WorldArgument.WorldParseException(input, commandContext));
            }
            inputQueue.remove();
            return ArgumentParseResult.success(world);
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            if (this.parser != null) {
                return this.parser.suggestions(commandContext, input);
            }
            List worlds = Bukkit.getWorlds();
            ArrayList<String> completions = new ArrayList<String>(worlds.size() * 2);
            for (World world : worlds) {
                NamespacedKey key = world.getKey();
                if (!input.isEmpty() && key.getNamespace().equals("minecraft")) {
                    completions.add(key.getKey());
                }
                completions.add(key.getNamespace() + ':' + key.getKey());
            }
            return completions;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.TypedBuilder<C, World, Builder<C>> {
        private Builder(@NonNull String name) {
            super(World.class, name);
        }

        public @NonNull Builder<C> asOptionalWithDefault(@NonNull NamespacedKey defaultValue) {
            return (Builder)this.asOptionalWithDefault(defaultValue.toString());
        }

        public @NonNull KeyedWorldArgument<C> build() {
            return new KeyedWorldArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

