/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.fahare.shadow.cloud.minecraft.extras;

import dev.qixils.fahare.shadow.cloud.CommandManager;
import dev.qixils.fahare.shadow.cloud.exceptions.ArgumentParseException;
import dev.qixils.fahare.shadow.cloud.exceptions.CommandExecutionException;
import dev.qixils.fahare.shadow.cloud.exceptions.InvalidCommandSenderException;
import dev.qixils.fahare.shadow.cloud.exceptions.InvalidSyntaxException;
import dev.qixils.fahare.shadow.cloud.exceptions.NoPermissionException;
import dev.qixils.fahare.shadow.cloud.minecraft.extras.ComponentHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.util.ComponentMessageThrowable;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MinecraftExceptionHandler<C> {
    private static final Component NULL = Component.text((String)"null");
    public static final Function<Exception, Component> DEFAULT_INVALID_SYNTAX_FUNCTION = e -> Component.text((String)"Invalid command syntax. Correct command syntax is: ", (TextColor)NamedTextColor.RED).append(ComponentHelper.highlight((Component)Component.text((String)String.format("/%s", ((InvalidSyntaxException)e).getCorrectSyntax()), (TextColor)NamedTextColor.GRAY), (TextColor)NamedTextColor.WHITE));
    public static final Function<Exception, Component> DEFAULT_INVALID_SENDER_FUNCTION = e -> Component.text((String)"Invalid command sender. You must be of type ", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)((InvalidCommandSenderException)e).getRequiredSender().getSimpleName(), (TextColor)NamedTextColor.GRAY));
    public static final Function<Exception, Component> DEFAULT_NO_PERMISSION_FUNCTION = e -> Component.text((String)"I'm sorry, but you do not have permission to perform this command. \nPlease contact the server administrators if you believe that this is in error.", (TextColor)NamedTextColor.RED);
    public static final Function<Exception, Component> DEFAULT_ARGUMENT_PARSING_FUNCTION = e -> Component.text((String)"Invalid command argument: ", (TextColor)NamedTextColor.RED).append(MinecraftExceptionHandler.getMessage(e.getCause()).colorIfAbsent((TextColor)NamedTextColor.GRAY));
    public static final Function<Exception, Component> DEFAULT_COMMAND_EXECUTION_FUNCTION = e -> {
        Throwable cause = e.getCause();
        cause.printStackTrace();
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter(writer));
        String stackTrace = writer.toString().replaceAll("\t", "    ");
        HoverEvent hover = HoverEvent.showText((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(MinecraftExceptionHandler.getMessage(cause))).append((Component)Component.newline())).append((Component)Component.text((String)stackTrace))).append((Component)Component.newline())).append((Component)Component.text((String)"    Click to copy", (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC})));
        ClickEvent click = ClickEvent.copyToClipboard((String)stackTrace);
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("An internal error occurred while attempting to perform this command.").color((TextColor)NamedTextColor.RED)).hoverEvent((HoverEventSource)hover)).clickEvent(click)).build();
    };
    private final Map<ExceptionType, BiFunction<C, Exception, Component>> componentBuilders = new HashMap<ExceptionType, BiFunction<C, Exception, Component>>();
    private Function<Component, Component> decorator = Function.identity();

    public @NonNull MinecraftExceptionHandler<C> withInvalidSyntaxHandler() {
        return this.withHandler(ExceptionType.INVALID_SYNTAX, DEFAULT_INVALID_SYNTAX_FUNCTION);
    }

    public @NonNull MinecraftExceptionHandler<C> withInvalidSenderHandler() {
        return this.withHandler(ExceptionType.INVALID_SENDER, DEFAULT_INVALID_SENDER_FUNCTION);
    }

    public @NonNull MinecraftExceptionHandler<C> withNoPermissionHandler() {
        return this.withHandler(ExceptionType.NO_PERMISSION, DEFAULT_NO_PERMISSION_FUNCTION);
    }

    public @NonNull MinecraftExceptionHandler<C> withArgumentParsingHandler() {
        return this.withHandler(ExceptionType.ARGUMENT_PARSING, DEFAULT_ARGUMENT_PARSING_FUNCTION);
    }

    public @NonNull MinecraftExceptionHandler<C> withCommandExecutionHandler() {
        return this.withHandler(ExceptionType.COMMAND_EXECUTION, DEFAULT_COMMAND_EXECUTION_FUNCTION);
    }

    public @NonNull MinecraftExceptionHandler<C> withDefaultHandlers() {
        return this.withArgumentParsingHandler().withInvalidSenderHandler().withInvalidSyntaxHandler().withNoPermissionHandler().withCommandExecutionHandler();
    }

    public @NonNull MinecraftExceptionHandler<C> withHandler(@NonNull ExceptionType type, @NonNull Function<@NonNull Exception, @NonNull Component> componentBuilder) {
        return this.withHandler(type, (C sender, Exception exception) -> (Component)componentBuilder.apply((Exception)exception));
    }

    public @NonNull MinecraftExceptionHandler<C> withHandler(@NonNull ExceptionType type, @NonNull BiFunction<@NonNull C, @NonNull Exception, @NonNull Component> componentBuilder) {
        this.componentBuilders.put(type, componentBuilder);
        return this;
    }

    public @NonNull MinecraftExceptionHandler<C> withDecorator(@NonNull Function<@NonNull Component, @NonNull Component> decorator) {
        this.decorator = decorator;
        return this;
    }

    public void apply(@NonNull CommandManager<C> manager, @NonNull Function<@NonNull C, @NonNull Audience> audienceMapper) {
        if (this.componentBuilders.containsKey((Object)ExceptionType.INVALID_SYNTAX)) {
            manager.registerExceptionHandler(InvalidSyntaxException.class, (c, e) -> ((Audience)audienceMapper.apply(c)).sendMessage(Identity.nil(), this.decorator.apply(this.componentBuilders.get((Object)ExceptionType.INVALID_SYNTAX).apply((C)c, (Exception)e))));
        }
        if (this.componentBuilders.containsKey((Object)ExceptionType.INVALID_SENDER)) {
            manager.registerExceptionHandler(InvalidCommandSenderException.class, (c, e) -> ((Audience)audienceMapper.apply(c)).sendMessage(Identity.nil(), this.decorator.apply(this.componentBuilders.get((Object)ExceptionType.INVALID_SENDER).apply((C)c, (Exception)e))));
        }
        if (this.componentBuilders.containsKey((Object)ExceptionType.NO_PERMISSION)) {
            manager.registerExceptionHandler(NoPermissionException.class, (c, e) -> ((Audience)audienceMapper.apply(c)).sendMessage(Identity.nil(), this.decorator.apply(this.componentBuilders.get((Object)ExceptionType.NO_PERMISSION).apply((C)c, (Exception)e))));
        }
        if (this.componentBuilders.containsKey((Object)ExceptionType.ARGUMENT_PARSING)) {
            manager.registerExceptionHandler(ArgumentParseException.class, (c, e) -> ((Audience)audienceMapper.apply(c)).sendMessage(Identity.nil(), this.decorator.apply(this.componentBuilders.get((Object)ExceptionType.ARGUMENT_PARSING).apply((C)c, (Exception)e))));
        }
        if (this.componentBuilders.containsKey((Object)ExceptionType.COMMAND_EXECUTION)) {
            manager.registerExceptionHandler(CommandExecutionException.class, (c, e) -> ((Audience)audienceMapper.apply(c)).sendMessage(Identity.nil(), this.decorator.apply(this.componentBuilders.get((Object)ExceptionType.COMMAND_EXECUTION).apply((C)c, (Exception)e))));
        }
    }

    private static Component getMessage(Throwable throwable) {
        Component msg = ComponentMessageThrowable.getOrConvertMessage((Throwable)throwable);
        return msg == null ? NULL : msg;
    }

    public static enum ExceptionType {
        INVALID_SYNTAX,
        INVALID_SENDER,
        NO_PERMISSION,
        ARGUMENT_PARSING,
        COMMAND_EXECUTION;

    }
}

