/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.fahare.shadow.cloud.keys;

import dev.qixils.fahare.shadow.cloud.keys.CloudKey;
import io.leangen.geantyref.TypeToken;
import java.util.Objects;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE, since="1.4.0")
public final class SimpleCloudKey<@NonNull T>
implements CloudKey<T> {
    private final String name;
    private final TypeToken<T> type;

    private SimpleCloudKey(@NonNull String name, @NonNull TypeToken<T> type) {
        this.name = name;
        this.type = type;
    }

    public static <T> CloudKey<T> of(@NonNull String name, @NonNull TypeToken<T> type) {
        return new SimpleCloudKey<T>(name, type);
    }

    public static @NonNull CloudKey<Void> of(@NonNull String name) {
        return new SimpleCloudKey<Void>(name, TypeToken.get(Void.TYPE));
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull TypeToken<T> getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleCloudKey key = (SimpleCloudKey)o;
        return this.name.equals(key.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }
}

