/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.fahare.shadow.cloud.execution;

import dev.qixils.fahare.shadow.cloud.Command;
import dev.qixils.fahare.shadow.cloud.CommandTree;
import dev.qixils.fahare.shadow.cloud.context.CommandContext;
import dev.qixils.fahare.shadow.cloud.exceptions.CommandExecutionException;
import dev.qixils.fahare.shadow.cloud.execution.CommandResult;
import dev.qixils.fahare.shadow.cloud.services.State;
import dev.qixils.fahare.shadow.cloud.types.tuples.Pair;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE)
public abstract class CommandExecutionCoordinator<C> {
    private final CommandTree<C> commandTree;

    protected CommandExecutionCoordinator(@NonNull CommandTree<C> commandTree) {
        this.commandTree = commandTree;
    }

    public static <C> @NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> simpleCoordinator() {
        return x$0 -> new SimpleCoordinator((CommandTree)x$0);
    }

    public abstract @NonNull CompletableFuture<CommandResult<C>> coordinateExecution(@NonNull CommandContext<C> var1, @NonNull Queue<@NonNull String> var2);

    protected @NonNull CommandTree<C> getCommandTree() {
        return this.commandTree;
    }

    @API(status=API.Status.INTERNAL, consumers={"dev.qixils.fahare.shadow.cloud.*"})
    public static final class SimpleCoordinator<C>
    extends CommandExecutionCoordinator<C> {
        private SimpleCoordinator(@NonNull CommandTree<C> commandTree) {
            super(commandTree);
        }

        @Override
        public @NonNull CompletableFuture<CommandResult<C>> coordinateExecution(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> input) {
            CompletableFuture<CommandResult<C>> completableFuture;
            block10: {
                completableFuture = new CompletableFuture<CommandResult<C>>();
                try {
                    @NonNull Pair<@Nullable Command<C>, @Nullable Exception> pair = this.getCommandTree().parse(commandContext, input);
                    if (pair.getSecond() != null) {
                        completableFuture.completeExceptionally(pair.getSecond());
                        break block10;
                    }
                    Command command = Objects.requireNonNull(pair.getFirst());
                    if (this.getCommandTree().getCommandManager().postprocessContext(commandContext, command) == State.ACCEPTED) {
                        try {
                            command.getCommandExecutionHandler().executeFuture(commandContext).get();
                        }
                        catch (ExecutionException exception) {
                            Throwable cause = exception.getCause();
                            if (cause instanceof CommandExecutionException) {
                                completableFuture.completeExceptionally(cause);
                            } else {
                                completableFuture.completeExceptionally(new CommandExecutionException(cause, commandContext));
                            }
                        }
                        catch (CommandExecutionException exception) {
                            completableFuture.completeExceptionally(exception);
                        }
                        catch (Exception exception) {
                            completableFuture.completeExceptionally(new CommandExecutionException(exception, commandContext));
                        }
                    }
                    completableFuture.complete(new CommandResult<C>(commandContext));
                }
                catch (Exception e) {
                    completableFuture.completeExceptionally(e);
                }
            }
            return completableFuture;
        }
    }
}

