/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.fahare.shadow.cloud.exceptions;

import dev.qixils.fahare.shadow.cloud.Command;
import dev.qixils.fahare.shadow.cloud.arguments.CommandArgument;
import dev.qixils.fahare.shadow.cloud.exceptions.CommandParseException;
import java.util.List;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE)
public final class InvalidCommandSenderException
extends CommandParseException {
    private static final long serialVersionUID = 7372142477529875598L;
    private final Class<?> requiredSender;
    private final Command<?> command;

    @API(status=API.Status.INTERNAL, consumers={"dev.qixils.fahare.shadow.cloud.*"})
    public InvalidCommandSenderException(@NonNull Object commandSender, @NonNull Class<?> requiredSender, @NonNull List<@NonNull CommandArgument<?, ?>> currentChain) {
        this(commandSender, requiredSender, currentChain, null);
    }

    @API(status=API.Status.INTERNAL, consumers={"dev.qixils.fahare.shadow.cloud.*"}, since="1.4.0")
    public InvalidCommandSenderException(@NonNull Object commandSender, @NonNull Class<?> requiredSender, @NonNull List<@NonNull CommandArgument<?, ?>> currentChain, @Nullable Command<?> command) {
        super(commandSender, currentChain);
        this.requiredSender = requiredSender;
        this.command = command;
    }

    public @NonNull Class<?> getRequiredSender() {
        return this.requiredSender;
    }

    @Override
    public String getMessage() {
        return String.format("%s is not allowed to execute that command. Must be of type %s", this.getCommandSender().getClass().getSimpleName(), this.requiredSender.getSimpleName());
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public @Nullable Command<?> getCommand() {
        return this.command;
    }
}

