/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.fahare.shadow.cloud.bukkit.parsers;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import dev.qixils.fahare.shadow.cloud.ArgumentDescription;
import dev.qixils.fahare.shadow.cloud.arguments.CommandArgument;
import dev.qixils.fahare.shadow.cloud.arguments.parser.ArgumentParseResult;
import dev.qixils.fahare.shadow.cloud.arguments.parser.ArgumentParser;
import dev.qixils.fahare.shadow.cloud.brigadier.argument.WrappedBrigadierParser;
import dev.qixils.fahare.shadow.cloud.bukkit.BukkitCommandManager;
import dev.qixils.fahare.shadow.cloud.bukkit.data.ItemStackPredicate;
import dev.qixils.fahare.shadow.cloud.bukkit.internal.CommandBuildContextSupplier;
import dev.qixils.fahare.shadow.cloud.bukkit.internal.CraftBukkitReflection;
import dev.qixils.fahare.shadow.cloud.bukkit.internal.MinecraftArgumentTypes;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ItemStackPredicateArgument<C>
extends CommandArgument<C, ItemStackPredicate> {
    private ItemStackPredicateArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull dev.qixils.fahare.shadow.cloud.context.CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new Parser(), defaultValue, ItemStackPredicate.class, suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull ItemStackPredicateArgument<C> of(@NonNull String name) {
        return ItemStackPredicateArgument.builder(name).build();
    }

    public static <C> @NonNull ItemStackPredicateArgument<C> optional(@NonNull String name) {
        return ((Builder)ItemStackPredicateArgument.builder(name).asOptional()).build();
    }

    private static <C> void registerParserSupplier(@NonNull BukkitCommandManager<C> commandManager) {
        commandManager.parserRegistry().registerParserSupplier(TypeToken.get(ItemStackPredicate.class), params -> new Parser());
    }

    public static final class Parser<C>
    implements ArgumentParser<C, ItemStackPredicate> {
        private static final Class<?> CRAFT_ITEM_STACK_CLASS = CraftBukkitReflection.needOBCClass("inventory.CraftItemStack");
        private static final Class<?> ARGUMENT_ITEM_PREDICATE_CLASS = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"item_predicate"));
        private static final Class<?> ARGUMENT_ITEM_PREDICATE_RESULT_CLASS = CraftBukkitReflection.firstNonNullOrNull(CraftBukkitReflection.findNMSClass("ArgumentItemPredicate$b"), CraftBukkitReflection.findMCClass("commands.arguments.item.ArgumentItemPredicate$b"), CraftBukkitReflection.findMCClass("commands.arguments.item.ItemPredicateArgument$Result"));
        private static final @Nullable Method CREATE_PREDICATE_METHOD = ARGUMENT_ITEM_PREDICATE_RESULT_CLASS == null ? null : CraftBukkitReflection.firstNonNullOrNull(CraftBukkitReflection.findMethod(ARGUMENT_ITEM_PREDICATE_RESULT_CLASS, "create", CommandContext.class), CraftBukkitReflection.findMethod(ARGUMENT_ITEM_PREDICATE_RESULT_CLASS, "a", CommandContext.class));
        private static final Method AS_NMS_COPY_METHOD = CraftBukkitReflection.needMethod(CRAFT_ITEM_STACK_CLASS, "asNMSCopy", ItemStack.class);
        private final ArgumentParser<C, ItemStackPredicate> parser;

        public Parser() {
            try {
                this.parser = this.createParser();
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to initialize ItemPredicate parser.", ex);
            }
        }

        private ArgumentParser<C, ItemStackPredicate> createParser() throws ReflectiveOperationException {
            Constructor<?> ctr = ARGUMENT_ITEM_PREDICATE_CLASS.getDeclaredConstructors()[0];
            ArgumentType inst = ctr.getParameterCount() == 0 ? (ArgumentType)ctr.newInstance(new Object[0]) : (ArgumentType)ctr.newInstance(CommandBuildContextSupplier.commandBuildContext());
            return new WrappedBrigadierParser(inst).map((ctx, result) -> {
                if (result instanceof Predicate) {
                    return ArgumentParseResult.success(new ItemStackPredicateImpl((Predicate)result));
                }
                Object commandSourceStack = ctx.get("_cloud_brigadier_native_sender");
                CommandContext<Object> dummy = Parser.createDummyContext(ctx, commandSourceStack);
                Objects.requireNonNull(CREATE_PREDICATE_METHOD, "ItemPredicateArgument$Result#create");
                try {
                    Predicate predicate = (Predicate)CREATE_PREDICATE_METHOD.invoke(result, dummy);
                    return ArgumentParseResult.success(new ItemStackPredicateImpl(predicate));
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }

        private static <C> @NonNull CommandContext<Object> createDummyContext(@NonNull dev.qixils.fahare.shadow.cloud.context.CommandContext<C> ctx, @NonNull Object commandSourceStack) {
            return new CommandContext(commandSourceStack, ctx.getRawInputJoined(), Collections.emptyMap(), null, null, Collections.emptyList(), StringRange.at((int)0), null, null, false);
        }

        @Override
        public @NonNull ArgumentParseResult<@NonNull ItemStackPredicate> parse(@NonNull dev.qixils.fahare.shadow.cloud.context.CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            return this.parser.parse(commandContext, inputQueue);
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull dev.qixils.fahare.shadow.cloud.context.CommandContext<C> commandContext, @NonNull String input) {
            return this.parser.suggestions(commandContext, input);
        }

        private static final class ItemStackPredicateImpl
        implements ItemStackPredicate {
            private final Predicate<Object> predicate;

            ItemStackPredicateImpl(@NonNull Predicate<Object> predicate) {
                this.predicate = predicate;
            }

            @Override
            public boolean test(@NonNull ItemStack itemStack) {
                try {
                    return this.predicate.test(AS_NMS_COPY_METHOD.invoke(null, itemStack));
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public static final class Builder<C>
    extends CommandArgument.TypedBuilder<C, ItemStackPredicate, Builder<C>> {
        private Builder(@NonNull String name) {
            super(ItemStackPredicate.class, name);
        }

        public @NonNull ItemStackPredicateArgument<C> build() {
            return new ItemStackPredicateArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

