/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.fahare.shadow.cloud.bukkit.parsers;

import com.mojang.brigadier.arguments.ArgumentType;
import dev.qixils.fahare.shadow.cloud.ArgumentDescription;
import dev.qixils.fahare.shadow.cloud.arguments.CommandArgument;
import dev.qixils.fahare.shadow.cloud.arguments.parser.ArgumentParseResult;
import dev.qixils.fahare.shadow.cloud.arguments.parser.ArgumentParser;
import dev.qixils.fahare.shadow.cloud.brigadier.argument.WrappedBrigadierParser;
import dev.qixils.fahare.shadow.cloud.bukkit.BukkitCommandManager;
import dev.qixils.fahare.shadow.cloud.bukkit.data.BlockPredicate;
import dev.qixils.fahare.shadow.cloud.bukkit.internal.CommandBuildContextSupplier;
import dev.qixils.fahare.shadow.cloud.bukkit.internal.CraftBukkitReflection;
import dev.qixils.fahare.shadow.cloud.bukkit.internal.MinecraftArgumentTypes;
import dev.qixils.fahare.shadow.cloud.bukkit.internal.RegistryReflection;
import dev.qixils.fahare.shadow.cloud.context.CommandContext;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BlockPredicateArgument<C>
extends CommandArgument<C, BlockPredicate> {
    private BlockPredicateArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new Parser(), defaultValue, BlockPredicate.class, suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull BlockPredicateArgument<C> of(@NonNull String name) {
        return BlockPredicateArgument.builder(name).build();
    }

    public static <C> @NonNull BlockPredicateArgument<C> optional(@NonNull String name) {
        return ((Builder)BlockPredicateArgument.builder(name).asOptional()).build();
    }

    private static <C> void registerParserSupplier(@NonNull BukkitCommandManager<C> commandManager) {
        commandManager.parserRegistry().registerParserSupplier(TypeToken.get(BlockPredicate.class), params -> new Parser());
    }

    public static final class Parser<C>
    implements ArgumentParser<C, BlockPredicate> {
        private static final Class<?> TAG_CONTAINER_CLASS;
        private static final Class<?> CRAFT_WORLD_CLASS;
        private static final Class<?> MINECRAFT_SERVER_CLASS;
        private static final Class<?> COMMAND_LISTENER_WRAPPER_CLASS;
        private static final Class<?> ARGUMENT_BLOCK_PREDICATE_CLASS;
        private static final Class<?> ARGUMENT_BLOCK_PREDICATE_RESULT_CLASS;
        private static final Class<?> SHAPE_DETECTOR_BLOCK_CLASS;
        private static final Class<?> LEVEL_READER_CLASS;
        private static final Class<?> BLOCK_POSITION_CLASS;
        private static final Constructor<?> BLOCK_POSITION_CTR;
        private static final Constructor<?> SHAPE_DETECTOR_BLOCK_CTR;
        private static final Method GET_HANDLE_METHOD;
        private static final @Nullable Method CREATE_PREDICATE_METHOD;
        private static final Method GET_SERVER_METHOD;
        private static final @Nullable Method GET_TAG_REGISTRY_METHOD;
        private final ArgumentParser<C, BlockPredicate> parser;

        public Parser() {
            try {
                this.parser = this.createParser();
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to initialize BlockPredicate parser.", ex);
            }
        }

        private ArgumentParser<C, BlockPredicate> createParser() throws ReflectiveOperationException {
            Constructor<?> ctr = ARGUMENT_BLOCK_PREDICATE_CLASS.getDeclaredConstructors()[0];
            ArgumentType inst = ctr.getParameterCount() == 0 ? (ArgumentType)ctr.newInstance(new Object[0]) : (ArgumentType)ctr.newInstance(CommandBuildContextSupplier.commandBuildContext());
            return new WrappedBrigadierParser(inst).map((ctx, result) -> {
                if (result instanceof Predicate) {
                    return ArgumentParseResult.success(new BlockPredicateImpl((Predicate)result));
                }
                Object commandSourceStack = ctx.get("_cloud_brigadier_native_sender");
                try {
                    Object server = GET_SERVER_METHOD.invoke(commandSourceStack, new Object[0]);
                    Object obj = GET_TAG_REGISTRY_METHOD != null ? GET_TAG_REGISTRY_METHOD.invoke(server, new Object[0]) : RegistryReflection.registryByName("block");
                    Objects.requireNonNull(CREATE_PREDICATE_METHOD, "create on BlockPredicateArgument$Result");
                    Predicate predicate = (Predicate)CREATE_PREDICATE_METHOD.invoke(result, obj);
                    return ArgumentParseResult.success(new BlockPredicateImpl(predicate));
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }

        @Override
        public @NonNull ArgumentParseResult<@NonNull BlockPredicate> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            return this.parser.parse(commandContext, inputQueue);
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return this.parser.suggestions(commandContext, input);
        }

        static {
            Class tagContainerClass = CraftBukkitReflection.MAJOR_REVISION > 12 && CraftBukkitReflection.MAJOR_REVISION < 16 ? CraftBukkitReflection.needNMSClass("TagRegistry") : CraftBukkitReflection.firstNonNullOrThrow(() -> "tagContainerClass", CraftBukkitReflection.findNMSClass("ITagRegistry"), CraftBukkitReflection.findMCClass("tags.ITagRegistry"), CraftBukkitReflection.findMCClass("tags.TagContainer"), CraftBukkitReflection.findMCClass("core.IRegistry"), CraftBukkitReflection.findMCClass("core.Registry"));
            TAG_CONTAINER_CLASS = tagContainerClass;
            CRAFT_WORLD_CLASS = CraftBukkitReflection.needOBCClass("CraftWorld");
            MINECRAFT_SERVER_CLASS = CraftBukkitReflection.needNMSClassOrElse("MinecraftServer", "net.minecraft.server.MinecraftServer");
            COMMAND_LISTENER_WRAPPER_CLASS = CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find CommandSourceStack class", CraftBukkitReflection.findNMSClass("CommandListenerWrapper"), CraftBukkitReflection.findMCClass("commands.CommandListenerWrapper"), CraftBukkitReflection.findMCClass("commands.CommandSourceStack"));
            ARGUMENT_BLOCK_PREDICATE_CLASS = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"block_predicate"));
            ARGUMENT_BLOCK_PREDICATE_RESULT_CLASS = CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find BlockPredicateArgument$Result class", CraftBukkitReflection.findNMSClass("ArgumentBlockPredicate$b"), CraftBukkitReflection.findMCClass("commands.arguments.blocks.ArgumentBlockPredicate$b"), CraftBukkitReflection.findMCClass("commands.arguments.blocks.BlockPredicateArgument$Result"));
            SHAPE_DETECTOR_BLOCK_CLASS = CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find BlockInWorld class", CraftBukkitReflection.findNMSClass("ShapeDetectorBlock"), CraftBukkitReflection.findMCClass("world.level.block.state.pattern.ShapeDetectorBlock"), CraftBukkitReflection.findMCClass("world.level.block.state.pattern.BlockInWorld"));
            LEVEL_READER_CLASS = CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find LevelReader class", CraftBukkitReflection.findNMSClass("IWorldReader"), CraftBukkitReflection.findMCClass("world.level.IWorldReader"), CraftBukkitReflection.findMCClass("world.level.LevelReader"));
            BLOCK_POSITION_CLASS = CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find BlockPos class", CraftBukkitReflection.findNMSClass("BlockPosition"), CraftBukkitReflection.findMCClass("core.BlockPosition"), CraftBukkitReflection.findMCClass("core.BlockPos"));
            BLOCK_POSITION_CTR = CraftBukkitReflection.needConstructor(BLOCK_POSITION_CLASS, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            SHAPE_DETECTOR_BLOCK_CTR = CraftBukkitReflection.needConstructor(SHAPE_DETECTOR_BLOCK_CLASS, LEVEL_READER_CLASS, BLOCK_POSITION_CLASS, Boolean.TYPE);
            GET_HANDLE_METHOD = CraftBukkitReflection.needMethod(CRAFT_WORLD_CLASS, "getHandle", new Class[0]);
            CREATE_PREDICATE_METHOD = CraftBukkitReflection.firstNonNullOrNull(CraftBukkitReflection.findMethod(ARGUMENT_BLOCK_PREDICATE_RESULT_CLASS, "create", TAG_CONTAINER_CLASS), CraftBukkitReflection.findMethod(ARGUMENT_BLOCK_PREDICATE_RESULT_CLASS, "a", TAG_CONTAINER_CLASS));
            GET_SERVER_METHOD = CraftBukkitReflection.streamMethods(COMMAND_LISTENER_WRAPPER_CLASS).filter(it -> it.getReturnType().equals(MINECRAFT_SERVER_CLASS) && it.getParameterCount() == 0).findFirst().orElseThrow(() -> new IllegalStateException("Could not find CommandSourceStack#getServer."));
            GET_TAG_REGISTRY_METHOD = CraftBukkitReflection.firstNonNullOrNull(CraftBukkitReflection.findMethod(MINECRAFT_SERVER_CLASS, "getTagRegistry", new Class[0]), CraftBukkitReflection.findMethod(MINECRAFT_SERVER_CLASS, "getTags", new Class[0]), CraftBukkitReflection.streamMethods(MINECRAFT_SERVER_CLASS).filter(it -> it.getReturnType().equals(TAG_CONTAINER_CLASS) && it.getParameterCount() == 0).findFirst().orElse(null));
        }

        private static final class BlockPredicateImpl
        implements BlockPredicate {
            private final Predicate<Object> predicate;

            BlockPredicateImpl(@NonNull Predicate<Object> predicate) {
                this.predicate = predicate;
            }

            private boolean testImpl(@NonNull Block block, boolean loadChunks) {
                try {
                    Object blockInWorld = SHAPE_DETECTOR_BLOCK_CTR.newInstance(GET_HANDLE_METHOD.invoke((Object)block.getWorld(), new Object[0]), BLOCK_POSITION_CTR.newInstance(block.getX(), block.getY(), block.getZ()), loadChunks);
                    return this.predicate.test(blockInWorld);
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public boolean test(@NonNull Block block) {
                return this.testImpl(block, false);
            }

            @Override
            public @NonNull BlockPredicate loadChunks() {
                return new BlockPredicate(){

                    @Override
                    public @NonNull BlockPredicate loadChunks() {
                        return this;
                    }

                    @Override
                    public boolean test(Block block) {
                        return this.testImpl(block, true);
                    }
                };
            }
        }
    }

    public static final class Builder<C>
    extends CommandArgument.TypedBuilder<C, BlockPredicate, Builder<C>> {
        private Builder(@NonNull String name) {
            super(BlockPredicate.class, name);
        }

        public @NonNull BlockPredicateArgument<C> build() {
            return new BlockPredicateArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

