/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.fahare.shadow.cloud.bukkit;

import dev.qixils.fahare.shadow.cloud.CloudCapability;
import dev.qixils.fahare.shadow.cloud.bukkit.internal.CraftBukkitReflection;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum CloudBukkitCapabilities implements CloudCapability
{
    BRIGADIER(CraftBukkitReflection.classExists("com.mojang.brigadier.tree.CommandNode") && CraftBukkitReflection.findOBCClass("command.BukkitCommandWrapper") != null),
    NATIVE_BRIGADIER(CraftBukkitReflection.classExists("com.destroystokyo.paper.event.brigadier.CommandRegisteredEvent")),
    COMMODORE_BRIGADIER(BRIGADIER.capable() && !NATIVE_BRIGADIER.capable() && !CraftBukkitReflection.classExists("org.bukkit.entity.Warden")),
    ASYNCHRONOUS_COMPLETION(CraftBukkitReflection.classExists("com.destroystokyo.paper.event.server.AsyncTabCompleteEvent"));

    static final Set<CloudBukkitCapabilities> CAPABLE;
    private final boolean capable;

    private CloudBukkitCapabilities(boolean capable) {
        this.capable = capable;
    }

    boolean capable() {
        return this.capable;
    }

    @Override
    public @NonNull String toString() {
        return this.name();
    }

    static {
        CAPABLE = Arrays.stream(CloudBukkitCapabilities.values()).filter(CloudBukkitCapabilities::capable).collect(Collectors.toSet());
    }
}

