/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.fahare.shadow.cloud.bukkit;

import dev.qixils.fahare.shadow.cloud.CloudCapability;
import dev.qixils.fahare.shadow.cloud.CommandManager;
import dev.qixils.fahare.shadow.cloud.CommandTree;
import dev.qixils.fahare.shadow.cloud.arguments.parser.ParserParameters;
import dev.qixils.fahare.shadow.cloud.brigadier.BrigadierManagerHolder;
import dev.qixils.fahare.shadow.cloud.brigadier.CloudBrigadierManager;
import dev.qixils.fahare.shadow.cloud.bukkit.BukkitCaptionRegistryFactory;
import dev.qixils.fahare.shadow.cloud.bukkit.BukkitCommandMeta;
import dev.qixils.fahare.shadow.cloud.bukkit.BukkitCommandMetaBuilder;
import dev.qixils.fahare.shadow.cloud.bukkit.BukkitCommandPreprocessor;
import dev.qixils.fahare.shadow.cloud.bukkit.BukkitParserParameters;
import dev.qixils.fahare.shadow.cloud.bukkit.BukkitPluginRegistrationHandler;
import dev.qixils.fahare.shadow.cloud.bukkit.BukkitSynchronizer;
import dev.qixils.fahare.shadow.cloud.bukkit.CloudBukkitCapabilities;
import dev.qixils.fahare.shadow.cloud.bukkit.CloudBukkitListener;
import dev.qixils.fahare.shadow.cloud.bukkit.CloudCommodoreManager;
import dev.qixils.fahare.shadow.cloud.bukkit.annotation.specifier.AllowEmptySelection;
import dev.qixils.fahare.shadow.cloud.bukkit.annotation.specifier.DefaultNamespace;
import dev.qixils.fahare.shadow.cloud.bukkit.annotation.specifier.RequireExplicitNamespace;
import dev.qixils.fahare.shadow.cloud.bukkit.argument.NamespacedKeyArgument;
import dev.qixils.fahare.shadow.cloud.bukkit.arguments.selector.MultipleEntitySelector;
import dev.qixils.fahare.shadow.cloud.bukkit.arguments.selector.MultiplePlayerSelector;
import dev.qixils.fahare.shadow.cloud.bukkit.arguments.selector.SingleEntitySelector;
import dev.qixils.fahare.shadow.cloud.bukkit.arguments.selector.SinglePlayerSelector;
import dev.qixils.fahare.shadow.cloud.bukkit.data.ProtoItemStack;
import dev.qixils.fahare.shadow.cloud.bukkit.internal.CraftBukkitReflection;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.BlockPredicateArgument;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.EnchantmentArgument;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.ItemStackArgument;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.ItemStackPredicateArgument;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.MaterialArgument;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.OfflinePlayerArgument;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.PlayerArgument;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.WorldArgument;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.location.Location2D;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.location.Location2DArgument;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.location.LocationArgument;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.selector.MultipleEntitySelectorArgument;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.selector.MultiplePlayerSelectorArgument;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.selector.SingleEntitySelectorArgument;
import dev.qixils.fahare.shadow.cloud.bukkit.parsers.selector.SinglePlayerSelectorArgument;
import dev.qixils.fahare.shadow.cloud.execution.CommandExecutionCoordinator;
import dev.qixils.fahare.shadow.cloud.execution.FilteringCommandSuggestionProcessor;
import dev.qixils.fahare.shadow.cloud.tasks.TaskFactory;
import dev.qixils.fahare.shadow.cloud.tasks.TaskRecipe;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BukkitCommandManager<C>
extends CommandManager<C>
implements BrigadierManagerHolder<C> {
    private final Plugin owningPlugin;
    private final Function<CommandSender, C> commandSenderMapper;
    private final Function<C, CommandSender> backwardsCommandSenderMapper;
    private final TaskFactory taskFactory;
    private boolean splitAliases = false;

    public BukkitCommandManager(@NonNull Plugin owningPlugin, @NonNull Function<@NonNull CommandTree<@NonNull C>, @NonNull CommandExecutionCoordinator<@NonNull C>> commandExecutionCoordinator, @NonNull Function<@NonNull CommandSender, @NonNull C> commandSenderMapper, @NonNull Function<@NonNull C, @NonNull CommandSender> backwardsCommandSenderMapper) throws Exception {
        super(commandExecutionCoordinator, new BukkitPluginRegistrationHandler());
        ((BukkitPluginRegistrationHandler)this.commandRegistrationHandler()).initialize(this);
        this.owningPlugin = owningPlugin;
        this.commandSenderMapper = commandSenderMapper;
        this.backwardsCommandSenderMapper = backwardsCommandSenderMapper;
        BukkitSynchronizer bukkitSynchronizer = new BukkitSynchronizer(owningPlugin);
        this.taskFactory = new TaskFactory(bukkitSynchronizer);
        this.commandSuggestionProcessor(new FilteringCommandSuggestionProcessor(FilteringCommandSuggestionProcessor.Filter.startsWith(true).andTrimBeforeLastSpace()));
        CloudBukkitCapabilities.CAPABLE.forEach(x$0 -> this.registerCapability((CloudCapability)x$0));
        this.registerCapability(CloudCapability.StandardCapabilities.ROOT_COMMAND_DELETION);
        this.registerCommandPreProcessor(new BukkitCommandPreprocessor(this));
        this.parserRegistry().registerParserSupplier(TypeToken.get(World.class), parserParameters -> new WorldArgument.WorldParser());
        this.parserRegistry().registerParserSupplier(TypeToken.get(Material.class), parserParameters -> new MaterialArgument.MaterialParser());
        this.parserRegistry().registerParserSupplier(TypeToken.get(Player.class), parserParameters -> new PlayerArgument.PlayerParser());
        this.parserRegistry().registerParserSupplier(TypeToken.get(OfflinePlayer.class), parserParameters -> new OfflinePlayerArgument.OfflinePlayerParser());
        this.parserRegistry().registerParserSupplier(TypeToken.get(Enchantment.class), parserParameters -> new EnchantmentArgument.EnchantmentParser());
        this.parserRegistry().registerParserSupplier(TypeToken.get(Location.class), parserParameters -> new LocationArgument.LocationParser());
        this.parserRegistry().registerParserSupplier(TypeToken.get(Location2D.class), parserParameters -> new Location2DArgument.Location2DParser());
        this.parserRegistry().registerParserSupplier(TypeToken.get(ProtoItemStack.class), parserParameters -> new ItemStackArgument.Parser());
        this.parserRegistry().registerParserSupplier(TypeToken.get(SingleEntitySelector.class), parserParameters -> new SingleEntitySelectorArgument.SingleEntitySelectorParser());
        this.parserRegistry().registerParserSupplier(TypeToken.get(SinglePlayerSelector.class), parserParameters -> new SinglePlayerSelectorArgument.SinglePlayerSelectorParser());
        this.parserRegistry().registerAnnotationMapper(AllowEmptySelection.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, annotation.value()));
        this.parserRegistry().registerParserSupplier(TypeToken.get(MultipleEntitySelector.class), parserParameters -> new MultipleEntitySelectorArgument.MultipleEntitySelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        this.parserRegistry().registerParserSupplier(TypeToken.get(MultiplePlayerSelector.class), parserParameters -> new MultiplePlayerSelectorArgument.MultiplePlayerSelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        if (CraftBukkitReflection.classExists("org.bukkit.NamespacedKey")) {
            this.registerParserSupplierFor(NamespacedKeyArgument.class);
            this.parserRegistry().registerAnnotationMapper(RequireExplicitNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.REQUIRE_EXPLICIT_NAMESPACE, true));
            this.parserRegistry().registerAnnotationMapper(DefaultNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.DEFAULT_NAMESPACE, annotation.value()));
        }
        if (this.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            this.registerParserSupplierFor(ItemStackPredicateArgument.class);
            this.registerParserSupplierFor(BlockPredicateArgument.class);
        }
        this.owningPlugin.getServer().getPluginManager().registerEvents(new CloudBukkitListener(this), this.owningPlugin);
        this.captionRegistry(new BukkitCaptionRegistryFactory().create());
    }

    public static @NonNull BukkitCommandManager<@NonNull CommandSender> createNative(@NonNull Plugin owningPlugin, @NonNull Function<@NonNull CommandTree<@NonNull CommandSender>, @NonNull CommandExecutionCoordinator<@NonNull CommandSender>> commandExecutionCoordinator) throws Exception {
        return new BukkitCommandManager<CommandSender>(owningPlugin, commandExecutionCoordinator, UnaryOperator.identity(), UnaryOperator.identity());
    }

    public @NonNull TaskRecipe taskRecipe() {
        return this.taskFactory.recipe();
    }

    public @NonNull Plugin getOwningPlugin() {
        return this.owningPlugin;
    }

    @Override
    public @NonNull BukkitCommandMeta createDefaultCommandMeta() {
        return BukkitCommandMetaBuilder.builder().withDescription("").build();
    }

    public final @NonNull Function<@NonNull CommandSender, @NonNull C> getCommandSenderMapper() {
        return this.commandSenderMapper;
    }

    @Override
    public final boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        if (permission.isEmpty()) {
            return true;
        }
        return this.backwardsCommandSenderMapper.apply(sender).hasPermission(permission);
    }

    protected final boolean getSplitAliases() {
        return this.splitAliases;
    }

    protected final void setSplitAliases(boolean value) {
        this.requireState(CommandManager.RegistrationState.BEFORE_REGISTRATION);
        this.splitAliases = value;
    }

    protected final void checkBrigadierCompatibility() throws BrigadierFailureException {
        if (!this.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            throw new BrigadierFailureException(BrigadierFailureReason.VERSION_TOO_LOW, (Throwable)new IllegalArgumentException("Brigadier does not appear to be present on the currently running server. This is usually due to running too old a version of Minecraft (Brigadier is implemented in 1.13 and newer)."));
        }
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public final boolean queryCapability(@NonNull CloudBukkitCapabilities capability) {
        return capability.capable();
    }

    public final @NonNull Set<@NonNull CloudBukkitCapabilities> queryCapabilities() {
        return CloudBukkitCapabilities.CAPABLE;
    }

    public void registerBrigadier() throws BrigadierFailureException {
        this.requireState(CommandManager.RegistrationState.BEFORE_REGISTRATION);
        this.checkBrigadierCompatibility();
        if (!this.hasCapability(CloudBukkitCapabilities.COMMODORE_BRIGADIER)) {
            throw new BrigadierFailureException(BrigadierFailureReason.VERSION_TOO_HIGH);
        }
        try {
            CloudCommodoreManager cloudCommodoreManager = new CloudCommodoreManager(this);
            cloudCommodoreManager.initialize(this);
            this.commandRegistrationHandler(cloudCommodoreManager);
            this.setSplitAliases(true);
        }
        catch (Throwable e) {
            throw new BrigadierFailureException(BrigadierFailureReason.COMMODORE_NOT_PRESENT, e);
        }
    }

    @Override
    public @Nullable CloudBrigadierManager<C, ?> brigadierManager() {
        if (this.commandRegistrationHandler() instanceof CloudCommodoreManager) {
            return ((CloudCommodoreManager)this.commandRegistrationHandler()).brigadierManager();
        }
        return null;
    }

    public final @NonNull String stripNamespace(@NonNull String command) {
        String namespace;
        @NonNull String input = command.charAt(0) == '/' ? command.substring(1) : command;
        if (input.startsWith(namespace = String.format("%s:", this.getOwningPlugin().getName().toLowerCase()))) {
            input = input.substring(namespace.length());
        }
        return input;
    }

    public final @NonNull Function<@NonNull C, @NonNull CommandSender> getBackwardsCommandSenderMapper() {
        return this.backwardsCommandSenderMapper;
    }

    private void registerParserSupplierFor(@NonNull Class<?> argumentClass) {
        try {
            Method registerParserSuppliers = argumentClass.getDeclaredMethod("registerParserSupplier", BukkitCommandManager.class);
            registerParserSuppliers.setAccessible(true);
            registerParserSuppliers.invoke(null, this);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    final void lockIfBrigadierCapable() {
        if (this.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            this.lockRegistration();
        }
    }

    public static final class BrigadierFailureException
    extends IllegalStateException {
        private static final long serialVersionUID = 7816660840063155703L;
        private final BrigadierFailureReason reason;

        public BrigadierFailureException(@NonNull BrigadierFailureReason reason) {
            this.reason = reason;
        }

        public BrigadierFailureException(@NonNull BrigadierFailureReason reason, @NonNull Throwable cause) {
            super(cause);
            this.reason = reason;
        }

        public @NonNull BrigadierFailureReason getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            return String.format("Could not initialize Brigadier mappings. Reason: %s (%s)", this.reason.name().toLowerCase().replace("_", " "), this.getCause() == null ? "" : this.getCause().getMessage());
        }
    }

    public static enum BrigadierFailureReason {
        COMMODORE_NOT_PRESENT,
        VERSION_TOO_LOW,
        VERSION_TOO_HIGH,
        PAPER_BRIGADIER_INITIALIZATION_FAILURE;

    }
}

