/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.fahare.shadow.cloud.arguments.standard;

import dev.qixils.fahare.shadow.cloud.ArgumentDescription;
import dev.qixils.fahare.shadow.cloud.arguments.CommandArgument;
import dev.qixils.fahare.shadow.cloud.arguments.parser.ArgumentParseResult;
import dev.qixils.fahare.shadow.cloud.arguments.parser.ArgumentParser;
import dev.qixils.fahare.shadow.cloud.arguments.standard.IntegerArgument;
import dev.qixils.fahare.shadow.cloud.context.CommandContext;
import dev.qixils.fahare.shadow.cloud.exceptions.parsing.NoInputProvidedException;
import dev.qixils.fahare.shadow.cloud.exceptions.parsing.NumberParseException;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;

@API(status=API.Status.STABLE, since="1.5.0")
public final class ShortArgument<C>
extends CommandArgument<C, Short> {
    private final short min;
    private final short max;

    private ShortArgument(boolean required, @NonNull String name, short min, short max, String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new ShortParser(min, max), defaultValue, Short.class, suggestionsProvider, defaultDescription);
        this.min = min;
        this.max = max;
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return ShortArgument.builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Short> of(@NonNull String name) {
        return ShortArgument.builder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Short> optional(@NonNull String name) {
        return ShortArgument.builder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Short> optional(@NonNull String name, short defaultNum) {
        return ShortArgument.builder(name).asOptionalWithDefault(defaultNum).build();
    }

    public short getMin() {
        return this.min;
    }

    public short getMax() {
        return this.max;
    }

    @API(status=API.Status.STABLE)
    public static final class ShortParser<C>
    implements ArgumentParser<C, Short> {
        @API(status=API.Status.STABLE, since="1.5.0")
        public static final short DEFAULT_MINIMUM = Short.MIN_VALUE;
        @API(status=API.Status.STABLE, since="1.5.0")
        public static final short DEFAULT_MAXIMUM = Short.MAX_VALUE;
        private final short min;
        private final short max;

        public ShortParser(short min, short max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public @NonNull ArgumentParseResult<Short> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(ShortParser.class, commandContext));
            }
            try {
                short value = Short.parseShort(input);
                if (value < this.min || value > this.max) {
                    return ArgumentParseResult.failure(new ShortParseException(input, this, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(value);
            }
            catch (Exception e) {
                return ArgumentParseResult.failure(new ShortParseException(input, this, commandContext));
            }
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return IntegerArgument.IntegerParser.getSuggestions(this.min, this.max, input);
        }

        public short getMax() {
            return this.max;
        }

        public short getMin() {
            return this.min;
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public boolean hasMax() {
            return this.max != Short.MAX_VALUE;
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public boolean hasMin() {
            return this.min != Short.MIN_VALUE;
        }
    }

    @API(status=API.Status.STABLE)
    public static final class Builder<C>
    extends CommandArgument.Builder<C, Short> {
        private short min = Short.MIN_VALUE;
        private short max = Short.MAX_VALUE;

        private Builder(@NonNull String name) {
            super(Short.class, name);
        }

        public @NonNull @This Builder<C> withMin(short min) {
            this.min = min;
            return this;
        }

        public @NonNull @This Builder<C> withMax(short max) {
            this.max = max;
            return this;
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public @NonNull Builder<C> asOptionalWithDefault(short defaultValue) {
            return (Builder)this.asOptionalWithDefault(Short.toString(defaultValue));
        }

        public @NonNull ShortArgument<C> build() {
            return new ShortArgument(this.isRequired(), this.getName(), this.min, this.max, this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    @API(status=API.Status.STABLE, since="1.5.0")
    public static final class ShortParseException
    extends NumberParseException {
        private static final long serialVersionUID = -478674263339091032L;
        private final ShortParser<?> parser;

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.5.0")
        public ShortParseException(@NonNull String input, short min, short max, @NonNull CommandContext<?> commandContext) {
            this(input, new ShortParser(min, max), commandContext);
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public ShortParseException(@NonNull String input, @NonNull ShortParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input, ((ShortParser)parser).min, ((ShortParser)parser).max, ShortParser.class, commandContext);
            this.parser = parser;
        }

        @Override
        public boolean hasMin() {
            return this.parser.hasMin();
        }

        @Override
        public boolean hasMax() {
            return this.parser.hasMax();
        }

        @Override
        public @NonNull String getNumberType() {
            return "short";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShortParseException that = (ShortParseException)o;
            return this.parser.equals(that.parser);
        }

        public int hashCode() {
            return Objects.hash(this.parser);
        }
    }
}

