/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.fahare.shadow.cloud.arguments.standard;

import dev.qixils.fahare.shadow.cloud.ArgumentDescription;
import dev.qixils.fahare.shadow.cloud.arguments.CommandArgument;
import dev.qixils.fahare.shadow.cloud.arguments.parser.ArgumentParseResult;
import dev.qixils.fahare.shadow.cloud.arguments.parser.ArgumentParser;
import dev.qixils.fahare.shadow.cloud.context.CommandContext;
import dev.qixils.fahare.shadow.cloud.exceptions.parsing.NoInputProvidedException;
import dev.qixils.fahare.shadow.cloud.exceptions.parsing.NumberParseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.TreeSet;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;

@API(status=API.Status.STABLE)
public final class IntegerArgument<C>
extends CommandArgument<C, Integer> {
    private static final int MAX_SUGGESTIONS_INCREMENT = 10;
    private static final int NUMBER_SHIFT_MULTIPLIER = 10;
    private final int min;
    private final int max;

    private IntegerArgument(boolean required, @NonNull String name, int min, int max, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new IntegerParser(min, max), defaultValue, Integer.class, suggestionsProvider, defaultDescription);
        this.min = min;
        this.max = max;
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return IntegerArgument.builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Integer> of(@NonNull String name) {
        return IntegerArgument.builder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Integer> optional(@NonNull String name) {
        return IntegerArgument.builder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Integer> optional(@NonNull String name, int defaultNum) {
        return IntegerArgument.builder(name).asOptionalWithDefault(defaultNum).build();
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    @API(status=API.Status.STABLE)
    public static final class IntegerParser<C>
    implements ArgumentParser<C, Integer> {
        @API(status=API.Status.STABLE, since="1.5.0")
        public static final int DEFAULT_MINIMUM = Integer.MIN_VALUE;
        @API(status=API.Status.STABLE, since="1.5.0")
        public static final int DEFAULT_MAXIMUM = Integer.MAX_VALUE;
        private final int min;
        private final int max;

        public IntegerParser(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public static @NonNull List<@NonNull String> getSuggestions(long min, long max, @NonNull String input) {
            TreeSet<Long> numbers = new TreeSet<Long>();
            try {
                long inputNum = Long.parseLong(input.equals("-") ? "-0" : (input.isEmpty() ? "0" : input));
                long inputNumAbsolute = Math.abs(inputNum);
                numbers.add(inputNumAbsolute);
                for (int i = 0; i < 10 && inputNum * 10L + (long)i <= max; ++i) {
                    numbers.add(inputNumAbsolute * 10L + (long)i);
                }
                LinkedList<String> suggestions = new LinkedList<String>();
                Iterator iterator = numbers.iterator();
                while (iterator.hasNext()) {
                    long number = (Long)iterator.next();
                    if (input.startsWith("-")) {
                        number = -number;
                    }
                    if (number < min || number > max) continue;
                    suggestions.add(String.valueOf(number));
                }
                return suggestions;
            }
            catch (Exception ignored) {
                return Collections.emptyList();
            }
        }

        @Override
        public @NonNull ArgumentParseResult<Integer> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(IntegerParser.class, commandContext));
            }
            try {
                int value = Integer.parseInt(input);
                if (value < this.min || value > this.max) {
                    return ArgumentParseResult.failure(new IntegerParseException(input, this, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(value);
            }
            catch (Exception e) {
                return ArgumentParseResult.failure(new IntegerParseException(input, this, commandContext));
            }
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public boolean hasMax() {
            return this.max != Integer.MAX_VALUE;
        }

        public boolean hasMin() {
            return this.min != Integer.MIN_VALUE;
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return IntegerParser.getSuggestions(this.min, this.max, input);
        }
    }

    @API(status=API.Status.STABLE)
    public static final class Builder<C>
    extends CommandArgument.Builder<C, Integer> {
        private int min = Integer.MIN_VALUE;
        private int max = Integer.MAX_VALUE;

        private Builder(@NonNull String name) {
            super(Integer.class, name);
        }

        public @NonNull @This Builder<C> withMin(int min) {
            this.min = min;
            return this;
        }

        public @NonNull @This Builder<C> withMax(int max) {
            this.max = max;
            return this;
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public @NonNull Builder<C> asOptionalWithDefault(int defaultValue) {
            return (Builder)this.asOptionalWithDefault(Integer.toString(defaultValue));
        }

        public @NonNull IntegerArgument<C> build() {
            return new IntegerArgument(this.isRequired(), this.getName(), this.min, this.max, this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    @API(status=API.Status.STABLE)
    public static final class IntegerParseException
    extends NumberParseException {
        private static final long serialVersionUID = -6933923056628373853L;
        private final IntegerParser<?> parser;

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.5.0")
        public IntegerParseException(@NonNull String input, int min, int max, @NonNull CommandContext<?> commandContext) {
            this(input, new IntegerParser(min, max), commandContext);
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public IntegerParseException(@NonNull String input, @NonNull IntegerParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input, ((IntegerParser)parser).min, ((IntegerParser)parser).max, IntegerParser.class, commandContext);
            this.parser = parser;
        }

        @Override
        public boolean hasMin() {
            return this.parser.hasMin();
        }

        @Override
        public boolean hasMax() {
            return this.parser.hasMax();
        }

        @Override
        public @NonNull String getNumberType() {
            return "integer";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntegerParseException that = (IntegerParseException)o;
            return this.parser.equals(that.parser);
        }

        public int hashCode() {
            return Objects.hash(this.parser);
        }
    }
}

