/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.fahare.shadow.cloud.arguments.parser;

import dev.qixils.fahare.shadow.cloud.arguments.parser.ArgumentParseResult;
import dev.qixils.fahare.shadow.cloud.arguments.parser.ArgumentParser;
import dev.qixils.fahare.shadow.cloud.context.CommandContext;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE, since="1.5.0")
public final class MappedArgumentParser<C, I, O>
implements ArgumentParser<C, O> {
    private final ArgumentParser<C, I> base;
    private final BiFunction<CommandContext<C>, I, ArgumentParseResult<O>> mapper;

    MappedArgumentParser(ArgumentParser<C, I> base, BiFunction<CommandContext<C>, I, ArgumentParseResult<O>> mapper) {
        this.base = base;
        this.mapper = mapper;
    }

    public ArgumentParser<C, I> getBaseParser() {
        return this.base;
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull O> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
        ArgumentParseResult<@NonNull I> baseResult = this.base.parse(commandContext, inputQueue);
        return baseResult.flatMapParsedValue(value -> this.mapper.apply(commandContext, value));
    }

    @Override
    public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
        return this.base.suggestions(commandContext, input);
    }

    @Override
    public <O1> @NonNull ArgumentParser<C, O1> map(BiFunction<CommandContext<C>, O, ArgumentParseResult<O1>> mapper) {
        return new MappedArgumentParser<C, Object, O>(this.base, (ctx, original) -> this.mapper.apply((CommandContext<C>)ctx, (I)original).flatMapParsedValue(value -> (ArgumentParseResult)mapper.apply((CommandContext)ctx, (Object)value)));
    }

    @Override
    public boolean isContextFree() {
        return this.base.isContextFree();
    }

    @Override
    public int getRequestedArgumentCount() {
        return this.base.getRequestedArgumentCount();
    }

    public int hashCode() {
        return 31 + this.base.hashCode() + 7 * this.mapper.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof MappedArgumentParser)) {
            return false;
        }
        MappedArgumentParser that = (MappedArgumentParser)other;
        return this.base.equals(that.base) && this.mapper.equals(that.mapper);
    }

    public String toString() {
        return "MappedArgumentParser{base=" + this.base + ',' + "mapper=" + this.mapper + '}';
    }
}

