/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.fahare;

import dev.qixils.fahare.IOUtils;
import dev.qixils.fahare.shadow.cloud.Command;
import dev.qixils.fahare.shadow.cloud.bukkit.CloudBukkitCapabilities;
import dev.qixils.fahare.shadow.cloud.execution.CommandExecutionCoordinator;
import dev.qixils.fahare.shadow.cloud.minecraft.extras.MinecraftExceptionHandler;
import dev.qixils.fahare.shadow.cloud.paper.PaperCommandManager;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.translation.Translator;
import net.kyori.adventure.util.UTF8ResourceBundleControl;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Fahare
extends JavaPlugin
implements Listener {
    private static final NamespacedKey REAL_OVERWORLD_KEY = NamespacedKey.minecraft((String)"overworld");
    private static final Random RANDOM = new Random();
    private final NamespacedKey fakeOverworldKey = new NamespacedKey((Plugin)this, "overworld");
    private final NamespacedKey limboWorldKey = new NamespacedKey((Plugin)this, "limbo");
    private final Map<UUID, Integer> deaths = new HashMap<UUID, Integer>();
    private World limboWorld;
    private Path worldContainer;
    @Nullable
    private Path backupContainer;
    private boolean resetting = false;
    private boolean backup = true;
    private boolean autoReset = true;
    private boolean anyDeath = false;
    private int lives = 1;

    @NotNull
    private static World overworld() {
        return Objects.requireNonNull(Bukkit.getWorld((NamespacedKey)REAL_OVERWORLD_KEY), "Overworld not found");
    }

    @NotNull
    private World fakeOverworld() {
        return Objects.requireNonNullElseGet(Bukkit.getWorld((NamespacedKey)this.fakeOverworldKey), this::createFakeOverworld);
    }

    @NotNull
    private World createFakeOverworld() {
        WorldCreator creator = new WorldCreator(this.fakeOverworldKey).copy(Fahare.overworld()).seed(RANDOM.nextLong());
        return Objects.requireNonNull(creator.createWorld(), "Could not load fake overworld");
    }

    public void onEnable() {
        this.loadConfig();
        this.worldContainer = Bukkit.getWorldContainer().toPath();
        this.backupContainer = this.worldContainer.resolve("fahare-backups");
        if (!Files.exists(this.backupContainer, new LinkOption[0])) {
            try {
                Files.createDirectory(this.backupContainer, new FileAttribute[0]);
            }
            catch (Exception e) {
                this.getComponentLogger().error((Component)Component.translatable((String)"fhr.log.error.backup-folder"), (Throwable)e);
                this.backupContainer = null;
            }
        }
        TranslationRegistry registry = TranslationRegistry.create((Key)new NamespacedKey((Plugin)this, "translations"));
        registry.defaultLocale(Locale.US);
        for (Locale locale : List.of(Locale.US)) {
            ResourceBundle bundle = ResourceBundle.getBundle("Fahare", locale, UTF8ResourceBundleControl.get());
            registry.registerAll(locale, bundle, false);
        }
        GlobalTranslator.translator().addSource((Translator)registry);
        WorldCreator creator = new WorldCreator(this.limboWorldKey).type(WorldType.FLAT).generateStructures(false).generatorSettings("{\"biome\":\"minecraft:the_end\",\"layers\":[{\"block\":\"minecraft:air\",\"height\":1}]}");
        this.limboWorld = creator.createWorld();
        World fakeOverworld = this.createFakeOverworld();
        try {
            PaperCommandManager<CommandSender> commandManager = PaperCommandManager.createNative((Plugin)this, CommandExecutionCoordinator.simpleCoordinator());
            if (commandManager.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
                try {
                    commandManager.registerBrigadier();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Command.Builder cmd = commandManager.commandBuilder("fahare", new String[0]);
            commandManager.command(cmd.literal("reset", new String[0]).permission("fahare.reset").handler(c -> {
                ((CommandSender)c.getSender()).sendMessage((Component)Component.translatable((String)"fhr.chat.resetting"));
                this.reset();
            }));
            new MinecraftExceptionHandler().withDefaultHandlers().withDecorator(component -> component.colorIfAbsent((TextColor)NamedTextColor.RED)).apply(commandManager, sender -> sender);
        }
        catch (Exception e) {
            this.getComponentLogger().error((Component)Component.translatable((String)"fhr.log.error.commands"), (Throwable)e);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            Location destination = fakeOverworld.getSpawnLocation();
            for (Player player : Fahare.overworld().getPlayers()) {
                player.teleport(destination);
            }
        }, 1L, 1L);
    }

    private void loadConfig() {
        this.saveDefaultConfig();
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.backup = config.getBoolean("backup", this.backup);
        this.autoReset = config.getBoolean("auto-reset", this.autoReset);
        this.anyDeath = config.getBoolean("any-death", this.anyDeath);
        this.lives = Math.max(1, config.getInt("lives", this.lives));
    }

    public int getDeathsFor(UUID player) {
        return this.deaths.getOrDefault(player, 0);
    }

    public void addDeathTo(UUID player) {
        this.deaths.put(player, this.getDeathsFor(player) + 1);
    }

    public boolean isDead(UUID player) {
        return this.getDeathsFor(player) >= this.lives;
    }

    public boolean isAlive(UUID player) {
        return !this.isDead(player);
    }

    private void deleteNextWorld(List<World> worlds, @Nullable Path backupDestination) {
        if (worlds.isEmpty()) {
            World overworld = this.fakeOverworld();
            Location spawn = overworld.getSpawnLocation();
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.setGameMode(GameMode.SURVIVAL);
                player.teleport(spawn);
            }
            this.resetting = false;
            return;
        }
        if (Bukkit.isTickingWorlds()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.deleteNextWorld(worlds, backupDestination), 1L);
            return;
        }
        World world = worlds.remove(0);
        String worldName = world.getName();
        TextComponent worldKey = Component.text((String)worldName);
        WorldCreator creator = new WorldCreator(worldName, world.getKey());
        creator.copy(world).seed(RANDOM.nextLong());
        if (Bukkit.unloadWorld((World)world, (boolean)this.backup)) {
            try {
                Path worldFolder = this.worldContainer.resolve(worldName);
                TextComponent arg = Component.text((String)worldFolder.toString());
                if (backupDestination != null) {
                    this.getComponentLogger().info((Component)Component.translatable((String)"fhr.log.info.backup", (ComponentLike[])new ComponentLike[]{arg}));
                    Files.move(worldFolder, backupDestination.resolve(worldName), new CopyOption[0]);
                } else {
                    this.getComponentLogger().info((Component)Component.translatable((String)"fhr.log.info.delete", (ComponentLike[])new ComponentLike[]{arg}));
                    IOUtils.deleteDirectory(worldFolder);
                }
                creator.createWorld();
                Bukkit.getServer().sendMessage((Component)Component.translatable((String)"fhr.chat.success", (ComponentLike[])new ComponentLike[]{worldKey}));
            }
            catch (Exception e) {
                TranslatableComponent error = Component.translatable((String)"fhr.chat.error", (TextColor)NamedTextColor.RED, (ComponentLike[])new ComponentLike[]{worldKey});
                Audience.audience((Iterable)Bukkit.getOnlinePlayers()).sendMessage((Component)error);
                this.getComponentLogger().warn((Component)error, (Throwable)e);
            }
        } else {
            Bukkit.getServer().sendMessage((Component)Component.translatable((String)"fhr.chat.error", (TextColor)NamedTextColor.RED, (ComponentLike[])new ComponentLike[]{worldKey}));
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.deleteNextWorld(worlds, backupDestination), 1L);
    }

    public synchronized void reset() {
        if (this.resetting) {
            return;
        }
        if (this.limboWorld == null) {
            return;
        }
        this.deaths.clear();
        Location destination = new Location(this.limboWorld, 0.0, 100.0, 0.0);
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.setGameMode(GameMode.SPECTATOR);
            player.getInventory().clear();
            player.getEnderChest().clear();
            player.setLevel(0);
            player.setExp(0.0f);
            player.teleport(destination);
        }
        if (Bukkit.isTickingWorlds()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, this::reset, 1L);
            return;
        }
        this.resetting = true;
        Path backupDestination = null;
        if (this.backup && this.backupContainer != null) {
            String name;
            String baseName = DateTimeFormatter.ISO_LOCAL_DATE.format(LocalDate.now());
            int attempt = 1;
            while (Files.exists(backupDestination = this.backupContainer.resolve(name = baseName + "-" + attempt++), new LinkOption[0])) {
            }
            try {
                Files.createDirectory(backupDestination, new FileAttribute[0]);
            }
            catch (Exception e) {
                this.getComponentLogger().error((Component)Component.translatable((String)"fhr.log.error.backup-subfolder", (ComponentLike[])new ComponentLike[]{Component.text((String)backupDestination.toString())}), (Throwable)e);
                backupDestination = null;
            }
        }
        List<World> worlds = Bukkit.getWorlds().stream().filter(w -> !w.getKey().equals((Object)this.limboWorldKey) && !w.getKey().equals((Object)REAL_OVERWORLD_KEY)).collect(Collectors.toList());
        this.deleteNextWorld(worlds, backupDestination);
    }

    public void resetCheck(boolean death) {
        if (!this.autoReset) {
            return;
        }
        if (this.anyDeath && death) {
            this.reset();
            return;
        }
        Collection players = Bukkit.getOnlinePlayers();
        if (players.isEmpty()) {
            return;
        }
        for (Player player : players) {
            if (!this.isAlive(player.getUniqueId())) continue;
            return;
        }
        this.reset();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        this.addDeathTo(player.getUniqueId());
        if (this.isAlive(player.getUniqueId())) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            player.setGameMode(GameMode.SPECTATOR);
            player.spigot().respawn();
            this.resetCheck(true);
        }, 1L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityPortal(EntityPortalEvent event) {
        Location to = event.getTo();
        if (to == null) {
            return;
        }
        World toWorld = to.getWorld();
        if (toWorld == null) {
            return;
        }
        if (!toWorld.getKey().equals((Object)REAL_OVERWORLD_KEY)) {
            return;
        }
        if (event.getPortalType() == PortalType.ENDER) {
            event.setTo(this.fakeOverworld().getSpawnLocation());
        } else {
            to.setWorld(this.fakeOverworld());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerPortal(PlayerPortalEvent event) {
        Location to = event.getTo();
        World toWorld = to.getWorld();
        if (toWorld == null) {
            return;
        }
        if (!toWorld.getKey().equals((Object)REAL_OVERWORLD_KEY)) {
            return;
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.END_PORTAL) {
            event.setTo(this.fakeOverworld().getSpawnLocation());
        } else {
            to.setWorld(this.fakeOverworld());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.getWorld().getKey().equals((Object)REAL_OVERWORLD_KEY)) {
            player.teleport(this.fakeOverworld().getSpawnLocation());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Location destination = event.getRespawnLocation();
        if (destination.getWorld().getKey().equals((Object)REAL_OVERWORLD_KEY)) {
            event.setRespawnLocation(this.fakeOverworld().getSpawnLocation());
        }
    }
}

