/*
 * Decompiled with CFR 0.152.
 */
package com.protoxon.proxyTransfer;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.protoxon.proxyTransfer.ProxyTransfer;
import com.protoxon.proxyTransfer.Transfer;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class TransferCommand {
    public static void register() {
        CommandManager commandManager = ProxyTransfer.proxy.getCommandManager();
        LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)"transfer");
        root.executes(TransferCommand::handleRootCommand);
        root.then(TransferCommand.transfer());
        BrigadierCommand brigadierCommand = new BrigadierCommand(root);
        CommandMeta commandMeta = commandManager.metaBuilder("transfer").plugin((Object)ProxyTransfer.plugin).build();
        commandManager.register(commandMeta, (Command)brigadierCommand);
    }

    private static int handleRootCommand(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        source.sendMessage((Component)Component.text((String)"Invalid Command Usage!"));
        if (source.hasPermission("proxytransfer.others")) {
            source.sendMessage((Component)Component.text((String)"/transfer <host> [player|local|all]"));
            return 0;
        }
        source.sendMessage((Component)Component.text((String)"/transfer <host>"));
        return 0;
    }

    public static RequiredArgumentBuilder<CommandSource, String> transfer() {
        return (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"target", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            String input = builder.getRemaining().toLowerCase();
            if (input.contains(" ")) {
                builder.suggest("all");
                builder.suggest("local");
                ProxyTransfer.proxy.getAllPlayers().forEach(player -> builder.suggest(player.getUsername()));
            }
            return builder.buildFuture();
        }).executes(context -> {
            String playerContext;
            int port;
            CommandSource source = (CommandSource)context.getSource();
            if (!(source instanceof Player)) {
                source.sendMessage((Component)Component.text((String)"This command can only be run by a player.", (TextColor)NamedTextColor.RED));
                return 0;
            }
            Player executor = (Player)source;
            String input = StringArgumentType.getString((CommandContext)context, (String)"target").trim();
            String[] parts = input.split("\\s+");
            if (parts.length == 0) {
                source.sendMessage((Component)Component.text((String)"Invalid usage. Please provide a host.", (TextColor)NamedTextColor.RED));
                return 0;
            }
            String hostPort = parts[0];
            String[] hostParts = hostPort.split(":", 2);
            String host = hostParts[0];
            int n = port = hostParts.length > 1 ? TransferCommand.getPort(hostParts[1]) : 25565;
            if (port == -1) {
                source.sendMessage((Component)Component.text((String)"Error: Invalid port.", (TextColor)NamedTextColor.RED));
                return 0;
            }
            String string = playerContext = parts.length > 1 ? parts[1] : null;
            if (playerContext == null) {
                Transfer.transferPlayer(executor, host, port);
                return 1;
            }
            if (!source.hasPermission("proxytransfer.others")) {
                source.sendMessage((Component)Component.text((String)"You don't have permission to transfer others. You must have the \"proxytransfer.others\" permission.", (TextColor)NamedTextColor.RED));
                return 0;
            }
            switch (playerContext.toLowerCase()) {
                case "all": {
                    for (Player p : ProxyTransfer.proxy.getAllPlayers()) {
                        Transfer.transferPlayer(p, host, port);
                    }
                    return 1;
                }
                case "local": {
                    for (Player p : TransferCommand.getPlayersOnSameServer(source)) {
                        Transfer.transferPlayer(p, host, port);
                    }
                    return 1;
                }
            }
            Player target = TransferCommand.getPlayer(playerContext);
            if (target == null) {
                source.sendMessage((Component)Component.text((String)("Player " + playerContext + " not found."), (TextColor)NamedTextColor.RED));
                return 0;
            }
            Transfer.transferPlayer(target, host, port);
            return 1;
        });
    }

    public static int getPort(String context) {
        String[] parts = context.split(":", 2);
        if (parts.length < 2) {
            return 25565;
        }
        try {
            return Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static Player getPlayer(String username) {
        Optional player = ProxyTransfer.proxy.getPlayer(username);
        return player.orElse(null);
    }

    public static Collection<Player> getPlayersOnSameServer(CommandSource source) {
        if (!(source instanceof Player)) {
            ProxyTransfer.logger.error("You must be a player to use the local argument!");
            return Collections.emptyList();
        }
        Player player = (Player)source;
        return player.getCurrentServer().map(serverConnection -> serverConnection.getServer().getPlayersConnected()).orElse(Collections.emptyList());
    }
}

