/*
 * Decompiled with CFR 0.152.
 */
package com.protoxon.proxyTransfer;

import com.google.inject.Inject;
import com.protoxon.proxyTransfer.Transfer;
import com.protoxon.proxyTransfer.TransferCommand;
import com.protoxon.proxyTransfer.utils.Color;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.util.Optional;
import org.slf4j.Logger;

@Plugin(id="proxytransfer", name="ProxyTransfer", version="1.0", authors={"protoxon"})
public class ProxyTransfer {
    private static final ChannelIdentifier TRANSFER_CHANNEL = MinecraftChannelIdentifier.create((String)"proxytransfer", (String)"forward");
    @Inject
    public static Logger logger;
    public static ProxyServer proxy;
    public static ProxyTransfer plugin;

    @Inject
    public ProxyTransfer(ProxyServer proxy, Logger logger) {
        ProxyTransfer.logger = logger;
        ProxyTransfer.proxy = proxy;
        plugin = this;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        System.out.println(this.startMessage());
        TransferCommand.register();
        proxy.getChannelRegistrar().register(new ChannelIdentifier[]{TRANSFER_CHANNEL});
        proxy.getEventManager().register((Object)this, (Object)new TransferMessageListener());
    }

    public String startMessage() {
        return String.valueOf((Object)Color.GREEN) + "[ProxyTransfer] " + String.valueOf((Object)Color.YELLOW) + "v" + this.getVersion() + String.valueOf((Object)Color.RESET) + " by " + String.valueOf((Object)Color.MAGENTA) + this.getAuthors() + String.valueOf((Object)Color.RESET);
    }

    public String getVersion() {
        Optional pluginContainer = proxy.getPluginManager().getPlugin("proxytransfer");
        if (pluginContainer.isPresent()) {
            PluginDescription description = ((PluginContainer)pluginContainer.get()).getDescription();
            return description.getVersion().orElse("unknown");
        }
        return "unknown";
    }

    public String getAuthors() {
        return proxy.getPluginManager().getPlugin("proxytransfer").map(p -> String.join((CharSequence)", ", p.getDescription().getAuthors())).orElse("unknown");
    }

    public static class TransferMessageListener {
        @Subscribe
        public void onPluginMessage(PluginMessageEvent event) {
            if (!event.getIdentifier().equals(TRANSFER_CHANNEL)) {
                return;
            }
            String resultString = new String(event.getData());
            String[] parts = resultString.split(";");
            Player player = (Player)proxy.getPlayer(parts[0]).get();
            String host = parts[1];
            int port = Integer.parseInt(parts[2]);
            Transfer.transferPlayer(player, host, port);
        }
    }
}

